/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import eglx.lang.SysLib;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.Servlet;
import org.eclipse.edt.ide.rui.internal.testserver.ConfigServlet;
import org.eclipse.edt.javart.ide.IDEResourceLocator;
import org.eclipse.edt.javart.services.servlet.proxy.AjaxProxyServlet;
import org.eclipse.edt.javart.services.servlet.rest.rpc.PreviewServiceServlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.log.StdErrLog;

public class TestServer {
    private static boolean debug;

    public static void main(String[] args) throws Exception {
        String defaultDD;
        String ddFiles;
        String serviceMappings;
        String contextRoot;
        Integer idePort;
        Integer port;
        block42: {
            port = null;
            idePort = null;
            contextRoot = null;
            serviceMappings = null;
            ddFiles = null;
            defaultDD = "";
            int i = 0;
            while (i < args.length) {
                if ("-p".equals(args[i])) {
                    if (i + 1 < args.length) {
                        try {
                            port = Integer.parseInt(args[i + 1]);
                            ++i;
                        }
                        catch (NumberFormatException numberFormatException) {
                            TestServer.log("Unable to parse port value \"" + args[i + 1] + "\"");
                        }
                    } else {
                        TestServer.log("Missing port value for argument \"" + args[i] + "\"");
                    }
                }
                if ("-i".equals(args[i])) {
                    if (i + 1 < args.length) {
                        try {
                            idePort = Integer.parseInt(args[i + 1]);
                            ++i;
                        }
                        catch (NumberFormatException numberFormatException) {
                            TestServer.log("Unable to parse IDE port value \"" + args[i + 1] + "\"");
                        }
                    } else {
                        TestServer.log("Missing IDE port value for argument \"" + args[i] + "\"");
                    }
                } else if ("-c".equals(args[i])) {
                    if (i + 1 < args.length) {
                        contextRoot = args[i + 1].trim();
                        ++i;
                    } else {
                        TestServer.log("Missing context root value for argument \"" + args[i] + "\"");
                    }
                } else if ("-s".equals(args[i])) {
                    if (i + 1 < args.length) {
                        serviceMappings = args[i + 1].trim();
                        ++i;
                    } else {
                        TestServer.log("Missing service mapping value for argument \"" + args[i] + "\"");
                    }
                } else if ("-dd".equals(args[i])) {
                    if (i + 1 < args.length) {
                        ddFiles = args[i + 1].trim();
                        ++i;
                    } else {
                        TestServer.log("Missing deployment descriptor file list value for argument \"" + args[i] + "\"");
                    }
                } else if ("-ddd".equals(args[i])) {
                    if (i + 1 < args.length) {
                        defaultDD = args[i + 1].trim();
                        ++i;
                    } else {
                        TestServer.log("Missing default deployment descriptor value for argument \"" + args[i] + "\"");
                    }
                } else if ("-d".equals(args[i])) {
                    debug = true;
                } else if (args[i].startsWith("-")) {
                    TestServer.log("Unrecognized option \"" + args[i] + "\"");
                } else {
                    TestServer.log("Skipping value \"" + args[i] + "\"");
                }
                ++i;
            }
            if (contextRoot == null || contextRoot.length() == 0) {
                System.err.println("Context root argument not specified, cannot start the server");
                return;
            }
            if (port == null) {
                System.err.println("Port argument not specified, cannot start the server");
                return;
            }
            if (idePort == null) {
                System.err.println("IDE port argument not specified, cannot start the server");
                return;
            }
            if (port < 0) {
                System.err.println("Port argument \"" + port + "\" is invalid, cannot start the server");
                return;
            }
            if (idePort < 0) {
                System.err.println("IDE port argument \"" + idePort + "\" is invalid, cannot start the server");
                return;
            }
            try {
                contextRoot = String.valueOf('/') + URLEncoder.encode(contextRoot.charAt(0) == '/' ? contextRoot.substring(1) : contextRoot, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (contextRoot.charAt(0) == '/') break block42;
                contextRoot = "/" + contextRoot;
            }
        }
        Context context = new Context(1);
        context.setContextPath(contextRoot);
        PreviewServiceServlet previewServlet = new PreviewServiceServlet();
        ServletHolder holder = new ServletHolder((Servlet)previewServlet);
        context.addServlet(holder, "/restservices/*");
        context.addServlet(new ServletHolder((Servlet)new AjaxProxyServlet()), "/___proxy");
        IDEResourceLocator locator = new IDEResourceLocator(idePort.intValue());
        locator.setDefaultDD(defaultDD);
        SysLib.setResourceLocator((SysLib.ResourceLocator)locator);
        ConfigServlet configServlet = new ConfigServlet(previewServlet, locator);
        context.addServlet(new ServletHolder((Servlet)configServlet), "/config");
        if (serviceMappings != null && serviceMappings.length() > 0) {
            configServlet.parseMappings(serviceMappings, true);
        }
        if (ddFiles != null && ddFiles.length() > 0) {
            configServlet.parseDDFiles(ddFiles, true);
        }
        Server server = new Server(port.intValue());
        server.setHandler((Handler)context);
        if (debug) {
            StdErrLog log = new StdErrLog();
            log.setDebugEnabled(true);
            Log.setLog((Logger)log);
        }
        server.start();
        server.join();
    }

    public static void log(String msg) {
        if (debug) {
            System.err.println(msg);
        }
    }

    public static void log(Exception e) {
        if (debug) {
            e.printStackTrace();
        }
    }
}

