/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.testserver.ClasspathUtil;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerConfiguration;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerMessages;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerUpdateErrorDialog;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

public class TestServerManager
implements TestServerConfiguration.TerminationListener,
IResourceChangeListener {
    private Object syncObj = new Object();
    private HashMap<IProject, TestServerConfiguration> serverConfigMap = new HashMap();
    private Map<IProject, DDPreferenceListener> listenerMap = new HashMap<IProject, DDPreferenceListener>();

    public TestServerManager() {
        IProject[] projects;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                this.addDDListener(project);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Object object = this.syncObj;
        synchronized (object) {
            if (this.listenerMap != null) {
                for (Map.Entry entry : this.listenerMap.entrySet()) {
                    Preferences prefs = new ProjectScope((IProject)entry.getKey()).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("DefaultDeploymentDescriptorPath");
                    if (!(prefs instanceof IEclipsePreferences)) continue;
                    ((IEclipsePreferences)prefs).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)entry.getValue());
                }
                this.listenerMap = null;
            }
            if (this.serverConfigMap != null) {
                for (TestServerConfiguration testServerConfiguration : this.serverConfigMap.values()) {
                    try {
                        testServerConfiguration.terminate();
                    }
                    catch (DebugException debugException) {}
                }
                this.serverConfigMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDDListener(IProject project) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.listenerMap == null || this.listenerMap.containsKey(project)) {
                return;
            }
            Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("DefaultDeploymentDescriptorPath");
            if (prefs instanceof IEclipsePreferences) {
                DDPreferenceListener listener = new DDPreferenceListener(project);
                ((IEclipsePreferences)prefs).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
                this.listenerMap.put(project, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDDListener(IProject project) {
        Preferences prefs;
        DDPreferenceListener listener;
        Object object = this.syncObj;
        synchronized (object) {
            if (this.listenerMap == null) {
                return;
            }
            listener = this.listenerMap.remove(project);
        }
        if (listener != null && (prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("DefaultDeploymentDescriptorPath")) instanceof IEclipsePreferences) {
            ((IEclipsePreferences)prefs).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestServerConfiguration getServerConfiguration(IProject project, boolean debugMode) {
        TestServerConfiguration config;
        Object object = this.syncObj;
        synchronized (object) {
            block8: {
                if (this.serverConfigMap != null) break block8;
                return null;
            }
            config = this.serverConfigMap.get(project);
        }
        if (config == null) {
            config = new TestServerConfiguration(project, debugMode);
            config.addTerminationListener(this);
            this.addDDListener(project);
            object = this.syncObj;
            synchronized (object) {
                this.serverConfigMap.put(project, config);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerConfiguration(IProject project) {
        this.removeDDListener(project);
        Object object = this.syncObj;
        synchronized (object) {
            if (this.serverConfigMap != null) {
                this.serverConfigMap.remove(project);
            }
        }
    }

    @Override
    public void terminated(TestServerConfiguration config) {
        this.removeServerConfiguration(config.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                class CheckClasspath
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    CheckClasspath() {
                    }
                }
                int mapSize;
                if (event.getDelta() == null) break;
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource;
                    IResourceDelta child = iResourceDeltaArray[n2];
                    if ((child.getFlags() & 0x4000) != 0) {
                        resource = child.getResource();
                        if (resource.getType() == 4) {
                            this.addDDListener(resource.getProject());
                        }
                    } else if (child.getKind() == 4 && (resource = child.getResource()).getType() == 4) {
                        this.addDDListener(resource.getProject());
                    }
                    ++n2;
                }
                Object object = this.syncObj;
                synchronized (object) {
                    mapSize = this.serverConfigMap.size();
                }
                if (mapSize <= 0) break;
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta == null) {
                                return false;
                            }
                            switch (delta.getKind()) {
                                case 4: {
                                    if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x100000) == 0) {
                                        return true;
                                    }
                                }
                                case 1: 
                                case 2: {
                                    if (!ClasspathUtil.canAffectClasspath(delta.getFullPath().lastSegment())) break;
                                    throw new CheckClasspath();
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException ce) {
                    Activator.getDefault().log(ce.getMessage(), (Exception)((Object)ce));
                }
                catch (CheckClasspath checkClasspath) {
                    this.handleClasspathChanged();
                }
                break;
            }
            case 2: 
            case 4: {
                IResource resource = event.getResource();
                if (resource == null || resource.getType() != 4) break;
                this.removeDDListener(resource.getProject());
                TestServerConfiguration config = null;
                Object object = this.syncObj;
                synchronized (object) {
                    if (this.serverConfigMap != null) {
                        config = this.serverConfigMap.remove(resource);
                    }
                }
                if (config == null) break;
                try {
                    config.terminate();
                }
                catch (DebugException debugException) {}
                config.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClasspathChanged() {
        HashMap mapClone;
        final ArrayList<TestServerConfiguration> configsWithChanges = new ArrayList<TestServerConfiguration>();
        Object object = this.syncObj;
        synchronized (object) {
            if (this.serverConfigMap == null) {
                return;
            }
            mapClone = (HashMap)this.serverConfigMap.clone();
        }
        if (mapClone != null) {
            for (final TestServerConfiguration config : mapClone.values()) {
                if (!config.hasClasspathChanged()) continue;
                configsWithChanges.add(config);
            }
        }
        if (configsWithChanges.size() > 0) {
            switch (Activator.getDefault().getPreferenceStore().getInt("org.eclipse.edt.ide.rui.ClasspathChanged")) {
                case 2: {
                    break;
                }
                case 1: {
                    for (final TestServerConfiguration config : configsWithChanges) {
                        try {
                            config.terminate();
                        }
                        catch (DebugException e) {
                            Display display = Util.getDisplay();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ErrorDialog.openError((Shell)Util.getShell(), (String)TestServerMessages.TerminateFailedTitle, (String)NLS.bind((String)TestServerMessages.TerminateFailedMsg, (Object)config.getProject().getName()), (IStatus)e.getStatus());
                                }
                            });
                        }
                    }
                    break;
                }
                default: {
                    final Display display = Util.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (display.isDisposed()) {
                                return;
                            }
                            StringBuilder projectsInsert = new StringBuilder(20 * configsWithChanges.size());
                            for (TestServerConfiguration config : configsWithChanges) {
                                if (projectsInsert.length() != 0) {
                                    projectsInsert.append('\n');
                                }
                                projectsInsert.append(config.getProject().getName());
                            }
                            TestServerUpdateErrorDialog dialog = new TestServerUpdateErrorDialog(Util.getShell(), TestServerMessages.ClasspathChangedTitle, null, (IStatus)new Status(2, "org.eclipse.edt.ide.rui", String.valueOf(NLS.bind((String)TestServerMessages.ClasspathChangedMsg, (Object)projectsInsert)) + "\n\n" + (configsWithChanges.size() > 1 ? TestServerMessages.ErrorDialogTerminatePluralMsg : TestServerMessages.ErrorDialogTerminateMsg)), Activator.getDefault().getPreferenceStore(), "org.eclipse.edt.ide.rui.ClasspathChanged", configsWithChanges.toArray(new TestServerConfiguration[configsWithChanges.size()]));
                            dialog.open();
                        }
                    });
                }
            }
        }
    }

    private class DDPreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        final IProject project;

        DDPreferenceListener(IProject project) {
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            HashMap mapClone;
            Object object = TestServerManager.this.syncObj;
            synchronized (object) {
                if (TestServerManager.this.serverConfigMap == null) {
                    return;
                }
                mapClone = (HashMap)TestServerManager.this.serverConfigMap.clone();
            }
            if (mapClone != null) {
                for (TestServerConfiguration config : mapClone.values()) {
                    if (!config.isOnEGLPath(this.project)) continue;
                    config.updateDDSettingsOnServer();
                }
            }
        }
    }
}

