/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.HelpContextIDs;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerMessages;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TestServerPreferencePage
extends AbstractPreferencePage {
    private Button hcrFailedPrompt;
    private Button hcrFailedIgnore;
    private Button hcrFailedTerminate;
    private Button hcrUnsupportedPrompt;
    private Button hcrUnsupportedIgnore;
    private Button hcrUnsupportedTerminate;
    private Button obsoletePrompt;
    private Button obsoleteIgnore;
    private Button obsoleteTerminate;
    private Button cpChangedPrompt;
    private Button cpChangedIgnore;
    private Button cpChangedTerminate;

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.createCPChangedComposite(composite);
        this.createHCRComposite(composite);
        this.loadPreferences();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HelpContextIDs.RUI_TEST_SERVER_PREFERENCE_PAGE);
        return composite;
    }

    private void createHCRComposite(Composite parent) {
        Group group = TestServerPreferencePage.createGroup((Composite)parent, (int)1);
        group.setText(TestServerMessages.PreferenceHCRGroupLabel);
        int indentAmount = 10;
        Composite failedComposite = new Composite((Composite)group, 0);
        failedComposite.setLayout((Layout)new GridLayout(1, false));
        new Label(failedComposite, 0).setText(TestServerMessages.PreferenceHCRFailedLabel);
        this.hcrFailedPrompt = new Button(failedComposite, 16);
        this.hcrFailedPrompt.setText(TestServerMessages.PreferencePromptLabel);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.hcrFailedPrompt.setLayoutData((Object)gd);
        this.hcrFailedIgnore = new Button(failedComposite, 16);
        this.hcrFailedIgnore.setText(TestServerMessages.PreferenceDoNothingLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.hcrFailedIgnore.setLayoutData((Object)gd);
        this.hcrFailedTerminate = new Button(failedComposite, 16);
        this.hcrFailedTerminate.setText(TestServerMessages.PreferenceTerminateLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.hcrFailedTerminate.setLayoutData((Object)gd);
        Composite unsupportedComposite = new Composite((Composite)group, 0);
        unsupportedComposite.setLayout((Layout)new GridLayout(1, false));
        new Label(unsupportedComposite, 0).setText(TestServerMessages.PreferenceHCRUnsupportedLabel);
        this.hcrUnsupportedPrompt = new Button(unsupportedComposite, 16);
        this.hcrUnsupportedPrompt.setText(TestServerMessages.PreferencePromptLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.hcrUnsupportedPrompt.setLayoutData((Object)gd);
        this.hcrUnsupportedIgnore = new Button(unsupportedComposite, 16);
        this.hcrUnsupportedIgnore.setText(TestServerMessages.PreferenceDoNothingLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.hcrUnsupportedIgnore.setLayoutData((Object)gd);
        this.hcrUnsupportedTerminate = new Button(unsupportedComposite, 16);
        this.hcrUnsupportedTerminate.setText(TestServerMessages.PreferenceTerminateLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.hcrUnsupportedTerminate.setLayoutData((Object)gd);
        Composite obsoleteComposite = new Composite((Composite)group, 0);
        obsoleteComposite.setLayout((Layout)new GridLayout(1, false));
        new Label(obsoleteComposite, 0).setText(TestServerMessages.PreferenceObsoleteMethodsLabel);
        this.obsoletePrompt = new Button(obsoleteComposite, 16);
        this.obsoletePrompt.setText(TestServerMessages.PreferencePromptLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.obsoletePrompt.setLayoutData((Object)gd);
        this.obsoleteIgnore = new Button(obsoleteComposite, 16);
        this.obsoleteIgnore.setText(TestServerMessages.PreferenceDoNothingLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.obsoleteIgnore.setLayoutData((Object)gd);
        this.obsoleteTerminate = new Button(obsoleteComposite, 16);
        this.obsoleteTerminate.setText(TestServerMessages.PreferenceTerminateLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.obsoleteTerminate.setLayoutData((Object)gd);
    }

    private void createCPChangedComposite(Composite parent) {
        Group group = TestServerPreferencePage.createGroup((Composite)parent, (int)1);
        group.setText(TestServerMessages.PreferenceCPGroupLabel);
        int indentAmount = 10;
        Composite failedComposite = new Composite((Composite)group, 0);
        failedComposite.setLayout((Layout)new GridLayout(1, false));
        new Label(failedComposite, 0).setText(TestServerMessages.PreferenceCPChangedLabel);
        this.cpChangedPrompt = new Button(failedComposite, 16);
        this.cpChangedPrompt.setText(TestServerMessages.PreferencePromptLabel);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.cpChangedPrompt.setLayoutData((Object)gd);
        this.cpChangedIgnore = new Button(failedComposite, 16);
        this.cpChangedIgnore.setText(TestServerMessages.PreferenceDoNothingLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.cpChangedIgnore.setLayoutData((Object)gd);
        this.cpChangedTerminate = new Button(failedComposite, 16);
        this.cpChangedTerminate.setText(TestServerMessages.PreferenceTerminateLabel);
        gd = new GridData(768);
        gd.horizontalIndent = indentAmount;
        this.cpChangedTerminate.setLayoutData((Object)gd);
    }

    protected void initializeValues() {
        super.initializeValues();
        IPreferenceStore store = this.doGetPreferenceStore();
        this.updateHCRFailed(store.getInt("org.eclipse.edt.ide.rui.HCRFailed"));
        this.updateHCRUnsupported(store.getInt("org.eclipse.edt.ide.rui.HCRUnsupported"));
        this.updateObsoleteMethods(store.getInt("org.eclipse.edt.ide.rui.ObsoleteMethods"));
        this.updateCPChanged(store.getInt("org.eclipse.edt.ide.rui.ClasspathChanged"));
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.doGetPreferenceStore();
        this.updateHCRFailed(store.getDefaultInt("org.eclipse.edt.ide.rui.HCRFailed"));
        this.updateHCRUnsupported(store.getDefaultInt("org.eclipse.edt.ide.rui.HCRUnsupported"));
        this.updateObsoleteMethods(store.getDefaultInt("org.eclipse.edt.ide.rui.ObsoleteMethods"));
        this.updateCPChanged(store.getDefaultInt("org.eclipse.edt.ide.rui.ClasspathChanged"));
    }

    protected void storeValues() {
        int hcrFailedValue = this.hcrFailedIgnore.getSelection() ? 2 : (this.hcrFailedTerminate.getSelection() ? 1 : 0);
        this.doGetPreferenceStore().setValue("org.eclipse.edt.ide.rui.HCRFailed", hcrFailedValue);
        int hcrNotSupportedValue = this.hcrUnsupportedIgnore.getSelection() ? 2 : (this.hcrUnsupportedTerminate.getSelection() ? 1 : 0);
        this.doGetPreferenceStore().setValue("org.eclipse.edt.ide.rui.HCRUnsupported", hcrNotSupportedValue);
        int obsoleteValue = this.obsoleteIgnore.getSelection() ? 2 : (this.obsoleteTerminate.getSelection() ? 1 : 0);
        this.doGetPreferenceStore().setValue("org.eclipse.edt.ide.rui.ObsoleteMethods", obsoleteValue);
        int cpChangedValue = this.cpChangedIgnore.getSelection() ? 2 : (this.cpChangedTerminate.getSelection() ? 1 : 0);
        this.doGetPreferenceStore().setValue("org.eclipse.edt.ide.rui.ClasspathChanged", cpChangedValue);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private void updateHCRFailed(int selection) {
        this.hcrFailedIgnore.setSelection(selection == 2);
        this.hcrFailedTerminate.setSelection(selection == 1);
        this.hcrFailedPrompt.setSelection(selection == 0);
    }

    private void updateHCRUnsupported(int selection) {
        this.hcrUnsupportedIgnore.setSelection(selection == 2);
        this.hcrUnsupportedTerminate.setSelection(selection == 1);
        this.hcrUnsupportedPrompt.setSelection(selection == 0);
    }

    private void updateObsoleteMethods(int selection) {
        this.obsoleteIgnore.setSelection(selection == 2);
        this.obsoleteTerminate.setSelection(selection == 1);
        this.obsoletePrompt.setSelection(selection == 0);
    }

    private void updateCPChanged(int selection) {
        this.cpChangedIgnore.setSelection(selection == 2);
        this.cpChangedTerminate.setSelection(selection == 1);
        this.cpChangedPrompt.setSelection(selection == 0);
    }
}

