/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.server;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.deployment.javascript.DeploymentDescGenerator;
import org.eclipse.edt.gen.deployment.javascript.HTMLGenerator;
import org.eclipse.edt.gen.deployment.javascript.NLSPropertiesFileGenerator;
import org.eclipse.edt.gen.deployment.util.PartReferenceCache;
import org.eclipse.edt.gen.deployment.util.PropertiesFileUtil;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.rui.internal.deployment.javascript.EGL2HTML4VE;
import org.eclipse.edt.ide.rui.internal.lookup.PreviewIREnvironmentManager;
import org.eclipse.edt.ide.rui.internal.nls.LocaleUtility;
import org.eclipse.edt.ide.rui.server.IServerContentProvider;
import org.eclipse.edt.ide.rui.utils.EGLResource;
import org.eclipse.edt.ide.rui.utils.FileLocator;
import org.eclipse.edt.ide.rui.utils.IFileLocator;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xml.sax.SAXException;

public abstract class AbstractContentProvider
implements IServerContentProvider {
    private IPreferenceStore store = EDTCoreIDEPlugin.getPlugin().getPreferenceStore();

    @Override
    public byte[] loadContent(String uri) throws IOException, SAXException, CoreException {
        String projectName;
        byte[] bytes = null;
        int index = uri.indexOf(47);
        if (index == -1) {
            projectName = "";
        } else {
            try {
                uri = new URI(uri).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {}
            projectName = uri.substring(0, uri.indexOf(47));
        }
        if (projectName != "") {
            IFile ifile;
            FileLocator locator = this.getFileLocator(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
            EGLResource file = this.findRequiredFile(uri, projectName, locator);
            if (file != null) {
                DataInputStream is = new DataInputStream(new BufferedInputStream(file.getInputStream()));
                bytes = new byte[is.available()];
                is.readFully(bytes);
                is.close();
            } else if (uri.endsWith("-bnd.js")) {
                DeploymentDesc model = null;
                try {
                    uri = uri.substring(projectName.length() + 1);
                    uri = uri.substring(0, uri.length() - 7);
                    IFile eglddResource = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(uri);
                    String ddName = eglddResource.getName();
                    ddName = ddName.substring(0, ddName.indexOf(eglddResource.getFileExtension()) - 1);
                    model = DeploymentDesc.createDeploymentDescriptor((String)ddName, (InputStream)eglddResource.getContents());
                }
                catch (Exception exception) {}
                if (model != null) {
                    bytes = new DeploymentDescGenerator().generateBindFile(model);
                }
            } else if (uri.endsWith(".js") && (ifile = this.findRequiredFile(PropertiesFileUtil.convertToProperitesFile((String)uri), projectName, this.getIFileLocator(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && ifile.exists()) {
                PropertiesFileUtil propFileUtil = new PropertiesFileUtil(uri);
                NLSPropertiesFileGenerator generator = new NLSPropertiesFileGenerator();
                bytes = generator.generatePropertiesFile(ifile.getContents(), propFileUtil.getBundleName());
            }
            if (bytes == null && uri.endsWith(".html")) {
                String resourceName = uri.substring(uri.indexOf(projectName) + projectName.length() + 1, uri.length());
                bytes = this.generateHTMLFile(locator, resourceName.substring(0, resourceName.indexOf(".html")), projectName);
            }
        }
        return bytes;
    }

    private EGLResource findRequiredFile(String uri, String projectName, FileLocator locator) {
        EGLResource resource = null;
        String projectRelativePath = uri.substring(uri.indexOf(projectName) + projectName.length() + 1, uri.length());
        String applicationLocation = "";
        String resourceName = applicationLocation.length() > 0 ? projectRelativePath.substring(applicationLocation.length() + 1, projectRelativePath.length()) : projectRelativePath;
        while (resourceName != "") {
            resource = locator.findResource(resourceName);
            if (resource != null && resource.exists() && resource.isFile()) break;
            if (projectRelativePath.indexOf(47, applicationLocation.length() + 1) == -1) {
                resourceName = "";
                continue;
            }
            applicationLocation = projectRelativePath.substring(0, projectRelativePath.indexOf("/", applicationLocation.length() + 1));
            resourceName = projectRelativePath.substring(applicationLocation.length() + 1, projectRelativePath.length());
        }
        return resource;
    }

    private IFile findRequiredFile(String uri, String projectName, IFileLocator locator) {
        IFile file = null;
        String projectRelativePath = uri.substring(uri.indexOf(projectName) + projectName.length() + 1, uri.length());
        String applicationLocation = "";
        String resourceName = applicationLocation.length() > 0 ? projectRelativePath.substring(applicationLocation.length() + 1, projectRelativePath.length()) : projectRelativePath;
        while (resourceName != "") {
            file = locator.findFile(resourceName);
            if (file != null && file.exists()) break;
            if (projectRelativePath.indexOf(47, applicationLocation.length() + 1) == -1) {
                resourceName = "";
                continue;
            }
            applicationLocation = projectRelativePath.substring(0, projectRelativePath.indexOf("/", applicationLocation.length() + 1));
            resourceName = projectRelativePath.substring(applicationLocation.length() + 1, projectRelativePath.length());
        }
        return file;
    }

    protected byte[] generateHTMLFile(FileLocator locator, String resourceName, String projectName) throws IOException, SAXException {
        IEnvironment environment = null;
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            environment = this.getEnvironmentForGeneration(project);
            Environment.pushEnv((IEnvironment)environment);
            Part part = null;
            EObject eObject = environment.find(PreviewIREnvironmentManager.makeEGLKey(resourceName.replace("/", ".")));
            if (eObject != null && eObject instanceof Part) {
                part = (Part)eObject;
            }
            if (part != null && !part.hasCompileErrors().booleanValue()) {
                EGL2HTML4VE cmd = new EGL2HTML4VE();
                HashMap<String, String> eglProperties = new HashMap<String, String>();
                eglProperties.put("egl__contextRoot", projectName);
                eglProperties.put("egl__htmlLocale", this.getHandlerMessageLocale());
                eglProperties.put("egl__defaultRuntimeMessagesLocale", this.getRuntimeMessageLocale());
                String egldd = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)project).getPartName();
                List egldds = EclipseUtilities.getDependentDescriptors((IProject)project);
                eglProperties.put("egl__defaultDeploymentDescriptor", egldd);
                ISystemEnvironment sysEnv = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project).getSystemEnvironment();
                PartReferenceCache partRefCache = new PartReferenceCache(sysEnv.getIREnvironment());
                Set<String> propFiles = Util.findPropertiesFiles(part, partRefCache, this.getHandlerMessageLocale(), this.getFileLocator(project));
                HTMLGenerator generator = this.getDevelopmentGenerator((AbstractGeneratorCommand)cmd, egldds, propFiles, eglProperties, this.getHandlerMessageLocale(), this.getRuntimeMessageLocale(), sysEnv, partRefCache);
                String result = cmd.generate(part, (Generator)generator, environment);
                byte[] byArray = result.getBytes();
                return byArray;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (environment != null) {
                Environment.popEnv();
            }
        }
        return null;
    }

    protected abstract IEnvironment getEnvironmentForGeneration(IProject var1);

    protected abstract FileLocator getFileLocator(IProject var1) throws CoreException;

    protected abstract IFileLocator getIFileLocator(IProject var1) throws CoreException;

    protected abstract HTMLGenerator getDevelopmentGenerator(AbstractGeneratorCommand var1, List var2, Set<String> var3, HashMap var4, String var5, String var6, ISystemEnvironment var7, PartReferenceCache var8);

    protected String getRuntimeMessageLocale() {
        String runtimeMsgLocale = this.store.getString("org.eclipse.edt.ide.rui.RuntimeLocale");
        if (runtimeMsgLocale == null || runtimeMsgLocale.length() == 0) {
            runtimeMsgLocale = LocaleUtility.getDefaultRuntimeLocale().getCode();
        }
        return runtimeMsgLocale;
    }

    protected String getHandlerMessageLocale() {
        String runtimeMsgLocale = this.store.getString("org.eclipse.edt.ide.rui.HandlerLocale");
        if (runtimeMsgLocale == null || runtimeMsgLocale.length() == 0) {
            runtimeMsgLocale = LocaleUtility.getDefaultHandlerLocale().getCode();
        }
        return runtimeMsgLocale;
    }
}

