/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.server;

import eglx.http.HttpUtilities;
import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonUtilities;
import eglx.lang.AnyException;
import eglx.services.ServiceKind;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.rui.editor.IEditorSelectAndRevealer;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.nls.RUINlsStrings;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerConfiguration;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerManager;
import org.eclipse.edt.ide.rui.server.AbstractPreviewContext;
import org.eclipse.edt.ide.rui.server.DesignContext;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.server.IClientProxy;
import org.eclipse.edt.ide.rui.server.IContext;
import org.eclipse.edt.ide.rui.server.IContext2;
import org.eclipse.edt.ide.rui.server.IContextResolver;
import org.eclipse.edt.ide.rui.server.IServerContentProvider;
import org.eclipse.edt.ide.rui.server.IServerListener;
import org.eclipse.edt.ide.rui.server.PreviewContext;
import org.eclipse.edt.ide.rui.server.SavedContentProvider;
import org.eclipse.edt.ide.rui.utils.DebugFileLocator;
import org.eclipse.edt.ide.rui.utils.EGLResource;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.edt.javart.JSERunUnit;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.json.TokenMgrError;
import org.eclipse.edt.javart.resources.StartupInfo;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;
import org.eclipse.edt.javart.services.servlet.proxy.ProxyEventHandler;
import org.eclipse.edt.javart.services.servlet.proxy.ProxyUtilities;
import org.eclipse.edt.javart.services.servlet.proxy.RuiBrowserHttpRequest;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class EvServer
implements IClientProxy {
    private ServerSocket serverSocket = null;
    private Map<Integer, QueueProcessor> contextKeyQueues = new HashMap<Integer, QueueProcessor>();
    private Object contextSynchObject = new Object();
    private List<IContextResolver> contextResolvers = new ArrayList<IContextResolver>();
    private static final String EOL = "\r\n";
    private static EvServer instance = null;
    private static boolean running = true;
    private static int START_PORT_NUMBER;
    private static int portNumber;
    private int contextKeyInc = 1;
    private TestServerManager testServerMgr;

    static {
        portNumber = START_PORT_NUMBER = 5590;
    }

    public static EvServer getInstance() {
        if (instance == null) {
            instance = new EvServer();
        }
        return instance;
    }

    static byte[] getResource(String name) {
        try {
            DataInputStream is = new DataInputStream(EvServer.class.getResourceAsStream(name));
            byte[] bytes = new byte[is.available()];
            is.readFully(bytes);
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    static String unescape(String msg) {
        try {
            return URLDecoder.decode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return msg;
        }
    }

    EvServer() {
        do {
            try {
                ++START_PORT_NUMBER;
                this.serverSocket = new ServerSocket(portNumber);
            }
            catch (Exception exception) {}
        } while (this.serverSocket == null);
        this.debug("Server ready for business at " + this.serverSocket);
        new Thread(){

            @Override
            public void run() {
                EvServer.this.startServer();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContext(IContext context) {
        Object object = this.contextSynchObject;
        synchronized (object) {
            if (!this.contextKeyQueues.containsKey(context.getKey())) {
                QueueProcessor q = new QueueProcessor();
                this.contextKeyQueues.put(context.getKey(), q);
                q.setContextKey(context.getKey());
                q.setContext(context);
                q.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextResolver(IContextResolver resolver) {
        Object object = this.contextSynchObject;
        synchronized (object) {
            if (!this.contextResolvers.contains(resolver)) {
                this.contextResolvers.add(resolver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextResolver(IContextResolver resolver) {
        Object object = this.contextSynchObject;
        synchronized (object) {
            this.contextResolvers.remove(resolver);
        }
    }

    private void debug(String string) {
    }

    public void fail(PrintStream ps) throws InterruptedException {
        ps.print(this.getBadResponseHeader());
        ps.close();
    }

    public String getBadResponseHeader() {
        return "HTTP/1.0 404 \r\nContent-Type: " + this.getContentType(".txt") + EOL + EOL;
    }

    public String getContentType(String url) {
        String result = HttpUtilities.getContentType((String)this.getExtension(url));
        if (result == null) {
            result = "text/html;charset=utf-8";
        }
        return result;
    }

    private String getExtension(String url) {
        return url.substring(url.lastIndexOf(46) + 1).toLowerCase();
    }

    public String getGoodResponseHeader(String url, String contentType, boolean cache) {
        return this.getResponseHeader(url, contentType, cache, 200, "OK");
    }

    private String getResponseHeader(String url, String contentType, boolean cache, int status, String statusMsg) {
        return "HTTP/1.0 " + String.valueOf(status) + " " + statusMsg + EOL + "Server: IBM EGL UI Server" + EOL + "Pragma: no-cache\r\nCacheControl: no-cache\r\nExpires: -1\r\n" + "Content-Type: " + contentType + EOL + EOL;
    }

    public int getPortNumber() {
        return portNumber;
    }

    public int generateContextKey() {
        ++this.contextKeyInc;
        return this.contextKeyInc;
    }

    private boolean checkEventTypes(String url) {
        boolean result = false;
        if (url.indexOf("__getversion") > 0) {
            result = true;
        } else if (url.indexOf("___startup") > 0) {
            result = true;
        } else if (url.indexOf("___traceEvents") > 0) {
            result = true;
        } else if (url.indexOf("___widgetPositions") > 0) {
            result = true;
        } else if (url.indexOf("___openFile") > 0) {
            result = true;
        } else {
            this.debug("unknown event type: " + url);
        }
        return result;
    }

    protected void handleBrowserEvent(Socket socket) {
        block28: {
            try {
                String url = null;
                PrintStream ps = new PrintStream(socket.getOutputStream());
                try {
                    RuiBrowserHttpRequest xmlRequest = null;
                    try {
                        xmlRequest = RuiBrowserHttpRequest.createNewRequest((Socket)socket);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        return;
                    }
                    if (xmlRequest == null) break block28;
                    url = xmlRequest.getURL();
                    this.debug("-->EvServer.handleBrowserEvent :" + url + " | ctx=" + (String)xmlRequest.getArguments().get("contextKey"));
                    if (url.indexOf("__proxy") != -1 || xmlRequest.getHeaders() != null && xmlRequest.getHeaders().containsKey("EGLREST")) {
                        Event event = new Event();
                        event.ps = ps;
                        event.socket = socket;
                        event.url = xmlRequest.getURL();
                        event.xmlRequest = xmlRequest;
                        event.arguments = xmlRequest.getArguments();
                        ___ProxyHandler hop = new ___ProxyHandler(xmlRequest, ps);
                        Thread thread = new Thread(hop);
                        thread.start();
                        break block28;
                    }
                    if (url.indexOf("__testServer") != -1) {
                        TestServerRequestHander tsrh = new TestServerRequestHander(xmlRequest, ps);
                        Thread thread = new Thread(tsrh);
                        thread.start();
                        break block28;
                    }
                    Map args = null;
                    args = xmlRequest.getArguments().containsKey("contextKey") ? xmlRequest.getArguments() : (xmlRequest.getContentArguments() != null && xmlRequest.getContentArguments().containsKey("contextKey") ? xmlRequest.getContentArguments() : xmlRequest.getArguments());
                    String strContextKey = (String)args.get("contextKey");
                    if (strContextKey != null && strContextKey.length() != 0) {
                        try {
                            Integer intContextKey = Integer.valueOf(strContextKey);
                            IContext context = this.findContext(intContextKey);
                            if (context instanceof IContext2) {
                                Event event = new Event();
                                event.ps = ps;
                                event.socket = socket;
                                event.url = xmlRequest.getURL();
                                event.xmlRequest = xmlRequest;
                                event.key = intContextKey;
                                event.arguments = args;
                                ((IContext2)context).handleEvent(event);
                                break block28;
                            }
                            if (this.containsKey(intContextKey)) {
                                QueueProcessor q = this.findQueueProcessor(intContextKey);
                                Event event = new Event();
                                event.ps = ps;
                                event.socket = socket;
                                event.url = xmlRequest.getURL();
                                event.xmlRequest = xmlRequest;
                                event.key = intContextKey;
                                event.arguments = args;
                                this.debug("handleBrowserEvent: Add event to Q(" + intContextKey + "):" + event.url);
                                q.addEvent(event);
                                break block28;
                            }
                            this.debug("handleBrowserEvent: context key not in queue");
                            ps.print(this.getBadResponseHeader());
                            if (url.indexOf("___getevent") == -1 && url.indexOf("___debugTerminate") == -1) {
                                String msg = RUINlsStrings.bind((String)RUINlsStrings.ContextKeyNotFound, (Object)intContextKey);
                                try {
                                    ps.write(msg.getBytes("UTF-8"));
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    ps.write(msg.getBytes());
                                }
                            } else if (url.indexOf("___getevent") > 0) {
                                System.err.println("__getevent : terminated");
                                ps.print("context terminated");
                                ps.flush();
                            }
                            ps.close();
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.debug("contextKey not cast");
                        }
                        break block28;
                    }
                    if (url.indexOf("___openFile") != -1) {
                        this.openFile(url, (String)args.get("file"), Integer.parseInt((String)args.get("line")), ps);
                    } else if (url.indexOf("___loadScript") != -1) {
                        this.loadScript((String)args.get("fileName"), ps);
                        ps.flush();
                        ps.close();
                    } else if (url.indexOf(".htm") > 0) {
                        Integer key = new Integer(this.generateContextKey());
                        this.loadFile(url, null, ps);
                        this.debug("html file loaded with context key: " + key);
                    } else if (!this.checkEventTypes(url)) {
                        this.debug("handleBrowserEvent unkown url: " + url);
                        this.loadFile(url, null, ps);
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    System.err.println(url);
                    e.printStackTrace();
                    try {
                        this.fail(ps);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadFile(String url, Integer intKey, PrintStream ps) {
        IContext context = null;
        File file = null;
        try {
            String trimmedURL = url.trim();
            byte[] bytes = null;
            if (bytes == null) {
                String uri = trimmedURL.substring(trimmedURL.indexOf(47) + 1, trimmedURL.length());
                if (intKey != null) {
                    context = this.findContext(intKey);
                }
                if (context != null) {
                    IServerContentProvider contentProvider = context.getContentProvider();
                    bytes = contentProvider.loadContent(uri);
                } else {
                    SavedContentProvider contentProvider = new SavedContentProvider();
                    bytes = contentProvider.loadContent(uri);
                }
            }
            if (bytes != null) {
                ps.print(this.getGoodResponseHeader(trimmedURL, this.getContentType(trimmedURL), !trimmedURL.endsWith(".egl")));
                ps.write(bytes);
                ps.flush();
                ps.close();
            } else {
                ps.print(this.getGoodResponseHeader(url, this.getContentType(url), !url.endsWith(".egl")));
                if (file != null) {
                    ps.println("document.write(\"Could not open " + file.getAbsolutePath().replace('\\', '/') + "\");");
                } else {
                    ps.println("document.write(\"Could not open " + url + "\");");
                }
                ps.flush();
                ps.close();
            }
        }
        catch (Exception e) {
            ps.print(this.getGoodResponseHeader(url, this.getContentType(url), !url.endsWith(".egl")));
            ps.println("document.write(\"Could not open " + url + "\");");
            e.printStackTrace();
            ps.flush();
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsKey(Integer key) {
        Object object = this.contextSynchObject;
        synchronized (object) {
            return this.contextKeyQueues.containsKey(key);
        }
    }

    protected void parse4Event(Event event) throws Exception {
        String url = event.url;
        PrintStream ps = event.ps;
        Map args = event.arguments;
        Integer intContextKey = event.key;
        if (intContextKey != null) {
            if (!this.containsKey(intContextKey)) {
                this.debug("context key: not in queue // url: " + url);
            } else {
                this.debug("context key: " + intContextKey + " // url: " + url);
                if (this.getExtension(url).equals("egl")) {
                    this.debug("Egl REST service: " + url);
                } else if (url.indexOf("__getversion") != -1) {
                    this.sendVersion(ps);
                } else if (url.indexOf("___startup") != -1) {
                    this.debug("parse4event: startup called");
                    ps.print(this.getGoodResponseHeader("", "text/html", false));
                    ps.flush();
                    ps.close();
                } else if (url.indexOf("___traceEvents") != -1) {
                    ps.print(this.getGoodResponseHeader("", this.getContentType(""), false));
                    ps.print("OK");
                    ps.flush();
                    ps.close();
                } else if (url.indexOf("___widgetPositions") != -1) {
                    this.widgetPositions(url, intContextKey, args.get("value").toString());
                    ps.print(this.getGoodResponseHeader("", "text/html", false));
                    ps.flush();
                    ps.close();
                } else if (url.indexOf("___openFile") != -1) {
                    this.openFile(url, (String)args.get("file"), Integer.parseInt((String)args.get("line")), ps);
                } else if (url.indexOf("___showFile") != -1) {
                    int offset = Integer.parseInt((String)args.get("offset"));
                    int length = Integer.parseInt((String)args.get("length"));
                    this.showFile(intContextKey, offset, length, ps);
                } else if (url.indexOf("___reloadHandler") != -1) {
                    this.loadFile((String)args.get("fileName"), intContextKey, ps);
                    ps.flush();
                    ps.close();
                } else if (url.indexOf("..") == -1) {
                    this.debug("parse4event: loadFile");
                    this.loadFile(url, intContextKey, ps);
                } else {
                    this.fail(ps);
                }
            }
        }
    }

    private void loadScript(String fileName, PrintStream ps) {
        if (fileName.charAt(0) == '/') {
            fileName = fileName.substring(1);
        }
        this.debug("open File " + fileName);
        String projectName = fileName.substring(0, fileName.indexOf("/"));
        fileName = fileName.substring(projectName.length() + 1);
        byte[] result = null;
        try {
            if (result != null) {
                ps.write(result);
                return;
            }
        }
        catch (Exception exception) {}
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            DebugFileLocator resourceLocator = new DebugFileLocator(project);
            EGLResource resource = resourceLocator.findResource(fileName);
            if (resource == null || !resource.exists()) {
                try {
                    ps.write(("egl.printError( 'Missing:" + fileName + "');").getBytes());
                }
                catch (IOException iOException) {}
                return;
            }
            BufferedInputStream fileContents = new BufferedInputStream(resource.getInputStream());
            try {
                result = new byte[((InputStream)fileContents).available()];
                ((InputStream)fileContents).read(result);
                ps.write(result);
                Util.RUI_RUNTIME_JAVASCRIPT_FILE_CACHE.put((Object)fileName, (Object)result);
            }
            finally {
                ((InputStream)fileContents).close();
            }
        }
        catch (Exception exception) {
            try {
                ps.write("throw(\"error\");".getBytes());
            }
            catch (IOException iOException) {}
        }
    }

    private void openFile(String url, String fileName, final int line, PrintStream ps) {
        block8: {
            try {
                try {
                    url = url.trim();
                    if (url.charAt(0) == '/') {
                        url = url.substring(1);
                    }
                    if (fileName.charAt(0) == '/') {
                        fileName = fileName.substring(1);
                    }
                    this.debug("open File " + fileName);
                    String projectName = url.substring(0, url.indexOf("/"));
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    final IFile file = this.findFileInPath(project, fileName, new HashSet<IProject>());
                    if (file == null) {
                        this.debug("no such file: " + fileName + " inside project " + projectName);
                        break block8;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage page = EvEditorProvider.workbenchPage;
                            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                            if (desc == null) {
                                desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo.txt");
                            }
                            try {
                                IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                                if (editorPart instanceof IEditorSelectAndRevealer) {
                                    IEditorSelectAndRevealer editor = (IEditorSelectAndRevealer)editorPart;
                                    editor.selectAndRevealLine(line);
                                } else if (editorPart instanceof ITextEditor) {
                                    ITextEditor editor = (ITextEditor)editorPart;
                                    IDocumentProvider provider = editor.getDocumentProvider();
                                    IDocument document = provider.getDocument((Object)editor.getEditorInput());
                                    int start = document.getLineOffset(line - 1);
                                    int end = document.getLineOffset(line);
                                    editor.selectAndReveal(start, end - start);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ps.print(this.getGoodResponseHeader("", "text/html", false));
                    ps.close();
                }
            }
            finally {
                ps.print(this.getGoodResponseHeader("", "text/html", false));
                ps.close();
            }
        }
    }

    private IFile findFileInPath(IProject project, String fileName, Set<IProject> seen) {
        IFile file;
        if (seen.contains(project)) {
            return null;
        }
        seen.add(project);
        String[] segments = fileName.split("/");
        String name = segments[segments.length - 1];
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            name = name.substring(0, dot);
        }
        name = InternUtil.intern((String)name);
        String[] pkg = new String[segments.length - 1];
        System.arraycopy(segments, 0, pkg, 0, pkg.length);
        pkg = InternUtil.intern((String[])pkg);
        ProjectInfo info = ProjectInfoManager.getInstance().getProjectInfo(project);
        if (info.hasPart(pkg, name) != 1 && (file = info.getPartOrigin(pkg, name).getEGLFile()) != null && file.exists()) {
            return file;
        }
        ProjectBuildPath path = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
        IProject[] iProjectArray = path.getRequiredProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject req = iProjectArray[n2];
            IFile file2 = this.findFileInPath(req, fileName, seen);
            if (file2 != null) {
                return file2;
            }
            ++n2;
        }
        return null;
    }

    protected void println(PrintStream ps, String msg) {
        msg = EvServer.unescape(msg);
        ps.print(this.getGoodResponseHeader("", this.getContentType(""), false));
        ps.flush();
        ps.close();
    }

    @Override
    public void refreshBrowserContents(IContext context, String location, long modificationStamp, boolean force) {
        this.debug("refreshBrowserContents call");
    }

    public void refreshBrowserIncremental(IContext context) {
        if (this.containsKey(context.getKey())) {
            try {
                QueueProcessor q = this.findQueueProcessor(context.getKey());
                String result = "egl.evTerminateReloadHandler();";
                q.setEventPending(result);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Refresh Browser Incr: Error", (Throwable)e));
            }
        }
    }

    public void doWidgetClick(IContext context, int x, int y) {
        if (this.containsKey(context.getKey())) {
            try {
                QueueProcessor q = this.findQueueProcessor(context.getKey());
                String result = "egl.doWidgetClick(" + x + "," + y + ");";
                q.setEventPending(result);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Refresh Browser Incr: Error", (Throwable)e));
            }
        }
    }

    public void changeProperty(IContext context, int x, int y, int w, int h, String property, String value, int totalCharactersChanged) {
        if (this.containsKey(context.getKey())) {
            String trimmedURL = context.getUrl().trim();
            try {
                URL jURL = new URL(trimmedURL);
                String uri = jURL.getPath();
                uri = uri.substring(uri.indexOf(47) + 1, uri.length());
                QueueProcessor q = this.findQueueProcessor(context.getKey());
                property = String.valueOf(property.substring(0, 1).toUpperCase()) + property.substring(1);
                String result = "egl.evUpdateWidgetProperty(" + x + "," + y + "," + w + "," + h + ", \"" + property + "\", \"" + value + "\"," + totalCharactersChanged + ");";
                q.setEventPending(result);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Refresh Browser Incr: Error", (Throwable)e));
            }
        }
    }

    public void deleteWidget(IContext context, int x, int y, int w, int h, int totalCharactersRemoved) {
        if (this.containsKey(context.getKey())) {
            String trimmedURL = context.getUrl().trim();
            try {
                URL jURL = new URL(trimmedURL);
                String uri = jURL.getPath();
                uri = uri.substring(uri.indexOf(47) + 1, uri.length());
                QueueProcessor q = this.findQueueProcessor(context.getKey());
                String result = "egl.evDeleteWidget(" + x + "," + y + "," + w + "," + h + "," + totalCharactersRemoved + ")";
                q.setEventPending(result);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Refresh Browser Incr: Error", (Throwable)e));
            }
        }
    }

    public void moveWidget(IContext context, int x, int y, int w, int h, int tx, int ty, int tw, int th, int oldIndex, int newIndex, int[] charactersChanged) {
        if (this.containsKey(context.getKey())) {
            String trimmedURL = context.getUrl().trim();
            try {
                URL jURL = new URL(trimmedURL);
                String uri = jURL.getPath();
                uri = uri.substring(uri.indexOf(47) + 1, uri.length());
                QueueProcessor q = this.findQueueProcessor(context.getKey());
                String result = "egl.evMoveWidget(" + x + "," + y + "," + w + "," + h + "," + tx + "," + ty + "," + tw + "," + th + "," + oldIndex + "," + newIndex + "," + charactersChanged[0] + "," + charactersChanged[1] + ")";
                q.setEventPending(result);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Refresh Browser Incr: Error", (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContext(IContext context) {
        this.debug("removeContext");
        Object object = this.contextSynchObject;
        synchronized (object) {
            QueueProcessor q = this.contextKeyQueues.remove(context.getKey());
            if (q != null) {
                q.setActive(false);
            }
        }
    }

    @Override
    public void requestWidgetPositions(IContext context) {
        this.debug("EvServer.requestWidgetPositions");
        if (this.containsKey(context.getKey())) {
            QueueProcessor q = this.findQueueProcessor(context.getKey());
            q.setEventPending("egl.getWidgetPositions();");
        } else {
            System.out.println("requestWidgetPosition: context key found no queue");
        }
    }

    @Override
    public void terminateSession(IContext context) {
        this.debug("terminateSession called");
        if (this.containsKey(context.getKey())) {
            QueueProcessor q = this.findQueueProcessor(context.getKey());
            q.setEventPending("if (window.egl) egl.terminateSession()");
        } else {
            this.debug("terminateSession: context key found no queue");
        }
    }

    public void sendVersion(PrintStream ps) {
        ps.print(this.getGoodResponseHeader("", this.getContentType(""), false));
        ps.print("1");
        ps.flush();
        ps.close();
    }

    public void startServer() {
        try {
            if (this.testServerMgr == null) {
                this.testServerMgr = new TestServerManager();
            }
            if (Runtime.getRunUnit() == null) {
                Runtime.setStaticRunUnit((RunUnit)new JSERunUnit(new StartupInfo("IDERunUnit", "", null)));
            }
            while (running) {
                Socket client = this.serverSocket.accept();
                this.debug("serverSocket accept");
                this.handleBrowserEvent(client);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.testServerMgr.dispose();
        this.testServerMgr = null;
    }

    private synchronized void widgetPositions(String url, Integer intKey, String positionInfo) {
        IServerListener listener;
        IContext context = this.findContext(intKey);
        if (context instanceof DesignContext && (listener = ((DesignContext)context).getServerListener()) != null) {
            listener.acceptWidgetPositions(positionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IContext findContext(Integer contextKey) {
        Object object = this.contextSynchObject;
        synchronized (object) {
            QueueProcessor q = this.contextKeyQueues.get(contextKey);
            if (q != null) {
                return q.getContext();
            }
            if (this.contextResolvers.size() > 0) {
                for (IContextResolver resolver : this.contextResolvers) {
                    IContext context = resolver.findContext(contextKey);
                    if (context == null) continue;
                    return context;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueProcessor findQueueProcessor(Integer contextKey) {
        Object object = this.contextSynchObject;
        synchronized (object) {
            return this.contextKeyQueues.get(contextKey);
        }
    }

    private boolean isDesignPane(Integer contextKey) {
        IContext context = this.findContext(contextKey);
        return context instanceof DesignContext;
    }

    private boolean isPreviewPane(Integer contextKey) {
        IContext context = this.findContext(contextKey);
        return context instanceof PreviewContext;
    }

    private synchronized void showFile(Integer intKey, final int offset, final int length, PrintStream ps) {
        try {
            IServerListener listener;
            AbstractPreviewContext context = (AbstractPreviewContext)this.findContext(intKey);
            if (context != null && (listener = context.getServerListener()) != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        listener.selectTextInEditor(offset, length);
                    }
                });
            }
        }
        finally {
            ps.print(this.getGoodResponseHeader("", "text/html", false));
            ps.close();
        }
    }

    public static class Event {
        public PrintStream ps = null;
        public Socket socket = null;
        public String url = null;
        public RuiBrowserHttpRequest xmlRequest = null;
        public Integer key = null;
        public Map arguments = null;
    }

    private class QueueProcessor
    extends Thread {
        private LinkedList eventQueue;
        private Integer contextKey;
        private String eventPending;
        private IContext context;
        private int timeLeft;
        private int lifeLine;
        private boolean getProcessed;
        private boolean active;

        private void resetLifeLine() {
            this.lifeLine = 25;
        }

        public IContext getContext() {
            return this.context;
        }

        public void setContext(IContext context) {
            this.context = context;
        }

        public Integer getContextKey() {
            return this.contextKey;
        }

        public void setContextKey(Integer contextKey) {
            this.contextKey = contextKey;
        }

        public String getEventPending() {
            return this.eventPending;
        }

        public void setEventPending(String eventPending) {
            this.eventPending = eventPending;
        }

        public void addEvent(Event event) {
            this.eventQueue.add(event);
        }

        private void resetTimeLeft() {
            this.timeLeft = 10;
        }

        public void setActive(boolean state) {
            this.active = state;
        }

        public QueueProcessor() {
            super("Visual Editor Event Queue Processor");
            this.eventQueue = new LinkedList();
            this.contextKey = null;
            this.eventPending = null;
            this.context = null;
            this.timeLeft = -1;
            this.lifeLine = -1;
            this.getProcessed = false;
            this.active = true;
            this.resetTimeLeft();
            this.resetLifeLine();
        }

        @Override
        public void run() {
            Event event;
            while (this.active) {
                if (!this.eventQueue.isEmpty()) {
                    block34: {
                        this.resetLifeLine();
                        while (this.eventQueue.size() > 1 && ((Event)this.eventQueue.get((int)0)).url.indexOf("___getevent") >= 0) {
                            this.sendEvent((Event)this.eventQueue.get(0), this.context, "");
                            this.eventQueue.remove();
                            this.resetTimeLeft();
                        }
                        event = (Event)this.eventQueue.get(0);
                        if (event.url.indexOf("___getevent") >= 0) {
                            this.getProcessed = true;
                            if (this.eventPending != null) {
                                this.sendEvent(event, this.context, this.eventPending);
                                this.eventPending = null;
                                this.eventQueue.remove();
                                this.resetTimeLeft();
                            } else {
                                --this.timeLeft;
                                if (this.timeLeft <= 0) {
                                    this.sendEvent(event, this.context, "");
                                    this.eventQueue.remove();
                                    this.resetTimeLeft();
                                } else {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        } else {
                            try {
                                EvServer.this.parse4Event(event);
                                this.eventQueue.remove();
                                this.resetTimeLeft();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                event.ps.close();
                                try {
                                    event.socket.close();
                                }
                                catch (IOException iOException) {}
                                break block34;
                            }
                            catch (TokenMgrError ex) {
                                try {
                                    ex.printStackTrace();
                                    event.ps.close();
                                }
                                catch (Throwable throwable) {
                                    event.ps.close();
                                    try {
                                        event.socket.close();
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                                try {
                                    event.socket.close();
                                }
                                catch (IOException iOException) {}
                                break block34;
                            }
                            event.ps.close();
                            try {
                                event.socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    if (this.getProcessed) {
                        --this.lifeLine;
                    }
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            while (!this.eventQueue.isEmpty()) {
                event = (Event)this.eventQueue.remove();
                if (event.ps != null) {
                    event.ps.close();
                }
                if (event.socket == null) continue;
                try {
                    event.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void sendEvent(Event event, IContext context, String content) {
            event.ps.print(EvServer.this.getGoodResponseHeader("", EvServer.this.getContentType(""), false));
            event.ps.print(content);
            event.ps.flush();
            if (event.ps.checkError()) {
                EvServer.this.debug("sendEvent: error in send context:" + context.getKey() + ", content: " + content);
            }
            event.ps.close();
            try {
                event.socket.close();
            }
            catch (IOException iOException) {}
            if (content != null && content.length() > 0) {
                EvServer.this.debug("Sent [" + content + "] for [" + event.url + "]");
            }
        }
    }

    private class TestServerRequestHander
    implements Runnable {
        public PrintStream ps;
        public RuiBrowserHttpRequest xmlRequest;

        public TestServerRequestHander(RuiBrowserHttpRequest ruiRequest, PrintStream ps) {
            this.xmlRequest = ruiRequest;
            this.ps = ps;
        }

        @Override
        public void run() {
            block17: {
                String urlString = this.xmlRequest.getURL();
                try {
                    try {
                        String info;
                        if (!this.xmlRequest.getContentArguments().containsKey("connectionProfile")) break block17;
                        String url = null;
                        String user = null;
                        String pass = null;
                        String schema = null;
                        String className = null;
                        String profileName = (String)this.xmlRequest.getContentArguments().get("connectionProfile");
                        IConnectionProfile profile = EGLSQLUtility.getConnectionProfile((String)profileName);
                        if (profile != null) {
                            url = EGLSQLUtility.getSQLConnectionURLPreference((IConnectionProfile)profile);
                            user = EGLSQLUtility.getSQLUserId((IConnectionProfile)profile);
                            pass = EGLSQLUtility.getSQLPassword((IConnectionProfile)profile);
                            schema = EGLSQLUtility.getDefaultSchema((IConnectionProfile)profile);
                            className = EGLSQLUtility.getSQLJDBCDriverClassPreference((IConnectionProfile)profile);
                        }
                        if (url == null) {
                            url = "";
                        }
                        if (user == null) {
                            user = "";
                        }
                        if (pass == null) {
                            pass = "";
                        }
                        if (schema == null) {
                            schema = "";
                        }
                        if (className == null) {
                            className = "";
                        }
                        try {
                            info = String.valueOf(URLEncoder.encode(url, "UTF-8")) + ';' + URLEncoder.encode(user, "UTF-8") + ';' + URLEncoder.encode(pass, "UTF-8") + ';' + URLEncoder.encode(schema, "UTF-8") + ';' + URLEncoder.encode(className, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            info = String.valueOf(url) + ';' + user + ';' + pass + ';' + schema + ';' + className;
                        }
                        this.ps.print(EvServer.this.getGoodResponseHeader(urlString, EvServer.this.getContentType(urlString), false));
                        this.ps.write(info.getBytes("utf-8"));
                    }
                    catch (Throwable t) {
                        System.err.println(urlString);
                        t.printStackTrace();
                        try {
                            EvServer.this.fail(this.ps);
                        }
                        catch (Exception exception) {}
                        if (this.ps != null) {
                            this.ps.flush();
                            this.ps.close();
                        }
                    }
                }
                finally {
                    if (this.ps != null) {
                        this.ps.flush();
                        this.ps.close();
                    }
                }
            }
        }
    }

    private class ___ProxyHandler
    extends ProxyEventHandler
    implements Runnable {
        private RuiBrowserHttpRequest ruiRequest;
        private PrintStream ps;
        private boolean isDedicated;

        public ___ProxyHandler(RuiBrowserHttpRequest ruiRequest, PrintStream ps) {
            this.ruiRequest = ruiRequest;
            this.ps = ps;
        }

        protected HttpURLConnection getHttpProxyConnection(Request restRequest) throws IOException {
            String urlString = restRequest.uri;
            Proxy proxy = this.getProxy(urlString);
            if (proxy != null) {
                return (HttpURLConnection)new URL(urlString).openConnection(proxy);
            }
            return null;
        }

        private Proxy getProxy(String urlString) throws IOException {
            IProxyData proxyData;
            Object proxyService;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.core.net");
            ServiceReference ref = bundle.getBundleContext().getServiceReference(IProxyService.class.getName());
            if (ref != null && (proxyService = bundle.getBundleContext().getService(ref)) instanceof IProxyService && (((IProxyService)proxyService).isProxiesEnabled() || ((IProxyService)proxyService).isSystemProxiesEnabled()) && (proxyData = this.getProxyData((IProxyService)proxyService, urlString)) != null) {
                int port = proxyData.getPort() == -1 ? 0 : proxyData.getPort();
                InetSocketAddress address = new InetSocketAddress(proxyData.getHost(), port);
                Proxy.Type proxyType = proxyData.getType().equals("SOCKS") ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
                return new Proxy(proxyType, address);
            }
            return null;
        }

        private IProxyData getProxyData(IProxyService proxyService, String urlString) {
            IProxyData proxy = null;
            IProxyData[] proxies = proxyService.getProxyDataForHost(urlString);
            if (proxies != null && proxies.length > 0) {
                int idx = 0;
                while (idx < proxies.length) {
                    if (proxies[idx].getType() == "HTTPS") {
                        proxy = proxies[idx];
                        break;
                    }
                    if (proxies[idx].getType() == "HTTP" && (proxy == null || proxy.getType() == "SOCKS")) {
                        proxy = proxies[idx];
                    } else if (proxies[idx].getType() == "SOCKS" && proxy == null) {
                        proxy = proxies[idx];
                    }
                    ++idx;
                }
            }
            return proxy;
        }

        @Override
        public void run() {
            this.runProxy(this.ruiRequest, this.ps);
        }

        private void runProxy(RuiBrowserHttpRequest ruiRequest, PrintStream ps) {
            block10: {
                String urlString = ruiRequest.getURL();
                try {
                    try {
                        Request innerRequest = null;
                        if (ruiRequest.getHeaders() != null && ruiRequest.getHeaders().containsKey("EGLREST")) {
                            this.eglRestService(urlString, ruiRequest, ps, innerRequest);
                            break block10;
                        }
                        innerRequest = ServletUtilities.createHttpRequest((String)ruiRequest.getContent());
                        this.eglRestService(urlString, ruiRequest, ps, innerRequest);
                    }
                    catch (Throwable e) {
                        System.err.println(urlString);
                        e.printStackTrace();
                        try {
                            EvServer.this.fail(ps);
                        }
                        catch (Exception exception) {}
                        if (ps != null) {
                            ps.flush();
                            ps.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.flush();
                        ps.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eglRestService(String urlString, RuiBrowserHttpRequest ruiRequest, PrintStream ps, Request innerRequest) {
            ServiceKind serviceKind = innerRequest != null && ProxyUtilities.isSoapCall((Request)innerRequest) ? ServiceKind.WEB : ServiceKind.REST;
            try {
                Response response;
                IContext context;
                boolean canUseTestServer;
                Integer intContextKey = null;
                if (ruiRequest.getArguments().containsKey("contextKey")) {
                    intContextKey = new Integer((String)ruiRequest.getArguments().get("contextKey"));
                } else {
                    int idx = ruiRequest.getContent().indexOf("contextKey=");
                    if (idx != -1) {
                        try {
                            intContextKey = new Integer(ruiRequest.getContent().substring(idx + 11));
                        }
                        catch (Exception exception) {}
                    }
                }
                Request request = null;
                this.isDedicated = innerRequest != null && ProxyUtilities.isEGLDedicatedCall((Request)innerRequest);
                boolean bl = canUseTestServer = this.isDedicated && !EvServer.this.isDesignPane(intContextKey) || EvServer.this.isPreviewPane(intContextKey);
                if (!canUseTestServer && (context = EvServer.this.findContext(intContextKey)) instanceof IContext2) {
                    canUseTestServer = ((IContext2)context).useTestServer();
                }
                if (canUseTestServer) {
                    IProject project = null;
                    if (this.isDedicated) {
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(urlString));
                    } else {
                        int start;
                        int end;
                        String innerURI = innerRequest.uri;
                        if (innerURI.startsWith("workspace://") && (end = innerURI.indexOf(47, start = 12)) != -1) {
                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(innerURI.substring(start, end));
                        }
                    }
                    if (project != null && project.isAccessible()) {
                        TestServerConfiguration config;
                        TestServerManager start = EvServer.this.testServerMgr;
                        synchronized (start) {
                            config = EvServer.this.testServerMgr.getServerConfiguration(project, true);
                            config.start(null, true);
                        }
                        String encodedProject = project.getName();
                        try {
                            encodedProject = URLEncoder.encode(encodedProject, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        String testServerURI = "http://localhost:" + config.getPort() + "/" + encodedProject;
                        request = new Request();
                        request.body = ruiRequest.getContent();
                        request.method = HttpUtilities.convert((String)ruiRequest.getMethod());
                        EDictionary headers = new EDictionary();
                        Map headerMap = ruiRequest.getHeaders();
                        for (Map.Entry entry : headerMap.entrySet()) {
                            headers.put((String)entry.getKey(), entry.getValue());
                        }
                        request.headers = headers;
                        if (this.isDedicated) {
                            serviceKind = ServiceKind.EGL;
                            request.uri = testServerURI = String.valueOf(testServerURI) + "/___proxy";
                            innerRequest = request;
                        } else {
                            testServerURI = String.valueOf(testServerURI) + "/restservices/";
                            String innerURI = innerRequest.uri;
                            int start2 = innerURI.indexOf(47, 12);
                            if (start2 != -1) {
                                innerRequest.uri = testServerURI = String.valueOf(testServerURI) + innerURI.substring(start2 + 1);
                            }
                        }
                    }
                }
                if (request == null) {
                    request = new Request();
                    request.uri = ruiRequest.getURL();
                    request.body = ruiRequest.getContent();
                    request.method = HttpUtilities.convert((String)ruiRequest.getMethod());
                    EDictionary headers = new EDictionary();
                    Map headerMap = ruiRequest.getHeaders();
                    for (Map.Entry entry : headerMap.entrySet()) {
                        headers.put((String)entry.getKey(), entry.getValue());
                    }
                    request.headers = headers;
                }
                if ((response = super.runProxy(urlString, request, innerRequest)) != null) {
                    ps.print(EvServer.this.getResponseHeader(urlString, EvServer.this.getContentType(urlString), !urlString.endsWith(".egl"), response.status, response.statusMessage));
                    String content = response.body;
                    ps.write(content.getBytes("utf-8"));
                }
            }
            catch (IOException ioe) {
                String errorMsg = JsonUtilities.createJsonAnyException((AnyException)ServiceUtilities.buildServiceInvocationException((String)"EGL0022E", (Object[])new String[]{urlString}, (Throwable)ioe, (ServiceKind)serviceKind));
                ps.print(EvServer.this.getBadResponseHeader());
                ps.print(errorMsg);
            }
            catch (Throwable t) {
                String errorMsg = JsonUtilities.createJsonAnyException((AnyException)ServiceUtilities.buildServiceInvocationException((String)"EGL0028E", (Object[])new Object[0], (Throwable)t, (ServiceKind)serviceKind));
                ps.print(EvServer.this.getBadResponseHeader());
                ps.print(errorMsg);
            }
        }

        protected boolean isEGLDedicatedCall(Request request) {
            return false;
        }

        protected void setBody(Response outerResponse, Response innerResponse) {
            if (this.isDedicated) {
                outerResponse.body = innerResponse.body;
            } else {
                super.setBody(outerResponse, innerResponse);
            }
        }

        private String getProjectName(String url) {
            int indx = url.indexOf("___proxy");
            if (indx > 0) {
                String name = url.substring(0, indx);
                name = name.replace("/", "");
                name = name.replace("\\", "");
                name = name.trim();
                try {
                    return URLDecoder.decode(name, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return name;
                }
            }
            return "";
        }
    }
}

