/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.server;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.rui.internal.lookup.PreviewIREnvironmentManager;
import org.eclipse.edt.ide.rui.server.AbstractContentProvider;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.utils.DebugIFileLocator;
import org.eclipse.edt.ide.rui.utils.FileLocator;
import org.eclipse.edt.ide.rui.utils.IFileLocator;
import org.eclipse.edt.ide.rui.utils.PreviewFileLocator;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationResult;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.xml.sax.SAXException;

public abstract class WorkingCopyContentProvider
extends AbstractContentProvider {
    protected EvEditorProvider editorProvider = null;

    public WorkingCopyContentProvider(EvEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    @Override
    protected FileLocator getFileLocator(IProject project) throws CoreException {
        return new PreviewFileLocator(project, this.editorProvider.getGenerationDirectory());
    }

    @Override
    protected IFileLocator getIFileLocator(IProject project) throws CoreException {
        return new DebugIFileLocator(project);
    }

    @Override
    protected byte[] generateHTMLFile(FileLocator locator, String resourceName, String projectName) throws SAXException, IOException {
        WorkingCopyGenerationResult result = this.editorProvider.getLastGenerationResult();
        if (result != null && result.hasError()) {
            return null;
        }
        return super.generateHTMLFile(locator, resourceName, projectName);
    }

    @Override
    protected IEnvironment getEnvironmentForGeneration(IProject project) {
        return PreviewIREnvironmentManager.getPreviewIREnvironment(project, this.editorProvider.getGenerationDirectory().toFile());
    }
}

