/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.IEGLProject;

public abstract class IFileLocator {
    protected static final String WEB_CONTENT = "WebContent";
    private List eglProjectPath;
    private String[] resourceLocations;
    private IProject project;

    public IFileLocator(IProject project) throws CoreException {
        this.project = project;
        this.eglProjectPath = Util.getEGLProjectPath((IProject)project);
        this.resourceLocations = this.initResourceLocations(project);
    }

    protected IFileLocator() {
    }

    public IFile findFile(String name) {
        String[] resourceLocations = this.getResourceLocations();
        for (IEGLProject eglProject : this.eglProjectPath) {
            int i = 0;
            while (i < resourceLocations.length) {
                String location = resourceLocations[i];
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(eglProject.getPath().append(location).append(name));
                if (file.exists()) {
                    return file;
                }
                ++i;
            }
        }
        return null;
    }

    protected abstract String[] initResourceLocations(IProject var1) throws CoreException;

    protected String[] getResourceLocations() {
        return this.resourceLocations;
    }
}

