/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.internal.sql.util;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.edt.compiler.internal.sql.util.SQLUtility;
import org.eclipse.edt.ide.internal.sql.util.DatabaseProductVersion;

public class EGLConnectibleDatabases {
    private static EGLConnectibleDatabases INSTANCE = new EGLConnectibleDatabases();
    private static final HashSet<DatabaseProductVersion> filteredDatabases = new HashSet();
    private static final HashSet<String> validVendors = new HashSet(8);

    static {
        validVendors.add("DB2 UDB");
        validVendors.add("DB2 UDB iSeries");
        validVendors.add("DB2 UDB zSeries");
        validVendors.add("Informix");
        validVendors.add("Oracle");
        validVendors.add("SQL Server");
        validVendors.add("Derby");
        validVendors.add("Generic JDBC");
        validVendors.add("DB2 UDB zVSE");
        validVendors.add("DB2 ALIAS");
        validVendors.add("MySql");
        DatabaseDefinitionRegistry dbDefReg = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        Iterator productIterator = dbDefReg.getConnectibleProducts();
        while (productIterator.hasNext()) {
            String productName = (String)productIterator.next();
            if (!validVendors.contains(productName) || productName.equals("Generic JDBC") && !SQLUtility.isTerraDataSupported()) continue;
            Iterator versionIterator = dbDefReg.getConnectibleVersions(productName);
            while (versionIterator.hasNext()) {
                String version = (String)versionIterator.next();
                if (productName.equals("DB2 UDB") && version.equals("V7.2")) continue;
                filteredDatabases.add(new DatabaseProductVersion(productName, version));
            }
        }
    }

    public static EGLConnectibleDatabases getInstance() {
        return INSTANCE;
    }

    public DatabaseProductVersion[] getEGLDatabases() {
        return filteredDatabases.toArray(new DatabaseProductVersion[filteredDatabases.size()]);
    }

    public static boolean isSupportedProduct(String vendor) {
        return validVendors.contains(vendor);
    }
}

