/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.internal.sql.util;

import java.util.List;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalQualifierType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.XMLDataType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.edt.compiler.internal.EGLSQLKeywordHandler;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLRetrieveResults;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLStructureItem;
import org.eclipse.edt.ide.sql.SQLPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EGLSQLRetrieveUtility {
    private boolean isSQLJoin = false;
    private String[][] sqlTables;
    private Object[][] sqlTableVariables;
    private EGLSQLRetrieveResults retrieveResults;
    private ConnectionInfo connectionInfo;
    private IConnectionProfile connectionProfile;
    private List undefinedTables;
    private List matchingTables;
    private String dbName;
    private boolean isCharType;
    private boolean isMBCharType;
    private boolean isCharacterUnicode;
    private boolean isNationalCharacterUnicode;
    private boolean isCharacterLimitedString;
    private boolean isNationalCharacterLimitedString;
    private boolean isNationalCharacterString;
    private boolean isLowercaseItemName;
    private boolean isLowercaseItemNameAndUppercaseCharacterAfterUnderscore = true;
    private boolean isRemoveUnderscoresInName = true;
    private String typeForDateTimeTypes = "timestamp";
    private boolean addSqlDataCode;
    private static final char UNDERSCORE = '_';
    private static EGLSQLRetrieveUtility INSTANCE = new EGLSQLRetrieveUtility();

    public static EGLSQLRetrieveUtility getInstance() {
        return INSTANCE;
    }

    private void setCharControlOptionsBasedOnSQLPreferences() {
        this.isCharType = this.getEGLBasePlugin().isCharacterOptionChar();
        this.isMBCharType = this.getEGLBasePlugin().isCharacterOptionMBChar();
        this.isCharacterUnicode = this.getEGLBasePlugin().isCharacterOptionUnicode();
        this.isCharacterLimitedString = this.getEGLBasePlugin().isCharacterOptionLimitedString();
    }

    private void setNationalCharOptionsBasedOnSQLPreferences() {
        this.isNationalCharacterUnicode = this.getEGLBasePlugin().isNationalCharOptionUnicode();
        this.isNationalCharacterString = this.getEGLBasePlugin().isNationalCharOptionString();
        this.isNationalCharacterLimitedString = this.getEGLBasePlugin().isNationalCharOptionLimitedString();
    }

    private void setItemNameControlOptionsBasedOnSQLPreferences() {
        this.isLowercaseItemName = this.getEGLBasePlugin().isLowercaseItemNameCaseOption();
        this.isLowercaseItemNameAndUppercaseCharacterAfterUnderscore = this.getEGLBasePlugin().isLowercaseNameAndUppercaseCharacterAfterUnderscoreOption();
        this.isRemoveUnderscoresInName = this.getEGLBasePlugin().isRemoveUnderscoresInNameOption();
    }

    private void setIsSQLJoin() {
        if (this.sqlTableVariables == null) {
            this.sqlTableVariables = new Object[0][0];
        }
        if (this.sqlTables.length > 1 || this.sqlTableVariables.length > 1 || this.sqlTables.length + this.sqlTableVariables.length > 1) {
            this.isSQLJoin = true;
        }
    }

    public boolean resolveToEGLType(DatabaseDefinition databaseDefinition, PredefinedDataType type, String tableName, String itemName, EGLSQLStructureItem sqlStructureItem, boolean allowTextTypesForDateTimeTypes, boolean isNullable) {
        this.setPreferences();
        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(type.getName());
        boolean recognizedType = true;
        int intType = type.getName().equals("DATETIME") && type instanceof IntervalDataType ? this.setJDBCType(type) : (type.getName().equals("XML") && type instanceof XMLDataType ? 2009 : typeDefinition.getJdbcEnumType());
        switch (intType) {
            case 1: 
            case 2009: {
                sqlStructureItem.setSQLVar(false);
                recognizedType = this.handleCharType(type, sqlStructureItem, itemName);
                break;
            }
            case 12: {
                sqlStructureItem.setSQLVar(true);
                recognizedType = this.handleCharType(type, sqlStructureItem, itemName);
                break;
            }
            case -1: {
                sqlStructureItem.setSQLVar(true);
                recognizedType = this.handleLongVarCharType(type, sqlStructureItem, itemName);
                break;
            }
            case 91: {
                this.handleDateType(sqlStructureItem, allowTextTypesForDateTimeTypes, isNullable);
                break;
            }
            case 92: {
                this.handleTimeType(sqlStructureItem, allowTextTypesForDateTimeTypes, isNullable);
                break;
            }
            case 93: {
                this.handleTimestampType(sqlStructureItem, allowTextTypesForDateTimeTypes, isNullable);
                break;
            }
            case -6: 
            case 5: {
                sqlStructureItem.setPrimitiveType("smallInt");
                break;
            }
            case -5: {
                sqlStructureItem.setPrimitiveType("bigInt");
                break;
            }
            case 7: {
                sqlStructureItem.setPrimitiveType("smallFloat");
                break;
            }
            case 4: {
                sqlStructureItem.setPrimitiveType("int");
                break;
            }
            case 6: 
            case 8: {
                sqlStructureItem.setPrimitiveType("float");
                break;
            }
            case 2: {
                this.handleNumericType(type, sqlStructureItem, itemName);
                break;
            }
            case 3: {
                this.handleDecimalType(type, sqlStructureItem, itemName);
                break;
            }
            case -3: 
            case -2: {
                this.handleBinaryType(type, sqlStructureItem, itemName);
                break;
            }
            case -4: {
                sqlStructureItem.setPrimitiveType("hex");
                sqlStructureItem.setLength("65534");
                break;
            }
            case 2005: {
                sqlStructureItem.setPrimitiveType("clob");
                break;
            }
            case 2004: {
                sqlStructureItem.setPrimitiveType("blob");
                break;
            }
            case -7: {
                sqlStructureItem.setPrimitiveType("smallInt");
                break;
            }
            case 16: {
                sqlStructureItem.setPrimitiveType("boolean");
                break;
            }
            default: {
                recognizedType = false;
            }
        }
        return recognizedType;
    }

    private int setJDBCType(PredefinedDataType type) {
        int intType;
        IntervalQualifierType qualifier = ((IntervalDataType)type).getLeadingQualifier();
        switch (qualifier.getValue()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                intType = 92;
                break;
            }
            default: {
                intType = 93;
            }
        }
        return intType;
    }

    public boolean populateStructureItem(DatabaseDefinition definition, Column column, EGLSQLStructureItem item) {
        boolean success = false;
        this.setPreferences();
        String name = column.getName();
        String itemName = this.changeItemNameBasedOnControlOptionsInSQLRetrievePreferences(name);
        PredefinedDataType type = (PredefinedDataType)column.getContainedType();
        if (type == null) {
            item.getMessages().add(this.getInfoMessage("4584", new String[]{itemName, "<UNKNOWN>"}));
        } else if (this.resolveToEGLType(definition, type, column.getTable().getName(), itemName, item, false, column.isNullable())) {
            item.setDescription(name);
            item.setNullable(column.isNullable());
            item.setColumnName(name);
            item.setReadOnly(false);
            item.setName(itemName);
            item.setColumnName(this.addEscapeCharactersWhenNecessaryInName(item.getColumnName()));
            success = true;
        } else {
            item.getMessages().add(this.getInfoMessage("4584", new String[]{itemName, type.getName()}));
        }
        return success;
    }

    private boolean handleCharType(PredefinedDataType type, EGLSQLStructureItem newItem, String itemName) {
        int length = 0;
        String stringLength = "0";
        boolean charType = true;
        boolean recognizedType = true;
        EStructuralFeature feature = type.eClass().getEStructuralFeature("length");
        switch (type.getPrimitiveType().getValue()) {
            case 0: 
            case 1: 
            case 23: {
                break;
            }
            case 3: 
            case 4: {
                charType = false;
                break;
            }
            default: {
                recognizedType = false;
            }
        }
        if (recognizedType) {
            if (!(type instanceof XMLDataType)) {
                try {
                    stringLength = ((Integer)type.eGet(feature)).toString();
                    length = Integer.parseInt(stringLength);
                }
                catch (NumberFormatException numberFormatException) {
                    newItem.getMessages().add(this.getErrorMessage("4589", new String[]{stringLength, itemName}));
                    stringLength = "0";
                }
            }
            if (charType) {
                newItem.setPrimitiveType(this.changeCharacterTypeBasedOnPreferences());
                newItem.setLength(stringLength);
                if (newItem.getPrimitiveType().equals("unicode") && length > 16383) {
                    newItem.getMessages().add(this.getInfoMessage("4592", new String[]{itemName, stringLength}));
                    newItem.setLength("16383");
                }
            } else {
                newItem.setPrimitiveType(this.changeNationalCharacterTypeBasedOnPreferences());
                newItem.setLength(stringLength);
            }
        }
        return recognizedType;
    }

    private void handleDateType(EGLSQLStructureItem newItem, boolean allowTextTypesForDateTimeTypes, boolean isNullable) {
        if (allowTextTypesForDateTimeTypes && this.typeForDateTimeTypes.length() > 0) {
            newItem.setPrimitiveType(this.typeForDateTimeTypes);
            newItem.setLength("10");
            if (this.addSqlDataCode) {
                newItem.setSqlDataCode(isNullable ? "384" : "385");
            }
        } else {
            newItem.setPrimitiveType("date");
        }
    }

    private void handleTimeType(EGLSQLStructureItem newItem, boolean allowTextTypesForDateTimeTypes, boolean isNullable) {
        if (allowTextTypesForDateTimeTypes && this.typeForDateTimeTypes.length() > 0) {
            newItem.setPrimitiveType(this.typeForDateTimeTypes);
            newItem.setLength("8");
            if (this.addSqlDataCode) {
                newItem.setSqlDataCode(isNullable ? "388" : "389");
            }
        } else {
            newItem.setPrimitiveType("time");
        }
    }

    private void handleTimestampType(EGLSQLStructureItem newItem, boolean allowTextTypesForDateTimeTypes, boolean isNullable) {
        if (allowTextTypesForDateTimeTypes && this.typeForDateTimeTypes.length() > 0) {
            newItem.setPrimitiveType(this.typeForDateTimeTypes);
            newItem.setLength("26");
            if (this.addSqlDataCode) {
                newItem.setSqlDataCode(isNullable ? "392" : "393");
            }
        } else {
            newItem.setPrimitiveType("timeStamp");
        }
    }

    private boolean handleLongVarCharType(PredefinedDataType type, EGLSQLStructureItem newItem, String itemName) {
        int length = 0;
        String stringLength = "0";
        boolean charType = true;
        boolean recognizedType = true;
        EStructuralFeature feature = type.eClass().getEStructuralFeature("length");
        stringLength = ((Integer)type.eGet(feature)).toString();
        switch (type.getPrimitiveType().getValue()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                charType = false;
                break;
            }
            default: {
                recognizedType = false;
            }
        }
        if (recognizedType) {
            try {
                length = Integer.parseInt(stringLength);
            }
            catch (NumberFormatException numberFormatException) {
                newItem.getMessages().add(this.getErrorMessage("4589", new String[]{stringLength, itemName}));
                stringLength = "0";
            }
            if (charType) {
                newItem.setPrimitiveType(this.changeCharacterTypeBasedOnPreferences());
                newItem.setLength(stringLength);
                if (newItem.getPrimitiveType().equals("unicode") && length > 16383) {
                    newItem.getMessages().add(this.getInfoMessage("4592", new String[]{itemName, stringLength}));
                    newItem.setLength("16383");
                } else if (length > Short.MAX_VALUE) {
                    newItem.getMessages().add(this.getInfoMessage("4590", new String[]{itemName, stringLength}));
                    newItem.setLength("32767");
                }
            } else {
                newItem.setPrimitiveType(this.changeNationalCharacterTypeBasedOnPreferences());
                newItem.setLength(stringLength);
                if (length > 16383) {
                    newItem.getMessages().add(this.getInfoMessage("4591", new String[]{itemName, stringLength}));
                    newItem.setLength("16383");
                }
            }
        }
        return recognizedType;
    }

    private void handleNumericType(PredefinedDataType type, EGLSQLStructureItem newItem, String itemName) {
        int length = 0;
        int decimals = 0;
        String stringLength = "0";
        String stringDecimal = "0";
        newItem.setPrimitiveType("num");
        EStructuralFeature fPrecision = type.eClass().getEStructuralFeature("precision");
        EStructuralFeature fScale = type.eClass().getEStructuralFeature("scale");
        stringLength = ((Integer)type.eGet(fPrecision)).toString();
        stringDecimal = ((Integer)type.eGet(fScale)).toString();
        try {
            length = Integer.parseInt(stringLength);
            if (length == 0) {
                newItem.setPrimitiveType("float");
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            newItem.getMessages().add(this.getErrorMessage("4589", new String[]{stringLength, itemName}));
            stringLength = "0";
        }
        try {
            decimals = Integer.parseInt(stringDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            newItem.getMessages().add(this.getErrorMessage("4593", new String[]{stringDecimal, itemName}));
            stringDecimal = "0";
        }
        if (length > 32) {
            newItem.getMessages().add(this.getInfoMessage("4585", new String[]{itemName, stringLength}));
            newItem.setLength("32");
        } else {
            newItem.setLength(stringLength);
        }
        if (decimals < 0) {
            decimals = -decimals;
            stringDecimal = Integer.toString(decimals);
        }
        if (decimals > 32) {
            newItem.getMessages().add(this.getInfoMessage("4586", new String[]{itemName, stringDecimal}));
            newItem.setDecimals("32");
        } else if (decimals > 0) {
            newItem.setDecimals(stringDecimal);
        }
    }

    private void handleDecimalType(PredefinedDataType type, EGLSQLStructureItem newItem, String itemName) {
        int length = 0;
        int decimals = 0;
        String stringLength = "0";
        String stringDecimal = "0";
        EStructuralFeature fPrecision = type.eClass().getEStructuralFeature("precision");
        EStructuralFeature fScale = type.eClass().getEStructuralFeature("scale");
        stringLength = ((Integer)type.eGet(fPrecision)).toString();
        stringDecimal = ((Integer)type.eGet(fScale)).toString();
        if (type.getName().equalsIgnoreCase("money")) {
            newItem.setPrimitiveType("money");
        } else {
            newItem.setPrimitiveType("decimal");
        }
        try {
            length = Integer.parseInt(stringLength);
            if (newItem.getPrimitiveType().equals("money") && length == 0) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            newItem.getMessages().add(this.getErrorMessage("4589", new String[]{stringLength, itemName}));
            stringLength = "0";
        }
        try {
            decimals = Integer.parseInt(stringDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            newItem.getMessages().add(this.getErrorMessage("4593", new String[]{stringDecimal, itemName}));
            stringDecimal = "0";
        }
        if (length > 32) {
            newItem.getMessages().add(this.getInfoMessage("4585", new String[]{itemName, stringLength}));
            newItem.setLength("32");
        } else {
            newItem.setLength(stringLength);
        }
        if (decimals > 32) {
            newItem.getMessages().add(this.getInfoMessage("4586", new String[]{itemName, stringDecimal}));
            newItem.setDecimals("32");
        } else if (decimals > 0) {
            newItem.setDecimals(stringDecimal);
        }
    }

    private void handleBinaryType(PredefinedDataType type, EGLSQLStructureItem newItem, String itemName) {
        int length = 0;
        String stringLength = "0";
        EStructuralFeature feature = type.eClass().getEStructuralFeature("length");
        stringLength = ((Integer)type.eGet(feature)).toString();
        try {
            length = Integer.parseInt(stringLength);
            if (length > 65534) {
                newItem.getMessages().add(this.getInfoMessage("4587", new String[]{itemName, stringLength}));
                length = 65534;
                stringLength = String.valueOf(length);
            }
        }
        catch (NumberFormatException numberFormatException) {
            newItem.getMessages().add(this.getErrorMessage("4589", new String[]{stringLength, itemName}));
        }
        newItem.setPrimitiveType("hex");
        newItem.setLength(stringLength);
    }

    private boolean isKey(String name, EList keys) {
        if (keys != null) {
            for (Column thisColumn : keys) {
                if (name == null || !name.equalsIgnoreCase(thisColumn.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private EGLMessage getErrorMessage(String messageID, String[] inserts) {
        return EGLMessage.createEGLValidationErrorMessage((String)messageID, null, (String[])inserts);
    }

    private void addInfoMessage(String messageID, String[] inserts) {
        if (this.retrieveResults != null) {
            this.retrieveResults.getMessages().add(this.getInfoMessage(messageID, inserts).getBuiltMessage());
        }
    }

    private EGLMessage getInfoMessage(String messageID, String[] inserts) {
        return EGLMessage.createEGLValidationInformationalMessage((String)messageID, null, (String[])inserts);
    }

    private void addMessageToResults(String messageText) {
        if (this.retrieveResults != null) {
            this.retrieveResults.getMessages().add(messageText);
        }
    }

    private String changeItemNameBasedOnControlOptionsInSQLRetrievePreferences(String name) {
        if (name == null) {
            return "";
        }
        String newName = this.convertCaseOfNameBasedOnPreferences(name);
        newName = this.handleUnderscoresInNameBasedOnPreferences(newName);
        return newName;
    }

    private String changeCharacterTypeBasedOnPreferences() {
        return "string";
    }

    private String changeNationalCharacterTypeBasedOnPreferences() {
        if (this.isNationalCharacterUnicodeType()) {
            return "unicode";
        }
        if (this.isNationalCharacterStringType()) {
            return "string";
        }
        if (this.isNationalCharacterLimitedStringType()) {
            return "limited string";
        }
        return "dbChar";
    }

    private String convertCaseOfNameBasedOnPreferences(String name) {
        if (name == null) {
            return "";
        }
        if (this.isLowercaseItemName()) {
            return name.toLowerCase();
        }
        if (this.isLowercaseItemNameAndUppercaseCharacterAfterUnderscore()) {
            return this.lowercaseNameAndUppercaseNextCharacterAfterUnderscore(name);
        }
        return name;
    }

    private String handleUnderscoresInNameBasedOnPreferences(String name) {
        if (name == null) {
            return "";
        }
        if (this.isRemoveUnderscoresInName()) {
            return this.removeUnderscoresFromName(name);
        }
        return name;
    }

    private boolean isCharType() {
        return this.isCharType;
    }

    private boolean isMBCharType() {
        return this.isMBCharType;
    }

    private boolean isCharacterUnicodeType() {
        return this.isCharacterUnicode;
    }

    private boolean isNationalCharacterUnicodeType() {
        return this.isNationalCharacterUnicode;
    }

    private boolean isCharacterLimitedStringType() {
        return this.isCharacterLimitedString;
    }

    private boolean isNationalCharacterLimitedStringType() {
        return this.isNationalCharacterLimitedString;
    }

    private boolean isNationalCharacterStringType() {
        return this.isNationalCharacterString;
    }

    private boolean isLowercaseItemName() {
        return this.isLowercaseItemName;
    }

    private boolean isLowercaseItemNameAndUppercaseCharacterAfterUnderscore() {
        return this.isLowercaseItemNameAndUppercaseCharacterAfterUnderscore;
    }

    private boolean isRemoveUnderscoresInName() {
        return this.isRemoveUnderscoresInName;
    }

    private String lowercaseNameAndUppercaseNextCharacterAfterUnderscore(String name) {
        String itemName = name.toLowerCase();
        StringBuffer buffer = new StringBuffer(itemName);
        int i = 0;
        while (i < buffer.length()) {
            if (i + 1 != buffer.length() && buffer.charAt(i) == '_') {
                buffer.setCharAt(i + 1, Character.toUpperCase(buffer.charAt(i + 1)));
            }
            ++i;
        }
        return buffer.toString();
    }

    private String removeUnderscoresFromName(String name) {
        StringBuffer buffer = new StringBuffer(name);
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) == '_') {
                buffer.deleteCharAt(i);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String addEscapeCharactersWhenNecessaryInName(String name) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char currentChar = name.charAt(i);
            if (currentChar == '\"' || currentChar == '\\') {
                buffer.append('\\');
            }
            buffer.append(currentChar);
            ++i;
        }
        return buffer.toString();
    }

    private void setMaxPrimitiveTypeInfoLengths(EGLSQLStructureItem item) {
        int length = item.getName().length() + item.getPrimitiveType().length();
        Set sqlClauseArray = EGLSQLKeywordHandler.getSQLClauseKeywordNamesToLowerCaseAsSet();
        if (sqlClauseArray.contains(item.getName().toLowerCase())) {
            length += 4;
        }
        if (item.getLength() != null) {
            length += item.getLength().length();
        }
        if (item.getDecimals() != null) {
            length += item.getDecimals().length();
            this.retrieveResults.setHasColumnsDefinedWithDecimals(true);
        }
        if (length > this.retrieveResults.getMaxPrimitiveTypeInfoLength()) {
            this.retrieveResults.setMaxPrimitiveTypeInfoLength(length);
        }
    }

    private void setPreferences() {
        this.setCharControlOptionsBasedOnSQLPreferences();
        this.setNationalCharOptionsBasedOnSQLPreferences();
        this.setItemNameControlOptionsBasedOnSQLPreferences();
        this.typeForDateTimeTypes = this.getEGLBasePlugin().getTypeForDateTimeTypesOption();
        this.addSqlDataCode = this.getEGLBasePlugin().getAddSqlDataCodeForDateTimeTypesOption();
    }

    private SQLPlugin getEGLBasePlugin() {
        return SQLPlugin.getPlugin();
    }
}

