/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.sql;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.sql.SQLNlsStrings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SQLPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.edt.ide.sql";
    public static String[] EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS;
    public static String[] EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS;
    public static String[] NAME_CASE_OPTION_NON_MNEMONIC_STRINGS;
    public static String[] NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS;
    public static String[] TEXT_TYPE_FOR_DATE_OPTION_NON_MNEMONIC_STRINGS;
    protected static SQLPlugin plugin;
    private IProfileListener profileListener;

    public SQLPlugin() {
        plugin = this;
    }

    public static SQLPlugin getPlugin() {
        return plugin;
    }

    public boolean isCharacterOptionLimitedString() {
        String typeOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.charOption");
        return typeOption == null || typeOption.equalsIgnoreCase(EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
    }

    public boolean isCharacterOptionChar() {
        String typeOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.charOption");
        return typeOption == null || typeOption.equalsIgnoreCase(EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
    }

    public boolean isCharacterOptionMBChar() {
        String typeOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.charOption");
        return typeOption == null || typeOption.equalsIgnoreCase(EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
    }

    public boolean isCharacterOptionUnicode() {
        String typeOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.charOption");
        return typeOption == null || typeOption.equalsIgnoreCase(EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
    }

    public boolean isNationalCharOptionUnicode() {
        String typeOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.nationalCharOption");
        return typeOption == null || typeOption.equalsIgnoreCase(EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
    }

    public boolean isNationalCharOptionString() {
        String typeOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.nationalCharOption");
        return typeOption == null || typeOption.equalsIgnoreCase(EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
    }

    public boolean isNationalCharOptionLimitedString() {
        String typeOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.nationalCharOption");
        return typeOption == null || typeOption.equalsIgnoreCase(EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
    }

    public boolean isLowercaseItemNameCaseOption() {
        String caseOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.caseOption");
        return caseOption != null && caseOption.equalsIgnoreCase(NAME_CASE_OPTION_NON_MNEMONIC_STRINGS[1]);
    }

    public boolean isLowercaseNameAndUppercaseCharacterAfterUnderscoreOption() {
        String caseOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.caseOption");
        return caseOption != null && caseOption.equalsIgnoreCase(NAME_CASE_OPTION_NON_MNEMONIC_STRINGS[2]);
    }

    public boolean isRemoveUnderscoresInNameOption() {
        String underscoreOption = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.underscoreOption");
        return underscoreOption != null && underscoreOption.equalsIgnoreCase(NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS[1]);
    }

    public String getTypeForDateTimeTypesOption() {
        if (this.getPreferenceStore().getBoolean("org.eclipse.edt.ide.sql.charForDateOption")) {
            return "char";
        }
        if (this.getPreferenceStore().contains("org.eclipse.edt.ide.sql.charForDateOption")) {
            return "";
        }
        return this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.textTypeForDateOption");
    }

    public boolean getAddSqlDataCodeForDateTimeTypesOption() {
        return this.getPreferenceStore().getBoolean("org.eclipse.edt.ide.sql.addSqlDataCodeOption");
    }

    public boolean getRetrievePrimaryKeyOption() {
        return this.getPreferenceStore().getBoolean("org.eclipse.edt.ide.sql.retrievePrimaryKeyOption");
    }

    public boolean getSQLPromptDialogOption() {
        return this.getPreferenceStore().getBoolean("org.eclipse.edt.ide.sql.promptOption");
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("org.eclipse.edt.ide.sql.charOption", EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
        store.setDefault("org.eclipse.edt.ide.sql.nationalCharOption", EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS[0]);
        store.setDefault("org.eclipse.edt.ide.sql.caseOption", NAME_CASE_OPTION_NON_MNEMONIC_STRINGS[0]);
        store.setDefault("org.eclipse.edt.ide.sql.underscoreOption", NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS[0]);
        store.setDefault("org.eclipse.edt.ide.sql.retrievePrimaryKeyOption", true);
        store.setDefault("org.eclipse.edt.ide.sql.promptOption", true);
        store.setDefault("org.eclipse.edt.ide.sql.textTypeForDateOption", "");
        store.setDefault("org.eclipse.edt.ide.sql.addSqlDataCodeOption", false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setupSQLRetrievePreferenceOutputStrings();
        this.profileListener = new IProfileListener(){

            public void profileAdded(IConnectionProfile profile) {
                if (EGLSQLUtility.getCurrentConnectionProfile() == null) {
                    IConnectionProfile[] supportedProfiles = EGLSQLUtility.getProfilesToDisplay();
                    int i = 0;
                    while (i < supportedProfiles.length) {
                        if (supportedProfiles[i].equals(profile)) {
                            SQLPlugin.this.getPreferenceStore().setValue("org.eclipse.edt.ide.sql.connectionNamedConnection", profile.getName());
                            break;
                        }
                        ++i;
                    }
                }
            }

            public void profileDeleted(IConnectionProfile profile) {
                IConnectionProfile currentProfile = EGLSQLUtility.getCurrentConnectionProfile();
                if (currentProfile != null && currentProfile.equals(profile)) {
                    SQLPlugin.this.getPreferenceStore().setToDefault("org.eclipse.edt.ide.sql.connectionNamedConnection");
                }
            }

            public void profileChanged(IConnectionProfile profile) {
            }
        };
        ProfileManager.getInstance().addProfileListener(this.profileListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.profileListener != null) {
            ProfileManager.getInstance().removeProfileListener(this.profileListener);
        }
    }

    private void setupSQLRetrievePreferenceOutputStrings() {
        String charOptionUseString = SQLNlsStrings.CharacterOptionStringLabel;
        String charOptionUseLimitedLengthString = SQLNlsStrings.CharacterOptionLimitedLengthStringLabel;
        String charOptionUseChar = SQLNlsStrings.CharacterOptionCharLabel;
        String charOptionUseMBChar = SQLNlsStrings.CharacterOptionMBCharLabel;
        String charOptionUseUnicode = SQLNlsStrings.CharacterOptionUnicodeLabel;
        String nationalCharOptionUseDBChar = SQLNlsStrings.NationalCharOptionDBCharLabel;
        String nationalCharOptionUseUnicode = SQLNlsStrings.NationalCharOptionUnicodeLabel;
        String nationalCharOptionUseString = SQLNlsStrings.NationalCharOptionStringLabel;
        String nationalCharOptionUseLimitedString = SQLNlsStrings.NationalCharOptionLimitedStringLabel;
        String nameCaseOptionDoNotChange = SQLNlsStrings.NameCaseOptionDoNotChangeLabel;
        String nameCaseOptionLowercase = SQLNlsStrings.NameCaseOptionLowercaseLabel;
        String nameCaseOptionLowercaseAndCapitalizeLetterAfterUnderscore = SQLNlsStrings.NameCaseOptionLowercaseAndCapitalizeLetterAfterUnderscoreLabel;
        String nameUnderscoreOptionDoNotChange = SQLNlsStrings.NameUnderscoreOptionDoNotChangeLabel;
        String nameUnderscoreOptionRemoveUndersores = SQLNlsStrings.NameUnderscoreOptionRemoveUndersoresLabel;
        int i = charOptionUseString.indexOf("&");
        if (i >= 0) {
            charOptionUseString = new StringBuffer(charOptionUseString).deleteCharAt(i).toString();
        }
        if ((i = charOptionUseLimitedLengthString.indexOf("&")) >= 0) {
            charOptionUseLimitedLengthString = new StringBuffer(charOptionUseLimitedLengthString).deleteCharAt(i).toString();
        }
        if ((i = charOptionUseChar.indexOf("&")) >= 0) {
            charOptionUseChar = new StringBuffer(charOptionUseChar).deleteCharAt(i).toString();
        }
        if ((i = charOptionUseMBChar.indexOf("&")) >= 0) {
            charOptionUseMBChar = new StringBuffer(charOptionUseMBChar).deleteCharAt(i).toString();
        }
        if ((i = charOptionUseUnicode.indexOf("&")) >= 0) {
            charOptionUseUnicode = new StringBuffer(charOptionUseUnicode).deleteCharAt(i).toString();
        }
        if ((i = nationalCharOptionUseDBChar.indexOf("&")) >= 0) {
            nationalCharOptionUseDBChar = new StringBuffer(nationalCharOptionUseDBChar).deleteCharAt(i).toString();
        }
        if ((i = nationalCharOptionUseUnicode.indexOf("&")) >= 0) {
            nationalCharOptionUseUnicode = new StringBuffer(nationalCharOptionUseUnicode).deleteCharAt(i).toString();
        }
        if ((i = nationalCharOptionUseString.indexOf("&")) >= 0) {
            nationalCharOptionUseString = new StringBuffer(nationalCharOptionUseString).deleteCharAt(i).toString();
        }
        if ((i = nationalCharOptionUseLimitedString.indexOf("&")) >= 0) {
            nationalCharOptionUseLimitedString = new StringBuffer(nationalCharOptionUseLimitedString).deleteCharAt(i).toString();
        }
        if ((i = nameCaseOptionDoNotChange.indexOf("&")) >= 0) {
            nameCaseOptionDoNotChange = new StringBuffer(nameCaseOptionDoNotChange).deleteCharAt(i).toString();
        }
        if ((i = nameCaseOptionLowercase.indexOf("&")) >= 0) {
            nameCaseOptionLowercase = new StringBuffer(nameCaseOptionLowercase).deleteCharAt(i).toString();
        }
        if ((i = nameCaseOptionLowercaseAndCapitalizeLetterAfterUnderscore.indexOf("&")) >= 0) {
            nameCaseOptionLowercaseAndCapitalizeLetterAfterUnderscore = new StringBuffer(nameCaseOptionLowercaseAndCapitalizeLetterAfterUnderscore).deleteCharAt(i).toString();
        }
        if ((i = nameUnderscoreOptionDoNotChange.indexOf("&")) >= 0) {
            nameUnderscoreOptionDoNotChange = new StringBuffer(nameUnderscoreOptionDoNotChange).deleteCharAt(i).toString();
        }
        if ((i = nameUnderscoreOptionRemoveUndersores.indexOf("&")) >= 0) {
            nameUnderscoreOptionRemoveUndersores = new StringBuffer(nameUnderscoreOptionRemoveUndersores).deleteCharAt(i).toString();
        }
        EGL_CHAR_OPTION_NON_MNEMONIC_STRINGS = new String[]{charOptionUseString};
        EGL_NATIONAL_CHAR_OPTION_NON_MNEMONIC_STRINGS = new String[]{nationalCharOptionUseString};
        NAME_CASE_OPTION_NON_MNEMONIC_STRINGS = new String[]{nameCaseOptionDoNotChange, nameCaseOptionLowercase, nameCaseOptionLowercaseAndCapitalizeLetterAfterUnderscore};
        NAME_UNDERSCORE_OPTION_NON_MNEMONIC_STRINGS = new String[]{nameUnderscoreOptionDoNotChange, nameUnderscoreOptionRemoveUndersores};
        TEXT_TYPE_FOR_DATE_OPTION_NON_MNEMONIC_STRINGS = new String[]{"", "string"};
    }

    public Logger getLogger() {
        Logger logger = null;
        try {
            LogManager.getLogManager().readConfiguration();
            logger = Logger.getLogger(PLUGIN_ID);
            logger.setLevel(Level.ALL);
        }
        catch (Throwable t) {
            System.out.println("ERROR - EGL UI Plugin - getting logger unsuccessfully!");
            System.out.println("REASON: " + t.getMessage());
        }
        return logger;
    }

    public String getConnectionJNDIName() {
        return "";
    }

    public String getSecondaryAuthenticationID() {
        return "";
    }

    public String getNamedConnection() {
        String conName = this.getPreferenceStore().getString("org.eclipse.edt.ide.sql.connectionNamedConnection");
        return conName;
    }
}

