/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.gen.CommonUtilities;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayLiteral;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BooleanLiteral;
import org.eclipse.edt.mof.egl.CallStatement;
import org.eclipse.edt.mof.egl.CaseStatement;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.ContinueStatement;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.DelegateInvocation;
import org.eclipse.edt.mof.egl.ExitStatement;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.ForEachStatement;
import org.eclipse.edt.mof.egl.ForStatement;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionInvocation;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.IfStatement;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.NewExpression;
import org.eclipse.edt.mof.egl.OpenUIStatement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.ReturnStatement;
import org.eclipse.edt.mof.egl.SetValuesExpression;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.WhileStatement;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.impl.EObjectImpl;

public class ReorganizeCode
extends AbstractVisitor {
    public static final IrFactory factory = IrFactory.INSTANCE;
    EglContext ctx;
    Container currentStatementContainer;
    boolean processedStatement = false;
    boolean inLocalVariableDeclaration = false;

    public List<StatementBlock> reorgCode(Statement statement, EglContext ctx) {
        Annotation annot = statement.getAnnotation("EGL_Location");
        if (annot != null) {
            ctx.setLastStatementLocation(annot);
        }
        this.ctx = ctx;
        this.currentStatementContainer = statement.getContainer();
        this.disallowRevisit();
        this.allowParentTracking();
        this.setReturnData(null);
        statement.accept((EVisitor)this);
        return (List)this.getReturnData();
    }

    private StatementBlock verify(int index) {
        StatementBlock block;
        List<Object> blockArray;
        if (this.getReturnData() == null) {
            blockArray = new ArrayList();
            blockArray.add(null);
            blockArray.add(null);
            this.setReturnData(blockArray);
        } else {
            blockArray = (List)this.getReturnData();
        }
        if (blockArray.get(index) == null) {
            block = factory.createStatementBlock();
            block.setContainer(this.currentStatementContainer);
            blockArray.set(index, block);
        }
        block = (StatementBlock)blockArray.get(index);
        return block;
    }

    public boolean visit(EObject object) {
        return true;
    }

    public boolean visit(Function object) {
        return false;
    }

    public boolean visit(Type object) {
        return false;
    }

    public boolean visit(Operation object) {
        return false;
    }

    public boolean visit(Statement object) {
        if (this.processedStatement && !this.inLocalVariableDeclaration) {
            return false;
        }
        if (this.ctx.getAttribute(object, "statementHasBeenReorganized") != null) {
            return false;
        }
        if (this.inLocalVariableDeclaration) {
            this.ctx.putAttribute(object, "statementHasBeenReorganized", Boolean.TRUE);
        }
        this.processedStatement = true;
        return true;
    }

    public boolean visit(LocalVariableDeclarationStatement object) {
        this.inLocalVariableDeclaration = true;
        return true;
    }

    public boolean visit(Assignment object) {
        if (object.getLHS().getType() instanceof ArrayType && object.getRHS() instanceof ArrayLiteral && ((Boolean)this.ctx.invoke("isAssignmentArrayMatchingWanted", object.getLHS().getType(), new Object[]{this.ctx})).booleanValue()) {
            Type elementType = ((ArrayType)object.getLHS().getType()).getElementType();
            while (elementType instanceof ArrayType) {
                elementType = ((ArrayType)elementType).getElementType();
            }
            List entries = ((ArrayLiteral)object.getRHS()).getEntries();
            if (entries != null && entries.size() == 0) {
                IntegerLiteral integerLiteral = factory.createIntegerLiteral();
                if (object.getAnnotation("EGL_Location") != null) {
                    integerLiteral.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                integerLiteral.setValue("0");
                NewExpression newExpression = factory.createNewExpression();
                if (object.getAnnotation("EGL_Location") != null) {
                    newExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                }
                newExpression.getArguments().add(integerLiteral);
                newExpression.setId(object.getLHS().getType().getTypeSignature());
                object.setRHS((Expression)newExpression);
            } else {
                this.processArrayLiteral(elementType, (ArrayLiteral)object.getRHS());
            }
        }
        if (!object.getOperator().equals("=") && object.getOperator().indexOf("=") >= 0 && ((Boolean)this.ctx.invoke("isAssignmentBreakupWanted", object.getLHS().getType(), new Object[]{this.ctx, object.getOperator(), object.getRHS().getType()})).booleanValue()) {
            BinaryExpression binExp = factory.createBinaryExpression();
            binExp.setLHS((Expression)object.getLHS());
            binExp.setRHS(object.getRHS());
            binExp.setOperator(object.getOperator().substring(0, object.getOperator().indexOf("=")));
            object.setRHS((Expression)binExp);
            object.setOperator("=");
        }
        return true;
    }

    private void processArrayLiteral(Type type, ArrayLiteral object) {
        List entries = object.getEntries();
        if (entries != null) {
            int i = 0;
            while (i < entries.size()) {
                Expression element = (Expression)entries.get(i);
                if (element instanceof ArrayLiteral) {
                    this.processArrayLiteral(type, (ArrayLiteral)element);
                } else if (element.getType() != null && element.getType().getClassifier() != null && type.getClassifier() != null && !element.getType().getClassifier().equals((Type)type.getClassifier()).booleanValue()) {
                    AsExpression asExpression = factory.createAsExpression();
                    asExpression.setEType(type);
                    asExpression.setObjectExpr(element);
                    entries.set(i, asExpression);
                }
                ++i;
            }
        }
    }

    public boolean visit(ReturnStatement object) {
        this.ctx.putAttribute(object.getContainer(), "functionHasReturnStatement", new Boolean(true));
        if (object.getExpression() != null && object.getExpression().getType() != null && IRUtils.hasSideEffects((Expression)object.getExpression())) {
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getExpression().getType());
            field.setIsNullable(object.getExpression().isNullable());
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS(object.getExpression());
            StatementBlock declarationBlock = factory.createStatementBlock();
            declarationBlock.setContainer(this.currentStatementContainer);
            declarationBlock.getStatements().add(assignmentStatement);
            field.setInitializerStatements(declarationBlock);
            field.setHasSetValuesBlock(Boolean.valueOf(true));
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            this.verify(0).getStatements().add(localDeclaration);
            object.setExpression((Expression)nameExpression);
        }
        return false;
    }

    public boolean visit(CallStatement object) {
        if (object.getInvocationTarget() instanceof MemberAccess && ((MemberAccess)object.getInvocationTarget()).getMember() instanceof Function && ((Boolean)this.ctx.invoke("requiresWrappedParameters", (EObject)object, new Object[]{this.ctx})).booleanValue()) {
            Function serviceInterfaceFunction = (Function)((MemberAccess)object.getInvocationTarget()).getMember();
            FunctionInvocation invocation = factory.createFunctionInvocation();
            invocation.setTarget((Member)serviceInterfaceFunction);
            invocation.setId(serviceInterfaceFunction.getId());
            invocation.getArguments().addAll(object.getArguments());
            this.processInvocation((InvocationExpression)invocation);
        }
        return true;
    }

    public boolean visit(CaseStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(ForStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(ForEachStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(OpenUIStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(WhileStatement object) {
        ReorganizeLabel reorganizeLabel;
        if (IRUtils.hasSideEffects((Expression)object.getCondition())) {
            UnaryExpression unaryExpression = factory.createUnaryExpression();
            unaryExpression.setOperator("!");
            unaryExpression.setExpression(object.getCondition());
            IfStatement ifStatement = factory.createIfStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                ifStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            ifStatement.setContainer(this.currentStatementContainer);
            ifStatement.setCondition((Expression)unaryExpression);
            StatementBlock statementBlock = factory.createStatementBlock();
            statementBlock.setContainer(ifStatement.getContainer());
            ExitStatement exitStatement = factory.createExitStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                exitStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            exitStatement.setContainer(statementBlock.getContainer());
            exitStatement.setExitStatementType(Integer.valueOf(4));
            statementBlock.getStatements().add(exitStatement);
            ifStatement.setTrueBranch((Statement)statementBlock);
            BooleanLiteral booleanLiteral = factory.createBooleanLiteral();
            booleanLiteral.setBooleanValue(Boolean.valueOf(true));
            object.setCondition((Expression)booleanLiteral);
            ((StatementBlock)object.getBody()).getStatements().add(0, ifStatement);
        }
        if ((reorganizeLabel = new ReorganizeLabel()).reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return false;
    }

    public boolean visit(IfStatement object) {
        ReorganizeLabel reorganizeLabel;
        if (IRUtils.hasSideEffects((Expression)object.getCondition())) {
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getCondition().getType());
            field.setIsNullable(object.getCondition().isNullable());
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS(object.getCondition());
            StatementBlock declarationBlock = factory.createStatementBlock();
            declarationBlock.setContainer(this.currentStatementContainer);
            declarationBlock.getStatements().add(assignmentStatement);
            field.setInitializerStatements(declarationBlock);
            field.setHasSetValuesBlock(Boolean.valueOf(true));
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            this.verify(0).getStatements().add(localDeclaration);
            object.setCondition((Expression)nameExpression);
        }
        if ((reorganizeLabel = new ReorganizeLabel()).reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        if (object.getFalseBranch() != null && !(object.getFalseBranch() instanceof StatementBlock)) {
            StatementBlock block = factory.createStatementBlock();
            block.setContainer(this.currentStatementContainer);
            block.getStatements().add(object.getFalseBranch());
            object.setFalseBranch((Statement)block);
        }
        return false;
    }

    public boolean visit(BinaryExpression object) {
        if (object.getLHS().getType() != null && object.getLHS().getType().getClassifier() != null && object.getLHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue() && object.getOperator() != null && (object.getOperator().equals("+") || object.getOperator().equals("::"))) {
            QualifiedFunctionInvocation invocation = factory.createQualifiedFunctionInvocation();
            if (object.getAnnotation("EGL_Location") != null) {
                invocation.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            if (object.getRHS().getType() != null && object.getRHS().getType().getClassifier() != null && object.getRHS().getType().getClassifier().equals(TypeUtils.Type_LIST).booleanValue()) {
                invocation.setId("appendAll");
            } else {
                invocation.setId("appendElement");
            }
            Expression lhsExpression = object.getLHS();
            while (lhsExpression instanceof BinaryExpression) {
                lhsExpression = ((BinaryExpression)lhsExpression).getRHS();
            }
            invocation.setQualifier(lhsExpression);
            invocation.getArguments().add(object.getRHS());
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), invocation);
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)invocation);
            }
        }
        return true;
    }

    public boolean visit(SetValuesExpression object) {
        boolean hasSideEffects = IRUtils.hasSideEffects((Expression)object.getTarget());
        if (hasSideEffects) {
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getType());
            field.setIsNullable(true);
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            this.verify(0).getStatements().add(0, localDeclaration);
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getName());
            declarationExpression = ((LocalVariableDeclarationStatement)object.getSettings().getStatements().get(0)).getExpression();
            MemberName tempExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                tempExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            tempExpression.setMember((Member)declarationExpression.getFields().get(0));
            tempExpression.setId(((Field)declarationExpression.getFields().get(0)).getName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS((Expression)tempExpression);
            object.getSettings().getStatements().add(assignmentStatement);
            this.verify(0).getStatements().add(1, object.getSettings());
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), nameExpression);
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)nameExpression);
            }
        } else {
            this.verify(1).getStatements().add(object.getSettings());
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), object.getTarget());
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)object.getTarget());
            }
        }
        return true;
    }

    public boolean visit(QualifiedFunctionInvocation object) {
        if ((object.getId().equalsIgnoreCase("appendElement") || object.getId().equalsIgnoreCase("insertElement") || object.getId().equalsIgnoreCase("setElement")) && object.getQualifier().getType() instanceof ArrayType && ((Boolean)this.ctx.invoke("isAssignmentArrayMatchingWanted", object.getQualifier().getType(), new Object[]{this.ctx})).booleanValue()) {
            Type elementType = ((ArrayType)object.getQualifier().getType()).getElementType();
            while (elementType instanceof ArrayType) {
                elementType = ((ArrayType)elementType).getElementType();
            }
            int i = 0;
            while (i < object.getArguments().size()) {
                if (object.getArguments().get(i) instanceof ArrayLiteral) {
                    this.processArrayLiteral(elementType, (ArrayLiteral)object.getArguments().get(i));
                }
                ++i;
            }
        }
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    public boolean visit(FunctionInvocation object) {
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    public boolean visit(DelegateInvocation object) {
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    private void processInvocationConstantParameters(InvocationExpression object) {
        int i = 0;
        while (i < object.getTarget().getParameters().size()) {
            if (((FunctionParameter)object.getTarget().getParameters().get(i)).isConst().booleanValue()) {
                this.ctx.putAttribute(object.getArguments().get(i), "functionParameterIsConst", Boolean.TRUE);
            }
            ++i;
        }
    }

    private void processInvocation(InvocationExpression object) {
        this.processInvocationConstantParameters(object);
        boolean altered = false;
        boolean[] argumentToBeAltered = new boolean[object.getTarget().getParameters().size()];
        int i = 0;
        while (i < object.getTarget().getParameters().size()) {
            if (CommonUtilities.isArgumentToBeAltered((FunctionParameter)object.getTarget().getParameters().get(i), (Expression)object.getArguments().get(i), this.ctx)) {
                altered = true;
                argumentToBeAltered[i] = true;
            }
            ++i;
        }
        if (!altered) {
            return;
        }
        i = 0;
        while (i < object.getTarget().getParameters().size()) {
            FunctionParameter parameter = (FunctionParameter)object.getTarget().getParameters().get(i);
            if (argumentToBeAltered[i]) {
                StatementBlock declarationBlock;
                Assignment assignment;
                AssignmentStatement assignmentStatement;
                MemberName nameExpression;
                Field field;
                DeclarationExpression declarationExpression;
                LocalVariableDeclarationStatement localDeclaration;
                String temporary;
                if (parameter.getParameterKind() == ParameterKind.PARM_IN) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getName());
                    assignmentStatement = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setContainer(this.currentStatementContainer);
                    assignment = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setAssignment(assignment);
                    assignment.setLHS((LHSExpr)nameExpression);
                    assignment.setRHS((Expression)object.getArguments().get(i));
                    declarationBlock = factory.createStatementBlock();
                    declarationBlock.setContainer(this.currentStatementContainer);
                    declarationBlock.getStatements().add(assignmentStatement);
                    field.setInitializerStatements(declarationBlock);
                    field.setHasSetValuesBlock(Boolean.valueOf(true));
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_IN);
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    this.verify(0).getStatements().add(localDeclaration);
                    object.getArguments().set(i, nameExpression);
                } else if (parameter.getParameterKind() == ParameterKind.PARM_INOUT) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_INOUT);
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getName());
                    assignmentStatement = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setContainer(this.currentStatementContainer);
                    assignment = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setAssignment(assignment);
                    assignment.setLHS((LHSExpr)nameExpression);
                    assignment.setRHS((Expression)object.getArguments().get(i));
                    declarationBlock = factory.createStatementBlock();
                    declarationBlock.setContainer(this.currentStatementContainer);
                    declarationBlock.getStatements().add(assignmentStatement);
                    field.setInitializerStatements(declarationBlock);
                    field.setHasSetValuesBlock(Boolean.valueOf(true));
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    this.verify(0).getStatements().add(localDeclaration);
                    if (object.getArguments().get(i) instanceof LHSExpr) {
                        assignmentStatement = factory.createAssignmentStatement();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setContainer(this.currentStatementContainer);
                        assignment = factory.createAssignment();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setAssignment(assignment);
                        assignment.setLHS((LHSExpr)object.getArguments().get(i));
                        assignment.setRHS((Expression)nameExpression);
                        this.verify(1).getStatements().add(assignmentStatement);
                    }
                    object.getArguments().set(i, nameExpression);
                } else if (parameter.getParameterKind() == ParameterKind.PARM_OUT) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_OUT);
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getName());
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    this.verify(0).getStatements().add(localDeclaration);
                    if (object.getArguments().get(i) instanceof LHSExpr) {
                        assignmentStatement = factory.createAssignmentStatement();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setContainer(this.currentStatementContainer);
                        assignment = factory.createAssignment();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setAssignment(assignment);
                        assignment.setLHS((LHSExpr)object.getArguments().get(i));
                        assignment.setRHS((Expression)nameExpression);
                        this.verify(1).getStatements().add(assignmentStatement);
                    }
                    object.getArguments().set(i, nameExpression);
                }
            }
            ++i;
        }
    }

    public class ReorganizeLabel
    extends AbstractVisitor {
        EglContext ctx;
        boolean needsLabel;
        boolean processed;
        int labelType;

        public boolean reorgLabel(Statement statement, EglContext ctx) {
            this.ctx = ctx;
            this.disallowRevisit();
            this.allowParentTracking();
            statement.accept((EVisitor)this);
            return this.needsLabel;
        }

        public boolean visit(EObject object) {
            return true;
        }

        public boolean visit(Function object) {
            return false;
        }

        public boolean visit(Type object) {
            return false;
        }

        public boolean visit(Operation object) {
            return false;
        }

        public boolean visit(ContinueStatement object) {
            if (object.getLabel() == null || object.getLabel().length() <= 0) {
                if (object.getContinueType() == 1 && this.labelType == 2) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 2 && this.labelType == 3) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 3 && this.labelType == 5) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 4 && this.labelType == 6) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 0) {
                    this.needsLabel = true;
                }
            }
            return false;
        }

        public boolean visit(ExitStatement object) {
            if (object.getLabel() == null || object.getLabel().length() <= 0) {
                if (object.getExitStatementType() == 1 && this.labelType == 1) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 3 && this.labelType == 2) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 5 && this.labelType == 3) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 2 && this.labelType == 4) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 6 && this.labelType == 5) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 4 && this.labelType == 6) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() != 9 && object.getExitStatementType() != 7 && object.getExitStatementType() != 9 && object.getExitStatementType() == 0) {
                    this.needsLabel = true;
                }
            }
            return false;
        }

        public boolean visit(CaseStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 1;
                return true;
            }
            return this.labelType != 1;
        }

        public boolean visit(ForStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 2;
                return true;
            }
            return this.labelType != 2;
        }

        public boolean visit(ForEachStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 3;
                return true;
            }
            return this.labelType != 3;
        }

        public boolean visit(IfStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 4;
                return true;
            }
            return this.labelType != 4;
        }

        public boolean visit(OpenUIStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 5;
                return true;
            }
            return this.labelType != 5;
        }

        public boolean visit(WhileStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 6;
                return true;
            }
            return this.labelType != 6;
        }

        public boolean visit(Statement object) {
            return true;
        }
    }
}

