/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.egl.EglGenerator;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.generator.egl.Activator;
import org.eclipse.edt.ide.ui.internal.EclipseJava2EGL;
import org.eclipse.edt.ide.ui.internal.actions.ClassFiles;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.IProgressService;

public class Java2EglAction
implements IActionDelegate {
    protected IStructuredSelection fSelection;
    private IWorkbenchSite fSite;

    public void run(IAction action) {
        Iterator iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            try {
                IPath path;
                IResource resource = (IResource)iter.next();
                if (resource instanceof IFile) {
                    path = resource.getProjectRelativePath();
                    IPath filePath = path.removeFirstSegments(1).removeFileExtension();
                    URLClassLoader loader = new URLClassLoader(new URL[]{resource.getProject().getLocation().append(path.segment(0)).toFile().toURI().toURL()}, null);
                    ProjectEnvironment environment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(resource.getProject());
                    ProjectIREnvironment env = environment.getIREnvironment();
                    env.initSystemEnvironment(environment.getSystemEnvironment());
                    Java2EglAction.generateClass(filePath.toOSString().replace(File.separatorChar, '.'), resource.getProject(), loader, (IEnvironment)env);
                    continue;
                }
                if (!(resource instanceof IFolder)) continue;
                path = resource.getProjectRelativePath();
                IPath root = resource.getProject().getLocation().append(path.segment(0));
                IPath relativePath = path.removeFirstSegments(1);
                this.createEglIR(root, resource.getProject(), relativePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void createEglIR(final IPath root, final IProject project, final IPath relativePath) {
        final MultiStatus status = new MultiStatus("org.eclipse.edt.ide.generator.egl", 0, "completed", null);
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    List<String> classes = ClassFiles.getClassList(root.toOSString(), relativePath.toOSString());
                    monitor.beginTask("Creating EGL ir files", classes.size());
                    try {
                        URLClassLoader classLoader = new URLClassLoader(new URL[]{root.toFile().toURI().toURL()}, null);
                        ProjectIREnvironment env = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project).getIREnvironment();
                        for (String className : classes) {
                            monitor.worked(1);
                            monitor.setTaskName(String.valueOf(className) + ".ir");
                            try {
                                Java2EglAction.generateClass(className.replace(File.separatorChar, '.'), project, classLoader, (IEnvironment)env);
                            }
                            catch (Exception e) {
                                status.add((IStatus)new Status(4, "org.eclipse.edt.ide.generator.egl", "Error create egl file " + className, (Throwable)e));
                            }
                        }
                    }
                    catch (Exception e) {
                        status.add((IStatus)new Status(4, "org.eclipse.edt.ide.generator.egl", "Error creating Class loader to convert Java classes to EGL", (Throwable)e));
                    }
                }
            });
        }
        catch (InterruptedException ie) {
            Activator.log(ie);
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        if (!status.isOK() && this.fSite != null) {
            String title = "UINlsStrings.EGLFormatting";
            ErrorDialog dialog = new ErrorDialog(this.fSite.getShell(), title, null, (IStatus)status, 4);
            dialog.open();
        }
    }

    static void generateClass(String className, IProject project, ClassLoader loader, IEnvironment env) throws MalformedURLException, Exception {
        EclipseJava2EGL gen = new EclipseJava2EGL(loader);
        gen.generate(EclipseJava2EGL.buildArgs(project, className), new EglGenerator((AbstractGeneratorCommand)gen), env);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (IStructuredSelection)selection;
    }

    protected void writeFile(String fileData, IFolder root, IPath path) throws CoreException, UnsupportedEncodingException {
        EclipseUtilities.writeFileInEclipse((IContainer)root.getFolder(path.removeLastSegments(1)), (IPath)path.removeFirstSegments(path.segmentCount() - 1).addFileExtension("egl"), (InputStream)new ByteArrayInputStream(fileData.getBytes("UTF-8")), (boolean)true);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fSite = targetPart.getSite();
    }
}

