/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.ui.testresult;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.eunit.Activator;
import org.eclipse.edt.ide.eunit.ui.testresult.ConstantUtil;
import org.eclipse.edt.ide.eunit.ui.testresult.ResultSummaryBlock;
import org.eclipse.edt.ide.eunit.ui.testresult.TestResultPkgNodeDetailsPage;
import org.eclipse.edt.ide.eunit.ui.testresult.TestResultViewer;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RecordResultDetailsPage
extends TestResultPkgNodeDetailsPage {
    protected ResultSummaryBlock.Record_ResultSummary fResultSummary;

    public RecordResultDetailsPage(ResultSummaryBlock.Record_ResultSummary resultSummary) {
        super(null);
        this.fResultSummary = resultSummary;
    }

    @Override
    public void commit(boolean arg0) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isStale() {
        return false;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public boolean setFormInput(Object arg0) {
        return false;
    }

    @Override
    public void selectionChanged(IFormPart arg0, ISelection arg1) {
    }

    protected FormPage getContainerFormPage() {
        return (FormPage)this.mform.getContainer();
    }

    @Override
    protected void createControlsInTopSection(FormToolkit toolkit, Composite parent) {
        this.createSpacer(toolkit, parent, this.nColumnSpan);
        TestResultViewer formeditor = (TestResultViewer)this.getContainerFormPage().getEditor();
        IEditorInput editorInput = formeditor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            IFile file = fileInput.getFile();
            IPath parentFolder = file.getParent().getFullPath();
            String pkgFolder = this.fResultSummary.pkgName.replace(".", System.getProperty("file.separator"));
            IPath resultFilePath = parentFolder.append(pkgFolder).append(this.fResultSummary.name);
            resultFilePath = resultFilePath.addFileExtension("etr");
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile resultFile = wsRoot.getFile(resultFilePath);
            this.getDetailedResult(resultFile, toolkit, parent);
        }
    }

    protected void getDetailedResult(IFile resultFile, FormToolkit toolkit, Composite parent) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            resultFile.refreshLocal(1, null);
            Document dom = db.parse(resultFile.getContents(true));
            Element testResultRoot = dom.getDocumentElement();
            NodeList elem_tds = testResultRoot.getElementsByTagName("td");
            this.displayNode(toolkit, parent, elem_tds);
            this.createSpacer(toolkit, parent, this.nColumnSpan);
            NodeList elem_stats = testResultRoot.getElementsByTagName("stat");
            this.displayNode(toolkit, parent, elem_stats);
            this.createSpacer(toolkit, parent, this.nColumnSpan);
            NodeList elem_logs = testResultRoot.getElementsByTagName("log");
            this.displayNode(toolkit, parent, elem_logs);
            this.createSpacer(toolkit, parent, this.nColumnSpan);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void displayNode(FormToolkit toolkit, Composite parent, NodeList elems) {
        Element elem = elems.getLength() > 0 ? (Element)elems.item(0) : null;
        NodeList childrenNodes = elem.getChildNodes();
        int childrenCnt = childrenNodes.getLength();
        String pkgName = null;
        String fileName = null;
        int i = 0;
        while (i < childrenCnt) {
            Node childNode = childrenNodes.item(i);
            if (childNode.getNodeType() == 1) {
                String nodeName = childNode.getNodeName();
                String nodeTextContent = childNode.getTextContent();
                if (nodeName.equals("code")) {
                    nodeTextContent = String.valueOf(nodeTextContent) + " - " + ConstantUtil.STEXTS[Integer.parseInt(nodeTextContent)];
                }
                if (nodeName.equals("pkgName")) {
                    pkgName = nodeTextContent;
                }
                if (nodeName.equals("name")) {
                    fileName = nodeTextContent;
                }
                this.createReadOnlyNoBorderText(toolkit, parent, this.nColumnSpan, String.valueOf(nodeName) + ": " + nodeTextContent);
            }
            ++i;
        }
        if (pkgName != null && fileName != null) {
            String fqFileName = pkgName.length() > 0 ? String.valueOf(pkgName) + "." + fileName : fileName;
            this.createHyperLink(toolkit, parent, fqFileName);
        }
    }

    private void createHyperLink(FormToolkit toolkit, Composite parent, final String fullyQualifiedFileName) {
        ImageHyperlink interfaceLink = toolkit.createImageHyperlink(parent, 0);
        interfaceLink.setText(fullyQualifiedFileName);
        interfaceLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TestResultViewer formeditor = (TestResultViewer)RecordResultDetailsPage.this.getContainerFormPage().getEditor();
                RecordResultDetailsPage.try2OpenPartInEGLEditor(formeditor, fullyQualifiedFileName, "org.eclipse.edt.ide.ui.EGLEditor");
            }
        });
    }

    public static void try2OpenPartInEGLEditor(TestResultViewer formeditor, String fullyqualifiedPartName, String editorId) {
        IProject proj = formeditor.getProject();
        IEGLProject eglProj = EGLCore.create((IProject)proj);
        IFile file = org.eclipse.edt.ide.core.internal.utils.Util.findPartFile((String)fullyqualifiedPartName, (IEGLProject)eglProj);
        if (file != null && file.exists()) {
            if (Util.isEGLFileName((String)file.getName())) {
                RecordResultDetailsPage.openEGLFile(file, editorId);
            }
        } else {
            String errMsg = "Can not find " + fullyqualifiedPartName + ", it does not exist.";
            Status status = new Status(4, "org.eclipse.edt.ide.eunit", -1, errMsg, null);
            ErrorDialog.openError((Shell)formeditor.getSite().getShell(), null, null, (IStatus)status);
        }
    }

    public static void openEGLFile(final IFile file, final String editorId) {
        final IWorkbenchWindow ww = Activator.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ww.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

