/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.lang;

import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class DecimalTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(FixedPrecisionType type, Context ctx, TabbedWriter out) {
        this.processDefaultValue((Type)type, ctx, out);
    }

    public void genDefaultValue(ParameterizableType type, Context ctx, TabbedWriter out) {
        this.processDefaultValue((Type)type, ctx, out);
    }

    public void processDefaultValue(Type type, Context ctx, TabbedWriter out) {
        out.print("egl." + ctx.getNativeMapping("eglx.lang.EDecimal") + ".ZERO");
    }

    public void genSignature(FixedPrecisionType type, Context ctx, TabbedWriter out) {
        String signature = "d" + type.getLength() + ":" + type.getDecimals() + ";";
        out.print(signature);
    }

    public void genSignature(ParameterizableType type, Context ctx, TabbedWriter out) {
        String signature = "d;";
        out.print(signature);
    }

    public void genTypeDependentOptions(ParameterizableType type, Context ctx, TabbedWriter out, AsExpression arg) {
        out.print(", ");
        if (arg.getObjectExpr() instanceof IntegerLiteral) {
            String value = ((IntegerLiteral)arg.getObjectExpr()).getValue();
            if (value.startsWith("-")) {
                value = value.substring(1);
            }
            if (value.length() > 4) {
                out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
            } else {
                out.print("egl.javascript.BigDecimal.prototype.NINES[3]");
            }
        } else {
            out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
        }
    }

    public void genTypeDependentOptions(ParameterizableType type, Context ctx, TabbedWriter out) {
        out.print(", ");
        out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) {
        out.print(this.getNativeStringPrefixOperation(arg));
        out.print("(");
        ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringOperation(arg));
        ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringComparisionOperation(arg));
        out.print(")");
    }

    protected boolean needsConversion(Type fromType, Type toType) {
        boolean result = true;
        if (TypeUtils.isNumericType((Type)fromType) && !CommonUtilities.needsConversion((Type)fromType, (Type)toType)) {
            result = !CommonUtilities.isJavaScriptBigDecimal((Type)toType);
        }
        return result;
    }

    public void genConversionOperation(FixedPrecisionType type, Context ctx, TabbedWriter out, AsExpression arg) {
        Type toType = arg.getEType();
        Type fromType = arg.getObjectExpr().getType();
        if (arg.getConversionOperation() != null && TypeUtils.isNumericType((Type)fromType)) {
            if (this.needsConversion(fromType, toType) && CommonUtilities.proceedWithConversion((Context)ctx, (Operation)arg.getConversionOperation())) {
                out.print(String.valueOf(ctx.getNativeImplementationMapping(toType)) + '.');
                out.print("from");
                out.print(ctx.getNativeTypeName(fromType));
                out.print("(");
                Expression objectExpr = arg.getObjectExpr();
                if (objectExpr instanceof BoxingExpression) {
                    objectExpr = ((BoxingExpression)objectExpr).getExpr();
                }
                ctx.invoke("genExpression", (EObject)objectExpr, new Object[]{ctx, out});
                ctx.invoke("genTypeDependentOptions", arg.getEType(), new Object[]{ctx, out, arg});
                out.print(")");
            } else {
                ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
            }
        } else {
            ctx.invokeSuper((Template)this, "genConversionOperation", (Type)type, new Object[]{ctx, out, arg});
        }
    }

    protected boolean needsConversion(Operation conOp) {
        boolean result = true;
        Type fromType = ((FunctionParameter)conOp.getParameters().get(0)).getType();
        Type toType = conOp.getReturnType();
        if (CommonUtilities.getEglNameForTypeCamelCase((Type)toType).equals(CommonUtilities.getEglNameForTypeCamelCase((Type)fromType))) {
            result = false;
        }
        if (TypeUtils.isNumericType((Type)fromType) && (TypeUtils.Type_DECIMAL.equals(fromType).booleanValue() || TypeUtils.Type_MONEY.equals(fromType).booleanValue())) {
            result = conOp.isNarrowConversion();
        }
        return result;
    }

    public void genConversionOperation(EGLClass type, Context ctx, TabbedWriter out, AsExpression arg) {
        if (arg.getConversionOperation() != null && !this.needsConversion(arg.getConversionOperation())) {
            ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
        } else {
            ctx.invokeSuper((Template)this, "genConversionOperation", (Type)type, new Object[]{ctx, out, arg});
        }
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        expr.getOperator();
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return ".add(";
        }
        if (op.equals("-")) {
            return ".subtract(";
        }
        if (op.equals("*")) {
            return ".multiply(";
        }
        if (op.equals("/")) {
            return ".divide(";
        }
        if (op.equals("==")) {
            return ".compareTo(";
        }
        if (op.equals("!=")) {
            return ".compareTo(";
        }
        if (op.equals("<")) {
            return ".compareTo(";
        }
        if (op.equals(">")) {
            return ".compareTo(";
        }
        if (op.equals("<=")) {
            return ".compareTo(";
        }
        if (op.equals(">=")) {
            return ".compareTo(";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("%")) {
            return ".remainder(";
        }
        if (op.equals("**")) {
            return ".pow(";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return ")";
        }
        if (op.equals("-")) {
            return ")";
        }
        if (op.equals("*")) {
            return ")";
        }
        if (op.equals("/")) {
            return ")";
        }
        if (op.equals("==")) {
            return ") == 0";
        }
        if (op.equals("!=")) {
            return ") != 0";
        }
        if (op.equals("<")) {
            return ") < 0";
        }
        if (op.equals(">")) {
            return ") > 0";
        }
        if (op.equals("<=")) {
            return ") <= 0";
        }
        if (op.equals(">=")) {
            return ") >= 0";
        }
        if (op.equals("%")) {
            return ")";
        }
        if (op.equals("**")) {
            return ")";
        }
        return "";
    }
}

