/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.lang;

import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.IsAExpression;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class NumTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(FixedPrecisionType type, Context ctx, TabbedWriter out) {
        this.processDefaultValue((Type)type, ctx, out);
    }

    public void genDefaultValue(ParameterizableType type, Context ctx, TabbedWriter out) {
        this.processDefaultValue((Type)type, ctx, out);
    }

    public void processDefaultValue(Type type, Context ctx, TabbedWriter out) {
        out.print("egl.javascript.BigDecimal.prototype.ZERO");
    }

    public void genSignature(FixedPrecisionType type, Context ctx, TabbedWriter out) {
        String signature = "N" + type.getLength() + ":" + type.getDecimals() + ";";
        out.print(signature);
    }

    public void genSignature(ParameterizableType type, Context ctx, TabbedWriter out) {
        String signature = "N;";
        out.print(signature);
    }

    protected boolean needsConversion(Type fromType, Type toType) {
        boolean result = true;
        if (TypeUtils.isNumericType((Type)fromType) && !CommonUtilities.needsConversion((Type)fromType, (Type)toType)) {
            result = CommonUtilities.isJavaScriptBigDecimal((Type)toType);
        }
        return result;
    }

    public void genConversionOperation(FixedPrecisionType type, Context ctx, TabbedWriter out, AsExpression arg) {
        Type toType = arg.getEType();
        Type fromType = arg.getObjectExpr().getType();
        if (arg.getConversionOperation() == null && TypeUtils.isNumericType((Type)fromType)) {
            if (this.needsConversion(fromType, toType)) {
                out.print(String.valueOf(ctx.getNativeImplementationMapping(toType)) + '.');
                out.print("from");
                out.print(ctx.getNativeTypeName(fromType));
                out.print("(");
                Expression objectExpr = arg.getObjectExpr();
                if (objectExpr instanceof BoxingExpression) {
                    objectExpr = ((BoxingExpression)objectExpr).getExpr();
                }
                ctx.invoke("genExpression", (EObject)objectExpr, new Object[]{ctx, out});
                ctx.invoke("genTypeDependentOptions", arg.getEType(), new Object[]{ctx, out, arg});
                out.print(")");
            } else {
                ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
            }
        } else {
            ctx.invokeSuper((Template)this, "genConversionOperation", (Type)type, new Object[]{ctx, out, arg});
        }
    }

    public void genTypeDependentOptions(ParameterizableType type, Context ctx, TabbedWriter out, AsExpression arg) {
        out.print(", ");
        if (arg.getObjectExpr() instanceof IntegerLiteral) {
            String value = ((IntegerLiteral)arg.getObjectExpr()).getValue();
            if (value.startsWith("-")) {
                value = value.substring(1);
            }
            if (value.length() > 4) {
                out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
            } else {
                out.print("egl.javascript.BigDecimal.prototype.NINES[3]");
            }
        } else {
            out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
        }
    }

    public void genTypeDependentOptions(ParameterizableType type, Context ctx, TabbedWriter out) {
        out.print(", ");
        out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) {
        out.print(this.getNativeStringPrefixOperation(arg));
        out.print("(");
        ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringOperation(arg));
        ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringComparisionOperation(arg));
        out.print(")");
    }

    public void genIsaExpression(Type type, Context ctx, TabbedWriter out, IsAExpression arg) {
        if ("eglx.lang.ENumber".equals(type.getTypeSignature())) {
            out.print("egl.is(");
            ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
            out.print(", \"NUMERIC\",egl.isnumeric)");
        } else {
            ctx.invokeSuper((Template)this, "genIsaExpression", type, new Object[]{ctx, out, arg});
        }
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "!";
        }
        if (op.equals("%")) {
            return "egl.remainder";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("-")) {
            return " - ";
        }
        if (op.equals("*")) {
            return " * ";
        }
        if (op.equals("/")) {
            return " / ";
        }
        if (op.equals("==")) {
            return ".compareTo(";
        }
        if (op.equals("!=")) {
            return ".compareTo(";
        }
        if (op.equals("<")) {
            return ".compareTo(";
        }
        if (op.equals(">")) {
            return ".compareTo(";
        }
        if (op.equals("<=")) {
            return ".compareTo(";
        }
        if (op.equals(">=")) {
            return ".compareTo(";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("%")) {
            return ",";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return ") == 0";
        }
        if (op.equals("!=")) {
            return ")";
        }
        if (op.equals("<")) {
            return ") < 0";
        }
        if (op.equals(">")) {
            return ") > 0";
        }
        if (op.equals("<=")) {
            return ") <= 0";
        }
        if (op.equals(">=")) {
            return ") >= 0";
        }
        return "";
    }
}

