/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.internal.actions;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.deployment.Activator;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.internal.actions.DeployJob;
import org.eclipse.edt.ide.deployment.internal.nls.Messages;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;
import org.eclipse.edt.ide.deployment.utilities.IDEDeploymentDescFileLocator;
import org.eclipse.edt.ide.ui.internal.dialogs.SaveDirtyEditorsDialog;
import org.eclipse.edt.ide.ui.internal.editor.ListContentProvide;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;

public class DeployAction
implements IObjectActionDelegate {
    private Shell shell;
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        final ArrayList result = new ArrayList();
        IResource resource = null;
        if (this.selection instanceof IStructuredSelection && ((IStructuredSelection)this.selection).size() == 1) {
            resource = this.processSelection((IStructuredSelection)this.selection);
            try {
                if (resource instanceof IFile) {
                    this.processFile((IFile)resource, result);
                } else if (resource instanceof IFolder) {
                    this.processFolder((IFolder)resource, result);
                } else if (resource instanceof IProject) {
                    this.processProject((IProject)resource, result);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().log("Error processing selected resource: " + resource.getName(), (Exception)((Object)e));
            }
        }
        if (result.size() >= 1) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                ps.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        int dirtySize;
                        final HashSet<IEditorPart> dirtyEditors = new HashSet<IEditorPart>();
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        if (windows != null && windows.length != 0) {
                            int i = 0;
                            while (i < windows.length) {
                                IWorkbenchPage[] pages = windows[i].getPages();
                                if (pages != null && pages.length != 0) {
                                    int j = 0;
                                    while (j < pages.length) {
                                        final IWorkbenchPage page = pages[j];
                                        final IEditorPart[][] editors = new IEditorPart[1][];
                                        DeploymentUtilities.getDisplay().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                editors[0] = page.getDirtyEditors();
                                            }
                                        });
                                        int k = 0;
                                        while (k < editors[0].length) {
                                            FileEditorInput fileInput;
                                            IEditorInput input = editors[0][k].getEditorInput();
                                            if (input instanceof FileEditorInput && result.contains((fileInput = (FileEditorInput)input).getFile())) {
                                                dirtyEditors.add(editors[0][k]);
                                            }
                                            ++k;
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                        if ((dirtySize = dirtyEditors.size()) != 0) {
                            DeploymentUtilities.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = DeploymentUtilities.getShell();
                                    SaveDirtyEditorsDialog dialog = new SaveDirtyEditorsDialog(shell){

                                        protected void createButtonsForButtonBar(Composite parent) {
                                            this.createButton(parent, 0, Messages.deployment_save_prompt_ok_button_label, true);
                                            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                                        }
                                    };
                                    dialog.setTitle(Messages.deployment_save_prompt_title);
                                    dialog.setMessage(Messages.deployment_save_prompt_msg);
                                    dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                                        public Image getImage(Object element) {
                                            return ((IEditorPart)element).getTitleImage();
                                        }

                                        public String getText(Object element) {
                                            return ((IEditorPart)element).getTitle();
                                        }
                                    });
                                    dialog.setContentProvider((IStructuredContentProvider)new ListContentProvide());
                                    dialog.setSorter(new ViewerSorter());
                                    dialog.setInput(new ArrayList(dirtyEditors));
                                    if (dialog.open() == 0) {
                                        NullProgressMonitor monitor = new NullProgressMonitor();
                                        Iterator it = dirtyEditors.iterator();
                                        while (it.hasNext()) {
                                            ((IEditorPart)it.next()).doSave((IProgressMonitor)monitor);
                                        }
                                    } else {
                                        result.clear();
                                    }
                                }
                            });
                        }
                        if (result.size() > 0) {
                            monitor.beginTask(Messages.deploy_operation_task_name, -1);
                            ArrayList<DeploymentContext> deploymentModels = new ArrayList<DeploymentContext>();
                            for (IFile ddFile : result) {
                                try {
                                    monitor.subTask(Messages.process_deployment_descriptor);
                                    String ddName = ddFile.getName();
                                    ddName = ddName.substring(0, ddName.indexOf(ddFile.getFileExtension()) - 1);
                                    DeploymentDesc model = DeploymentDesc.createDeploymentDescriptor((String)ddName, (InputStream)ddFile.getContents());
                                    if (model == null) continue;
                                    new IDEDeploymentDescFileLocator();
                                    DeploymentContext context = new DeploymentContext(model);
                                    context.setSourceProject(ddFile.getProject());
                                    context.init();
                                    deploymentModels.add(context);
                                }
                                catch (Exception e) {
                                    Activator.getDefault().log("Error creating deployment model for file: " + ddFile.getName(), e);
                                }
                            }
                            monitor.done();
                            if (deploymentModels.size() > 0) {
                                DeploymentContext[] models = deploymentModels.toArray(new DeploymentContext[deploymentModels.size()]);
                                DeployJob deployJob = new DeployJob();
                                deployJob.setModels(models);
                                deployJob.schedule();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                Activator.getDefault().log("Error building deployment descriptor model.", e);
            }
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.deployment_action_information_msg_title, (String)Messages.bind((String)Messages.deployment_action_no_dd_files_found, (Object[])new String[]{resource.getFullPath().makeRelative().toOSString()}));
        }
    }

    private boolean sendToDeployment(DeploymentDesc deploymentDesc) {
        return deploymentDesc.getDeploymentTarget() != null && (deploymentDesc.getRUIApplication() != null || deploymentDesc.getRestservices() != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    private IResource processSelection(IStructuredSelection selection) {
        IResource result = null;
        Object nextSelection = selection.getFirstElement();
        if (nextSelection instanceof IFile || nextSelection instanceof IFolder || nextSelection instanceof IProject) {
            result = (IResource)nextSelection;
        }
        return result;
    }

    private void processProject(IProject project, List files) throws CoreException {
        IEGLProject eglProject = EGLCore.create((IProject)project);
        if (eglProject.exists() && ((IProject)eglProject.getResource()).isOpen()) {
            IPackageFragmentRoot[] packageFragmentRoots = eglProject.getPackageFragmentRoots();
            int i = 0;
            while (i < packageFragmentRoots.length) {
                if (packageFragmentRoots[i].getResource() instanceof IContainer) {
                    IContainer root = (IContainer)packageFragmentRoots[i].getResource();
                    IResource[] members = root.members();
                    int j = 0;
                    while (j < members.length) {
                        IResource resource = members[j];
                        this.processResource(resource, files);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void processResource(IResource resource, List files) throws CoreException {
        if (resource.getType() == 2) {
            this.processFolder((IFolder)resource, files);
        } else if (resource.getType() == 1) {
            this.processFile((IFile)resource, files);
        }
    }

    private void processFile(IFile file, List files) {
        if (file.exists() && "egldd".equalsIgnoreCase(file.getFileExtension())) {
            files.add(file);
        }
    }

    private void processFolder(IFolder folder, List files) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            this.processResource(resources[i], files);
            ++i;
        }
    }
}

