/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.deployment.Activator;
import org.eclipse.edt.ide.deployment.internal.registry.ContributionsRegistry;
import org.eclipse.edt.ide.deployment.results.DeploymentResultsCollectorManager;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.solution.IDeploymentSolution;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;

public class DeployOperation {
    public void deploy(DeploymentContext[] models, IProgressMonitor pm) throws Exception {
        int i = 0;
        while (i < models.length) {
            DeploymentContext deploymentContext = models[i];
            try {
                ContributionsRegistry registry = ContributionsRegistry.singleton;
                IConfigurationElement contribution = registry.getContributionForId(DeploymentUtilities.getDeploymentTargetType(deploymentContext.getDeploymentDesc().getDeploymentTarget()));
                if (contribution != null) {
                    IDeploymentSolution deploymentSolution = registry.getDeploymentSolution(contribution);
                    deploymentSolution.setContext(deploymentContext);
                    try {
                        String targetProjectName = DeploymentUtilities.getDeploymentTargetId(deploymentContext.getDeploymentDesc().getDeploymentTarget(), null, deploymentContext.getDeploymentDesc().getName());
                        IDeploymentResultsCollector resultsCollector = DeploymentResultsCollectorManager.getInstance().getCollector(targetProjectName, deploymentContext.getDeploymentDesc().getName(), false, false);
                        deploymentSolution.execute(resultsCollector, pm);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().log("Error processing EGL Deployment Models", (Exception)((Object)e));
                    }
                }
            }
            finally {
                DeploymentUtilities.finalize(DeploymentResultsCollectorManager.getInstance().getCollector(DeploymentUtilities.getDeploymentTargetId(models[i].getDeploymentDesc().getDeploymentTarget(), null, models[i].getDeploymentDesc().getName()), models[i].getDeploymentDesc().getName(), false, false), true, models[i].getDeploymentDesc().getName());
            }
            ++i;
        }
    }
}

