/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.internal.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.common.ResAuthTypeBase;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.common.internal.impl.CommonFactoryImpl;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.EmptyType;
import org.eclipse.jst.javaee.core.EnvEntryType;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ResAuthType;
import org.eclipse.jst.javaee.core.ResSharingScopeType;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;

public class WebXML {
    private IProject project;
    private Map environmentEntries;
    private Map servlets;
    private Map filters;
    private Map resourceRefs;
    private Boolean isDistributable;

    public WebXML(IProject project) {
        this.project = project;
        this.environmentEntries = new HashMap();
        this.servlets = new HashMap();
        this.filters = new HashMap();
        this.resourceRefs = new HashMap();
    }

    public void addServlet(String servletName, String displayName, String servletClassName, Set<String> urls, Map paramList, int loadOnStartUp) {
        this.servlets.put(servletName, new Servlet(servletName, displayName, servletClassName, urls, paramList, loadOnStartUp));
    }

    public void addServlet(String servletName, String servletClassName, String url, Map paramList) {
        this.servlets.put(servletName, new Servlet(servletName, servletClassName, url, paramList));
    }

    public void addFilter(String filterName, String filterClassName, List urlPatterns, Map paramList) {
        this.filters.put(filterName, new Filter(filterName, filterClassName, urlPatterns, paramList));
    }

    public void addResourceRef(ResourceRef ref) {
        this.resourceRefs.put(ref.getName(), ref);
    }

    public void isDistributable(boolean isDistributable) {
        this.isDistributable = new Boolean(isDistributable);
    }

    public void addEnvironmentEntries(ArrayList envEntries) {
        for (EnvEntry entry : envEntries) {
            this.environmentEntries.put(entry.getName(), entry);
        }
    }

    void updateModel() {
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.project);
        if (provider != null) {
            provider.modify(new Runnable(){

                @Override
                public void run() {
                    Object object = provider.getModelObject();
                    EglWebApp webApp = null;
                    if (object instanceof WebApp) {
                        webApp = new JavaeeWebApp((WebApp)object);
                    } else if (object instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                        webApp = new J2eeWebApp((org.eclipse.jst.j2ee.webapplication.WebApp)object);
                    }
                    if (webApp != null) {
                        for (Servlet servlet : WebXML.this.servlets.values()) {
                            webApp.registerServlet(servlet.servletName, servlet.displayName, servlet.servletClassName, servlet.urls, servlet.paramList, servlet.loadOnStartUp);
                        }
                        for (Filter filter : WebXML.this.filters.values()) {
                            webApp.registerFilter(filter.filterName, filter.filterClassName, filter.paramList, filter.urlPatterns);
                        }
                        for (ResourceRef resourceRef : WebXML.this.resourceRefs.values()) {
                            webApp.addResourceRef(resourceRef);
                        }
                        for (EnvEntry envEntry : WebXML.this.environmentEntries.values()) {
                            webApp.updateAddEnvironmentEntry(envEntry);
                        }
                        if (WebXML.this.isDistributable != null) {
                            webApp.updateDistributable();
                        }
                    }
                }
            }, null);
        }
    }

    private static interface EglWebApp {
        public void registerServlet(String var1, String var2, String var3, Set<String> var4, Map<String, String> var5, int var6);

        public void registerFilter(String var1, String var2, Map var3, List var4);

        public void addResourceRef(ResourceRef var1);

        public void updateAddEnvironmentEntry(EnvEntry var1);

        public void updateDistributable();
    }

    private class Filter {
        private String filterName;
        private String filterClassName;
        private List urlPatterns;
        private Map paramList;

        public Filter(String filterName, String filterClassName, List urlPatterns, Map paramList) {
            this.filterName = filterName;
            this.filterClassName = filterClassName;
            this.urlPatterns = urlPatterns;
            this.paramList = paramList;
        }
    }

    private class J2eeWebApp
    implements EglWebApp {
        org.eclipse.jst.j2ee.webapplication.WebApp webApp;

        public J2eeWebApp(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
            this.webApp = webApp;
        }

        @Override
        public void updateDistributable() {
            if (this.webApp.isDistributable() != WebXML.this.isDistributable.booleanValue()) {
                this.webApp.setDistributable(WebXML.this.isDistributable.booleanValue());
            }
        }

        @Override
        public void addResourceRef(ResourceRef resourceRef) {
            EList resourceRefs = this.webApp.getResourceRefs();
            boolean found = false;
            for (ResourceRef ref : resourceRefs) {
                if (!ref.getName().equals(resourceRef.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                ResourceRef ref = CommonFactory.eINSTANCE.createResourceRef();
                ref.setName(resourceRef.getName());
                ref.setType(resourceRef.getType());
                ref.setResSharingScope(resourceRef.getResSharingScope());
                ref.setAuth(resourceRef.getAuth());
                resourceRefs.add((Object)ref);
            }
        }

        @Override
        public void updateAddEnvironmentEntry(EnvEntry newEnvEntry) {
            boolean found = false;
            for (EnvEntry existingEntry : this.webApp.getEnvironmentProperties()) {
                if (!existingEntry.getName().equals(newEnvEntry.getName())) continue;
                if (!(existingEntry.getName().equalsIgnoreCase("vgj.trace.type") || existingEntry.getName().equalsIgnoreCase("vgj.trace.device.option") || existingEntry.getName().equalsIgnoreCase("vgj.trace.device.spec"))) {
                    existingEntry.setValue(newEnvEntry.getValue());
                    existingEntry.setType(newEnvEntry.getType());
                }
                found = true;
            }
            if (!found) {
                this.webApp.getEnvironmentProperties().add((Object)newEnvEntry);
            }
        }

        @Override
        public void registerServlet(String servletName, String displayName, String servletClassName, Set<String> urlMappings, Map<String, String> paramList, int loadOnStartUp) {
            org.eclipse.jst.j2ee.webapplication.Servlet servlet = this.getJ2eeServlet(servletName, displayName, servletClassName, loadOnStartUp);
            EList initParams = servlet.getInitParams();
            initParams.clear();
            Iterator<String> iter = paramList.keySet().iterator();
            while (iter.hasNext()) {
                ParamValue initParam = CommonFactory.eINSTANCE.createParamValue();
                String key = iter.next();
                initParam.setName(key);
                initParam.setValue(paramList.get(key));
                initParams.add(initParam);
            }
            EList mappings = this.webApp.getServletMappings();
            if (mappings != null && !mappings.isEmpty()) {
                ArrayList<org.eclipse.jst.j2ee.webapplication.ServletMapping> removalList = new ArrayList<org.eclipse.jst.j2ee.webapplication.ServletMapping>();
                for (org.eclipse.jst.j2ee.webapplication.ServletMapping map : mappings) {
                    if (!map.getServlet().getServletName().equals(servlet.getServletName())) continue;
                    removalList.add(map);
                }
                if (!removalList.isEmpty()) {
                    mappings.removeAll(removalList);
                }
            }
            Iterator<String> itr = urlMappings.iterator();
            while (itr.hasNext()) {
                org.eclipse.jst.j2ee.webapplication.ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
                mapping.setServlet(servlet);
                mapping.setWebApp(this.webApp);
                mapping.setUrlPattern(itr.next());
                mappings.add(mapping);
            }
        }

        private org.eclipse.jst.j2ee.webapplication.Servlet getJ2eeServlet(String servletName, String displayName, String servletClassName, int loadOnStartUp) {
            org.eclipse.jst.j2ee.webapplication.Servlet servlet = this.webApp.getServletNamed(servletName);
            if (servlet == null && servletClassName != null) {
                EList servlets = this.webApp.getServlets();
                servlet = WebapplicationFactory.eINSTANCE.createServlet();
                servlets.add(servlet);
                servlet.setWebApp(this.webApp);
                servlet.setServletName(servletName);
                ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
                servletType.setClassName(servletClassName);
                servlet.setWebType((WebType)servletType);
                servlet.setLoadOnStartup(new Integer(loadOnStartUp));
                servlet.setDisplayName(displayName);
            }
            return servlet;
        }

        @Override
        public void registerFilter(String filterName, String filterClassName, Map paramList, List urlPatternList) {
            org.eclipse.jst.j2ee.webapplication.Filter filter = this.getJ2eeFilter(filterName, filterClassName);
            EList initParams = filter.getInitParamValues();
            initParams.clear();
            Iterator iter = paramList.keySet().iterator();
            while (iter.hasNext()) {
                ParamValue initParam = CommonFactoryImpl.eINSTANCE.createParamValue();
                Object key = iter.next();
                initParam.setName((String)key);
                initParam.setValue((String)paramList.get(key));
                initParams.add(initParam);
            }
            EList mappings = this.webApp.getFilterMappings();
            if (mappings != null && !mappings.isEmpty()) {
                ArrayList<FilterMapping> removalList = new ArrayList<FilterMapping>();
                for (FilterMapping map : mappings) {
                    if (!map.getFilter().getName().equals(filter.getName())) continue;
                    removalList.add(map);
                }
                if (!removalList.isEmpty()) {
                    mappings.removeAll(removalList);
                }
            }
            Iterator iter2 = urlPatternList.iterator();
            while (iter2.hasNext()) {
                FilterMapping mapping = WebapplicationFactory.eINSTANCE.createFilterMapping();
                mapping.setFilter(filter);
                String urlPattern = (String)iter2.next();
                mapping.setUrlPattern(urlPattern);
                mappings.add(mapping);
            }
        }

        private org.eclipse.jst.j2ee.webapplication.Filter getJ2eeFilter(String filterName, String filterClassName) {
            org.eclipse.jst.j2ee.webapplication.Filter filter = this.webApp.getFilterNamed(filterName);
            if (filter == null && filterClassName != null) {
                EList filters = this.webApp.getFilters();
                filter = WebapplicationFactory.eINSTANCE.createFilter();
                filters.add(filter);
                filter.setName(filterName);
                filter.setDisplayName(filterName);
                filter.setFilterClassName(filterClassName);
            }
            return filter;
        }
    }

    private class JavaeeWebApp
    implements EglWebApp {
        WebApp webApp;

        public JavaeeWebApp(WebApp webApp) {
            this.webApp = webApp;
        }

        @Override
        public void updateDistributable() {
            boolean appIsDistributable;
            List distributables = this.webApp.getDistributables();
            boolean bl = appIsDistributable = !distributables.isEmpty();
            if (appIsDistributable != WebXML.this.isDistributable) {
                if (!distributables.isEmpty()) {
                    ArrayList list = new ArrayList();
                    list.addAll(distributables);
                    this.webApp.getDistributables().removeAll(list);
                    this.webApp.getDistributables().clear();
                } else {
                    ArrayList<EmptyType> list = new ArrayList<EmptyType>();
                    EmptyType emptyType = JavaeeFactory.eINSTANCE.createEmptyType();
                    list.add(emptyType);
                    this.webApp.getDistributables().addAll(list);
                }
            }
        }

        @Override
        public void addResourceRef(ResourceRef resourceRef) {
            List resourceRefs = this.webApp.getResourceRefs();
            boolean found = false;
            for (org.eclipse.jst.javaee.core.ResourceRef ref : resourceRefs) {
                if (!resourceRef.getName().equals(ref.getResRefName())) continue;
                found = true;
                break;
            }
            if (!found) {
                org.eclipse.jst.javaee.core.ResourceRef ref = JavaeeFactory.eINSTANCE.createResourceRef();
                ref.setResRefName(resourceRef.getName());
                if (resourceRef.getResSharingScope() == org.eclipse.jst.j2ee.common.ResSharingScopeType.SHAREABLE_LITERAL) {
                    ref.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
                } else if (resourceRef.getResSharingScope() == org.eclipse.jst.j2ee.common.ResSharingScopeType.UNSHAREABLE_LITERAL) {
                    ref.setResSharingScope(ResSharingScopeType.UNSHAREABLE_LITERAL);
                }
                if (resourceRef.getAuth() == ResAuthTypeBase.CONTAINER_LITERAL) {
                    ref.setResAuth(ResAuthType.CONTAINER_LITERAL);
                } else if (resourceRef.getAuth() == ResAuthTypeBase.APPLICATION_LITERAL) {
                    ref.setResAuth(ResAuthType.APPLICATION_LITERAL);
                }
                ref.setResType(resourceRef.getType());
                resourceRefs.add(ref);
            }
        }

        @Override
        public void updateAddEnvironmentEntry(EnvEntry newEnvEntry) {
            boolean found = false;
            for (org.eclipse.jst.javaee.core.EnvEntry existingEntry : this.webApp.getEnvEntries()) {
                if (!existingEntry.getEnvEntryName().equals(newEnvEntry.getName())) continue;
                if (!(existingEntry.getEnvEntryName().equalsIgnoreCase("vgj.trace.type") || existingEntry.getEnvEntryName().equalsIgnoreCase("vgj.trace.device.option") || existingEntry.getEnvEntryName().equalsIgnoreCase("vgj.trace.device.spec"))) {
                    existingEntry.setEnvEntryValue(newEnvEntry.getValue());
                    existingEntry.setEnvEntryType(this.convert(newEnvEntry.getType()));
                }
                found = true;
            }
            if (!found) {
                org.eclipse.jst.javaee.core.EnvEntry entry = JavaeeFactory.eINSTANCE.createEnvEntry();
                entry.setEnvEntryName(newEnvEntry.getName());
                entry.setEnvEntryType(this.convert(newEnvEntry.getType()));
                entry.setEnvEntryValue(newEnvEntry.getValue());
                this.webApp.getEnvEntries().add(entry);
            }
        }

        private EnvEntryType convert(org.eclipse.jst.j2ee.common.EnvEntryType type) {
            switch (type.getValue()) {
                case 2: {
                    return EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL;
                }
                case 4: {
                    return EnvEntryType.JAVA_LANG_BYTE_LITERAL;
                }
                case 8: {
                    return EnvEntryType.JAVA_LANG_CHARACTER_LITERAL;
                }
                case 3: {
                    return EnvEntryType.JAVA_LANG_DOUBLE_LITERAL;
                }
                case 7: {
                    return EnvEntryType.JAVA_LANG_FLOAT_LITERAL;
                }
                case 1: {
                    return EnvEntryType.JAVA_LANG_INTEGER_LITERAL;
                }
                case 6: {
                    return EnvEntryType.JAVA_LANG_LONG_LITERAL;
                }
                case 5: {
                    return EnvEntryType.JAVA_LANG_SHORT_LITERAL;
                }
                case 0: {
                    return EnvEntryType.JAVA_LANG_STRING_LITERAL;
                }
            }
            return EnvEntryType.JAVA_LANG_STRING_LITERAL;
        }

        @Override
        public void registerServlet(String servletName, String displayName, String servletClassName, Set<String> urlMappings, Map<String, String> paramList, int loadOnStartUp) {
            org.eclipse.jst.javaee.web.Servlet servlet = this.getJavaeeServlet(servletName, displayName, servletClassName, loadOnStartUp);
            List initParams = servlet.getInitParams();
            initParams.clear();
            Iterator<String> iter = paramList.keySet().iterator();
            while (iter.hasNext()) {
                org.eclipse.jst.javaee.core.ParamValue initParam = JavaeeFactory.eINSTANCE.createParamValue();
                String key = iter.next();
                initParam.setParamName(key);
                initParam.setParamValue(paramList.get(key));
                initParams.add(initParam);
            }
            ServletMapping mapping = null;
            List mappings = this.webApp.getServletMappings();
            if (mappings != null && !mappings.isEmpty()) {
                for (ServletMapping map : mappings) {
                    if (!map.getServletName().equals(servlet.getServletName())) continue;
                    mapping = map;
                    break;
                }
            }
            if (mapping == null) {
                mapping = WebFactory.eINSTANCE.createServletMapping();
                mapping.setServletName(servletName);
                mappings.add(mapping);
            }
            List urls = mapping.getUrlPatterns();
            urls.clear();
            Iterator<String> itr = urlMappings.iterator();
            while (itr.hasNext()) {
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(itr.next());
                urls.add(urlPattern);
            }
        }

        private org.eclipse.jst.javaee.web.Servlet getJavaeeServlet(String servletName, String displayName, String servletClassName, int loadOnStartUp) {
            org.eclipse.jst.javaee.web.Servlet tempServlet2;
            List servlets = this.webApp.getServlets();
            for (org.eclipse.jst.javaee.web.Servlet tempServlet2 : servlets) {
                if (!servletName.equalsIgnoreCase(tempServlet2.getServletName())) continue;
                return tempServlet2;
            }
            tempServlet2 = null;
            if (servletClassName != null && servletClassName.length() > 0) {
                tempServlet2 = WebFactory.eINSTANCE.createServlet();
                tempServlet2.setLoadOnStartup((Object)new Integer(loadOnStartUp));
                tempServlet2.setServletName(servletName);
                tempServlet2.setServletClass(servletClassName);
                DisplayName dName = JavaeeFactory.eINSTANCE.createDisplayName();
                dName.setValue(displayName);
                tempServlet2.getDisplayNames().add(dName);
                servlets.add(tempServlet2);
            }
            return tempServlet2;
        }

        @Override
        public void registerFilter(String filterName, String filterClassName, Map paramList, List urlPatternList) {
            org.eclipse.jst.javaee.web.Filter filter = this.getJavaeeFilter(filterName, filterClassName);
            List initParams = filter.getInitParams();
            initParams.clear();
            Iterator iter = paramList.keySet().iterator();
            while (iter.hasNext()) {
                org.eclipse.jst.javaee.core.ParamValue initParam = JavaeeFactory.eINSTANCE.createParamValue();
                Object key = iter.next();
                initParam.setParamName((String)key);
                initParam.setParamValue((String)paramList.get(key));
                initParams.add(initParam);
            }
            org.eclipse.jst.javaee.web.FilterMapping mapping = null;
            List mappings = this.webApp.getFilterMappings();
            if (mappings != null && !mappings.isEmpty()) {
                for (org.eclipse.jst.javaee.web.FilterMapping map : mappings) {
                    if (!map.getFilterName().equals(filter.getFilterName())) continue;
                    mapping = map;
                    break;
                }
            }
            if (mapping == null) {
                mapping = WebFactory.eINSTANCE.createFilterMapping();
                mapping.setFilterName(filterName);
                mappings.add(mapping);
            }
            List urls = mapping.getUrlPatterns();
            urls.clear();
            for (String pattern : urlPatternList) {
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(pattern);
                urls.add(urlPattern);
            }
        }

        private org.eclipse.jst.javaee.web.Filter getJavaeeFilter(String filterName, String filterClassName) {
            org.eclipse.jst.javaee.web.Filter tempFilter2;
            List filters = this.webApp.getFilters();
            for (org.eclipse.jst.javaee.web.Filter tempFilter2 : filters) {
                if (!filterName.equalsIgnoreCase(tempFilter2.getFilterName())) continue;
                return tempFilter2;
            }
            tempFilter2 = null;
            if (filterClassName != null && filterClassName.length() > 0) {
                tempFilter2 = WebFactory.eINSTANCE.createFilter();
                tempFilter2.setFilterName(filterName);
                tempFilter2.setFilterClass(filterClassName);
                filters.add(tempFilter2);
            }
            return tempFilter2;
        }
    }

    private class Servlet {
        private String servletName;
        private int loadOnStartUp;
        private String servletClassName;
        private String displayName;
        private Set<String> urls;
        private Map paramList;

        public Servlet(String servletName, String servletClassName, String url, Map paramList) {
            this(servletName, servletName, servletClassName, new HashSet<String>(), paramList, -1);
            this.urls.add(url);
        }

        public Servlet(String servletName, String displayName, String servletClassName, Set<String> urls, Map paramList, int loadOnStartUp) {
            this.servletName = servletName;
            this.displayName = displayName;
            this.servletClassName = servletClassName;
            this.urls = urls;
            this.paramList = paramList;
            this.loadOnStartUp = loadOnStartUp;
        }
    }
}

