/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.results;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.deployment.Activator;
import org.eclipse.edt.ide.deployment.results.DeploymentResultsCollectorManager;
import org.eclipse.edt.ide.deployment.results.EGLDeployResultsView;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DeploymentResultsCollector
implements IDeploymentResultsCollector {
    public static final String EGL_DEPLOY_RESULTS_VIEW = "org.eclipse.edt.ide.deployment.results.EGLDeployResultsView";
    String name;
    boolean hasError;
    boolean hasWarning;
    EGLDeployResultsView viewer;
    boolean done;

    public DeploymentResultsCollector(String name, EGLDeployResultsView viewer) {
        this.name = name;
        this.viewer = viewer;
    }

    @Override
    public void addMessage(final IStatus status) {
        if (status.getSeverity() > 2) {
            this.hasError = true;
        } else if (status.getSeverity() > 1) {
            this.hasWarning = true;
        }
        final DeploymentResultsCollector me = this;
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    EGLDeployResultsView view = DeploymentResultsCollector.this.getView();
                    if (view != null) {
                        view.resultsUpdate(me, status);
                    }
                }
            });
        }
    }

    private EGLDeployResultsView getView() {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage page;
        if (this.viewer == null && PlatformUI.isWorkbenchRunning() && (page = (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
            try {
                this.viewer = (EGLDeployResultsView)page.showView(EGL_DEPLOY_RESULTS_VIEW, null, 3);
            }
            catch (PartInitException e) {
                Activator.getDefault().log("Error loading deploy results view", (Exception)((Object)e));
            }
        }
        return this.viewer;
    }

    @Override
    public void done() {
        this.done = true;
        DeploymentResultsCollectorManager.getInstance().remove(this);
        if (PlatformUI.isWorkbenchRunning()) {
            final DeploymentResultsCollector me = this;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    EGLDeployResultsView view = DeploymentResultsCollector.this.getView();
                    if (view != null) {
                        view.done(me);
                    }
                }
            });
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public boolean hasWarning() {
        return this.hasWarning;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

