/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.solution;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.deployment.internal.nls.Messages;
import org.eclipse.edt.ide.deployment.operation.IDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.DeploymentResultsCollectorManager;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.solution.IDeploymentSolution;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;

public class AbstractDeploymentSolution
implements IDeploymentSolution {
    protected DeploymentContext context;
    private List<IDeploymentOperation> operations = new ArrayList<IDeploymentOperation>();

    @Override
    public void addOperation(IDeploymentOperation operation) {
        this.operations.add(operation);
    }

    @Override
    public void execute(IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        IDeploymentOperation operation;
        int i = 0;
        while (i < this.operations.size()) {
            operation = this.operations.get(i);
            operation.preCheck(this.context, resultsCollector, monitor);
            ++i;
        }
        if (this.context.getStatus() == 2) {
            return;
        }
        if (this.context.getStatus() != 1) {
            this.context.showMessage(Messages.deployment_action_no_parts_found);
            DeploymentResultsCollectorManager.getInstance().getCollector(DeploymentUtilities.getDeploymentTargetId(this.context.getDeploymentDesc().getDeploymentTarget(), null, this.context.getDeploymentDesc().getName()), this.context.getDeploymentDesc().getName(), false, false).addMessage(DeploymentUtilities.createDeployMessage(2, Messages.bind((String)Messages.deployment_no_parts_found, (Object)this.context.getDeploymentDesc().getName())));
            return;
        }
        i = 0;
        while (i < this.operations.size()) {
            operation = this.operations.get(i);
            operation.execute(this.context, resultsCollector, monitor);
            ++i;
        }
    }

    @Override
    public void setContext(DeploymentContext context) {
        this.context = context;
    }
}

