/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.impl;

import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlAddStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.impl.SqlIOStatementImpl;
import org.eclipse.edt.mof.eglx.persistence.sql.utils.SQL;

public class SqlAddStatementImpl
extends SqlIOStatementImpl
implements SqlAddStatement {
    @Override
    public String getSqlString() {
        String sql = super.getSqlString();
        if (sql == null || "".equals(sql)) {
            sql = this.generateDefaultSqlString();
            this.setSqlString(sql);
        }
        return sql;
    }

    private String generateDefaultSqlString() {
        String sql = null;
        Expression target = (Expression)this.getTargets().get(0);
        boolean targetIsList = target.getType() instanceof ArrayType;
        EGLClass targetType = targetIsList ? (EGLClass)((ArrayType)target.getType()).getElementType().getClassifier() : (EGLClass)target.getType().getClassifier();
        sql = "INSERT INTO ";
        sql = String.valueOf(sql) + SQL.getTableName(targetType);
        sql = String.valueOf(sql) + "(";
        boolean doComma = false;
        int fieldNum = 0;
        for (Field f : targetType.getFields()) {
            if (!SQL.isPersistable(f) || !SQL.isInsertable(f)) continue;
            ++fieldNum;
            if (doComma) {
                sql = String.valueOf(sql) + ", ";
            }
            sql = String.valueOf(sql) + SQL.getColumnName(f);
            if (doComma) continue;
            doComma = true;
        }
        sql = String.valueOf(sql) + ") VALUES (";
        int i = 0;
        while (i < fieldNum) {
            if (i > 0) {
                sql = String.valueOf(sql) + ", ";
            }
            sql = String.valueOf(sql) + "?";
            ++i;
        }
        sql = String.valueOf(sql) + ")";
        return sql;
    }
}

