/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.impl;

import java.util.ArrayList;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlGetByKeyStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.impl.SqlIOStatementImpl;
import org.eclipse.edt.mof.eglx.persistence.sql.utils.SQL;

public class SqlGetByKeyStatementImpl
extends SqlIOStatementImpl
implements SqlGetByKeyStatement {
    @Override
    public String getSqlString() {
        String sql = super.getSqlString();
        if (sql == null || "".equals(sql)) {
            sql = this.generateDefaultSqlString();
            this.setSqlString(sql);
        }
        return sql;
    }

    private String generateDefaultSqlString() {
        Expression target;
        boolean targetIsList;
        EGLClass targetType;
        if (this.getPreparedStatement() != null || SQL.isSQLResultSet(this.getDataSource().getType())) {
            return null;
        }
        String sql = null;
        if (this.getTargets().size() == 1 && !TypeUtils.isDynamicType((Type)(targetType = (targetIsList = (target = (Expression)this.getTargets().get(0)).getType() instanceof ArrayType) ? (EGLClass)((ArrayType)target.getType()).getElementType().getClassifier() : (EGLClass)target.getType().getClassifier()))) {
            sql = "SELECT ";
            ArrayList<Field> idFields = new ArrayList<Field>();
            boolean doComma = false;
            for (Field f : targetType.getFields()) {
                if (SQL.isKeyField(f)) {
                    idFields.add(f);
                }
                if (!SQL.isPersistable(f)) continue;
                if (doComma) {
                    sql = String.valueOf(sql) + ", ";
                }
                sql = String.valueOf(sql) + SQL.getColumnName(f);
                if (doComma) continue;
                doComma = true;
            }
            sql = String.valueOf(sql) + " FROM ";
            sql = String.valueOf(sql) + SQL.getTableName(targetType);
            if (!targetIsList && !idFields.isEmpty()) {
                sql = String.valueOf(sql) + " WHERE ";
                boolean doAnd = false;
                for (Field f : idFields) {
                    if (doAnd) {
                        sql = String.valueOf(sql) + " AND ";
                    }
                    sql = String.valueOf(sql) + SQL.getColumnName(f) + " = ?";
                    if (doAnd) continue;
                    doAnd = true;
                }
            }
        }
        return sql;
    }
}

