/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.impl;

import java.util.ArrayList;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlOpenStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.impl.SqlIOStatementImpl;
import org.eclipse.edt.mof.eglx.persistence.sql.utils.SQL;

public class SqlOpenStatementImpl
extends SqlIOStatementImpl
implements SqlOpenStatement {
    @Override
    public Expression getResultSet() {
        return this.getTarget();
    }

    @Override
    public String getSqlString() {
        String sql = super.getSqlString();
        if (sql == null || "".equals(sql)) {
            sql = this.generateDefaultSqlString();
            this.setSqlString(sql);
        }
        return sql;
    }

    private String generateDefaultSqlString() {
        Expression target;
        EGLClass targetType;
        String sql = null;
        if (this.getTargets().size() == 2 && !TypeUtils.isDynamicType((Type)(targetType = (EGLClass)(target = (Expression)this.getTargets().get(1)).getType().getClassifier()))) {
            sql = "SELECT ";
            ArrayList<Field> idFields = new ArrayList<Field>();
            boolean doComma = false;
            for (Field f : targetType.getFields()) {
                if (SQL.isKeyField(f)) {
                    idFields.add(f);
                }
                if (!SQL.isPersistable(f)) continue;
                if (doComma) {
                    sql = String.valueOf(sql) + ", ";
                }
                sql = String.valueOf(sql) + SQL.getColumnName(f);
                if (doComma) continue;
                doComma = true;
            }
            sql = String.valueOf(sql) + " FROM ";
            sql = String.valueOf(sql) + SQL.getTableName(targetType);
        }
        return sql;
    }
}

