/*
 * Decompiled with CFR 0.152.
 */
package eglx.json;

import eglx.json.JsonLib;
import eglx.lang.AnyException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.json.ArrayNode;
import org.eclipse.edt.javart.json.NameValuePairNode;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.StringNode;
import org.eclipse.edt.javart.json.ValueNode;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.services.FunctionParameter;
import org.eclipse.edt.javart.services.FunctionParameterKind;
import org.eclipse.edt.javart.services.FunctionSignature;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartUtil;
import org.eclipse.edt.runtime.java.eglx.lang.AnyValue;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EBoolean;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.EList;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class JsonUtilities {
    private static String JSON_RPC_ERROR_ID = "error";
    private static String JSON_RPC_ERROR_NAME_ID = "name";
    public static String JSON_RPC_ERROR_NAME_VALUE = "JSONRPCError";
    private static String JSON_RPC_ERROR_MESSAGE_ID = "message";
    private static String JSON_RPC_ERROR_CODE_ID = "code";

    private JsonUtilities() {
    }

    public static String trimJSON(String json) {
        if (json == null || json.equals("")) {
            return json;
        }
        if (json.charAt(0) == '{') {
            int curlyCount = 1;
            boolean ignoreCurlyBraces = false;
            int n = 1;
            while (n < json.length()) {
                switch (json.charAt(n)) {
                    case '\"': {
                        if (!ignoreCurlyBraces) {
                            ignoreCurlyBraces = true;
                            break;
                        }
                        if (json.charAt(n - 1) == '\\') break;
                        ignoreCurlyBraces = false;
                        break;
                    }
                    case '{': {
                        if (ignoreCurlyBraces) break;
                        ++curlyCount;
                        break;
                    }
                    case '}': {
                        if (ignoreCurlyBraces) break;
                        --curlyCount;
                    }
                }
                if (curlyCount == 0) {
                    json = json.substring(0, n + 1);
                }
                ++n;
            }
        }
        return json;
    }

    public static String createJsonAnyException(AnyException jrte) {
        ObjectNode wrapper = new ObjectNode();
        ObjectNode error = new ObjectNode();
        error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_NAME_ID, true), new StringNode(JSON_RPC_ERROR_NAME_VALUE, false)));
        error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_CODE_ID, true), new StringNode(jrte.getMessageID(), false)));
        error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_MESSAGE_ID, true), new StringNode(ServiceUtilities.getMessage(jrte), false)));
        wrapper.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_ID, true), error));
        if (jrte instanceof AnyException) {
            ObjectNode eglException;
            AnyException record = jrte;
            try {
                eglException = (ObjectNode)JsonLib.convertToJsonNode(record);
            }
            catch (AnyException anyException) {
                eglException = new ObjectNode();
            }
            error.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_ID, true), eglException));
            eglException.addPair(new NameValuePairNode(new StringNode(JSON_RPC_ERROR_NAME_ID, true), new StringNode(record.getClass().getName(), false)));
        }
        return wrapper.toJson();
    }

    public static Object[] getParameters(Method method, ArrayNode jsonParameters) {
        FunctionSignature signature = method.getAnnotation(FunctionSignature.class);
        ArrayList<AnyBoxedObject<Object>> parameters = new ArrayList<AnyBoxedObject<Object>>();
        int jsonIdx = 0;
        int idx = 0;
        while (idx < signature.parameters().length) {
            FunctionParameter functionParameter = signature.parameters()[idx];
            if (functionParameter.kind().equals((Object)FunctionParameterKind.OUT)) {
                try {
                    Class<?> fieldType = functionParameter.parameterType();
                    Object newValue = null;
                    if (functionParameter.arrayDimensions() > 0) {
                        newValue = EList.ezeNew(fieldType);
                    } else if (fieldType.equals(EBigint.class)) {
                        newValue = EBigint.asBigint(0);
                    } else if (fieldType.equals(EBoolean.class)) {
                        newValue = EBoolean.asBoolean(false);
                    } else if (fieldType.equals(EDate.class)) {
                        Calendar cal = DateTimeUtil.getBaseCalendar();
                        cal.get(1);
                        newValue = EDate.asDate(cal);
                    } else if (fieldType.equals(EDecimal.class)) {
                        if (functionParameter.asOptions() != null && functionParameter.asOptions().length > 1) {
                            int length = Integer.parseInt(functionParameter.asOptions()[0]);
                            int decimal = Integer.parseInt(functionParameter.asOptions()[1]);
                            newValue = EDecimal.asDecimal(0, length, decimal);
                        } else {
                            newValue = EDecimal.asDecimal(0, new Integer[0]);
                        }
                    } else if (fieldType.equals(EFloat.class)) {
                        newValue = EFloat.asFloat(0);
                    } else if (fieldType.equals(EInt.class)) {
                        newValue = EInt.asInt(0);
                    } else if (fieldType.equals(ESmallfloat.class)) {
                        newValue = ESmallfloat.asSmallfloat(0);
                    } else if (fieldType.equals(ESmallint.class)) {
                        newValue = ESmallint.asSmallint(0);
                    } else if (fieldType.equals(EString.class)) {
                        newValue = "";
                    } else if (fieldType.equals(ETimestamp.class)) {
                        int start = 0;
                        int end = 5;
                        if (functionParameter.asOptions() != null && functionParameter.asOptions().length > 1) {
                            start = JsonUtilities.getETimestampStaticField(functionParameter.asOptions()[0]);
                            end = JsonUtilities.getETimestampStaticField(functionParameter.asOptions()[1]);
                        }
                        Calendar cal = DateTimeUtil.getBaseCalendar();
                        cal.get(1);
                        newValue = ETimestamp.asTimestamp(cal, start, end);
                    } else if (AnyValue.class.isAssignableFrom(fieldType)) {
                        newValue = fieldType.newInstance();
                    } else if (ExecutableBase.class.isAssignableFrom(fieldType)) {
                        newValue = fieldType.newInstance();
                    } else if (fieldType.equals(Enum.class)) {
                        ?[] objArray = fieldType.getEnumConstants();
                        int n = objArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object enumConstant = objArray[n2];
                            if (enumConstant instanceof Enum) {
                                newValue = enumConstant;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (method.getParameterTypes()[idx].equals(AnyBoxedObject.class)) {
                        newValue = EAny.ezeWrap(newValue);
                    }
                    parameters.add((AnyBoxedObject<Object>)newValue);
                }
                catch (Exception e) {
                    JavartUtil.makeEglException(e);
                }
            } else {
                AnyBoxedObject<Object> obj = JsonLib.convertToEgl(functionParameter.parameterType(), functionParameter.asOptions(), null, (ValueNode)jsonParameters.getValues().get(jsonIdx++));
                if (method.getParameterTypes()[idx].equals(AnyBoxedObject.class)) {
                    obj = EAny.ezeWrap(obj);
                }
                parameters.add(obj);
            }
            ++idx;
        }
        return parameters.toArray(new Object[parameters.size()]);
    }

    static int getETimestampStaticField(String fieldName) {
        if ("YEAR_CODE".equalsIgnoreCase(fieldName)) {
            return 0;
        }
        if ("SECOND_CODE".equalsIgnoreCase(fieldName)) {
            return 5;
        }
        if ("MONTH_CODE".equalsIgnoreCase(fieldName)) {
            return 1;
        }
        if ("MINUTE_CODE".equalsIgnoreCase(fieldName)) {
            return 4;
        }
        if ("HOUR_CODE".equalsIgnoreCase(fieldName)) {
            return 3;
        }
        if ("FRACTION6_CODE".equalsIgnoreCase(fieldName)) {
            return 11;
        }
        if ("FRACTION5_CODE".equalsIgnoreCase(fieldName)) {
            return 10;
        }
        if ("FRACTION4_CODE".equalsIgnoreCase(fieldName)) {
            return 9;
        }
        if ("FRACTION3_CODE".equalsIgnoreCase(fieldName)) {
            return 8;
        }
        if ("FRACTION2_CODE".equalsIgnoreCase(fieldName)) {
            return 7;
        }
        if ("FRACTION1_CODE".equalsIgnoreCase(fieldName)) {
            return 6;
        }
        if ("DAY_CODE".equalsIgnoreCase(fieldName)) {
            return 2;
        }
        return 0;
    }
}

