/*
 * Decompiled with CFR 0.152.
 */
package eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.lang.InvalidIndexException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.TimestampData;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.javart.util.NumberFormatter;

public class StringLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;

    public static String format(BigDecimal number, String format) {
        return NumberFormatter.fmtNum(number, format, Runtime.getRunUnit().getLocalizedText());
    }

    public static String format(short number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, Runtime.getRunUnit().getLocalizedText());
    }

    public static String format(int number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, Runtime.getRunUnit().getLocalizedText());
    }

    public static String format(long number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, Runtime.getRunUnit().getLocalizedText());
    }

    public static String format(float number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, Runtime.getRunUnit().getLocalizedText());
    }

    public static String format(double number, String format) {
        return NumberFormatter.fmtNum(new BigDecimal(number), format, Runtime.getRunUnit().getLocalizedText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Calendar timestampValue, String timestampFormat) {
        TimestampData data = new TimestampData(timestampValue, timestampValue.get(14) * 1000);
        boolean reset = false;
        int micros = data.microseconds;
        if (micros < 0) {
            reset = true;
            data.calendar.add(13, -1);
            micros += 1000000;
        }
        try {
            int century = data.calendar.get(1) / 100 + 1;
            Date date = data.calendar.getTime();
            byte[] byArray = DateTimeUtil.LOCK;
            synchronized (DateTimeUtil.LOCK) {
                JavartDateFormat formatter = DateTimeUtil.getDateFormat(timestampFormat);
                formatter.setCentury(century);
                formatter.setMicrosecond(micros);
                String string = formatter.format(date);
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return string;
            }
        }
        finally {
            if (reset) {
                data.calendar.add(13, 1);
            }
        }
    }

    public static String getNextToken(String source, AnyBoxedObject<Integer> index, String delimiters) throws AnyException {
        int start = index.ezeUnbox();
        int searchEnd = source.length();
        if (start < 1 || start > searchEnd) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = start;
            throw ex.fillInMessage("EGL0011E", start);
        }
        int tokenStart = start - 1;
        while (tokenStart != searchEnd && delimiters.indexOf(source.charAt(tokenStart)) != -1) {
            ++tokenStart;
        }
        if (tokenStart >= searchEnd) {
            return null;
        }
        int tokenEnd = tokenStart + 1;
        while (tokenEnd != searchEnd && delimiters.indexOf(source.charAt(tokenEnd)) == -1) {
            ++tokenEnd;
        }
        index.ezeCopy(tokenEnd + 1);
        return source.substring(tokenStart, tokenEnd);
    }

    public static int getTokenCount(String source, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(source, delimiters);
        return tokenizer.countTokens();
    }

    public static String fromCharCode(int character) {
        if (character < 0 || character > 65535) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0039E", character, 0, 65535);
        }
        return String.valueOf((char)character);
    }

    public static String spaces(int characterCount) {
        String retVal;
        if (characterCount <= 0) {
            retVal = "";
        } else if (characterCount < 50) {
            retVal = "                                                  ".substring(0, characterCount);
        } else {
            StringBuilder buf = new StringBuilder(characterCount);
            buf.append("                                                  ");
            while (characterCount >= 50) {
                buf.append("                                                  ");
                characterCount -= 50;
            }
            if (characterCount > 0) {
                buf.append("                                                  ".substring(0, characterCount));
            }
            retVal = buf.toString();
        }
        return retVal;
    }
}

