/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.ide;

import eglx.lang.AnyException;
import eglx.lang.SysLib;
import eglx.persistence.sql.SQLDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;

public class IDEResourceLocator
extends SysLib
implements SysLib.ResourceLocator {
    private static final long serialVersionUID = 1L;
    private Map<String, String> ddPaths = new HashMap<String, String>();
    private final String ideURL;
    private String defaultDD;

    public IDEResourceLocator(int idePort) {
        this.ideURL = "http://localhost:" + idePort + "/__testServer";
    }

    @Override
    public Object locateResource(String bindingKey) {
        return this.locateResource(bindingKey, this.defaultDD);
    }

    @Override
    public Object locateResource(String bindingKey, String propertyFileName) {
        return IDEResourceLocator.doGetResource(bindingKey, propertyFileName);
    }

    @Override
    public Object convertToResource(Binding binding) {
        String[] tokens;
        String profileInfo;
        String uri;
        SQLDatabaseBinding sqlBinding;
        if (binding instanceof SQLDatabaseBinding && (sqlBinding = (SQLDatabaseBinding)binding).isUseURI() && (uri = sqlBinding.getUri()) != null && uri.startsWith("workspace://") && (profileInfo = this.getConnectionProfileSettings(uri.substring(12))) != null && profileInfo.length() > 0 && (tokens = profileInfo.split(";")).length > 0) {
            String url = tokens[0].trim();
            String user = null;
            String pass = null;
            String schema = null;
            String className = null;
            if (tokens.length > 1) {
                user = tokens[1].trim();
            }
            if (tokens.length > 2) {
                pass = tokens[2].trim();
            }
            if (tokens.length > 3) {
                schema = tokens[3].trim();
            }
            if (tokens.length > 4) {
                className = tokens[4].trim();
            }
            try {
                url = URLDecoder.decode(url, "UTF-8");
                if (user != null) {
                    user = URLDecoder.decode(user, "UTF-8");
                }
                if (pass != null) {
                    pass = URLDecoder.decode(pass, "UTF-8");
                }
                if (schema != null) {
                    schema = URLDecoder.decode(schema, "UTF-8");
                }
                if (className != null) {
                    className = URLDecoder.decode(className, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            EDictionary props = new EDictionary();
            if (user != null && user.length() > 0) {
                props.put("user", (Object)user);
            }
            if (pass != null && pass.length() > 0) {
                props.put("password", (Object)pass);
            }
            SQLDataSource ds = new SQLDataSource(url, props);
            if (schema != null && schema.length() > 0) {
                ds.setCurrentSchema(schema);
            }
            if (className != null && className.length() > 0) {
                try {
                    Class.forName(className);
                }
                catch (Throwable throwable) {}
            }
            return ds;
        }
        return null;
    }

    @Override
    public RuntimeDeploymentDesc getDeploymentDesc(String propertyFileName) {
        String normalized = this.normalizePropertyFileName(propertyFileName);
        RuntimeDeploymentDesc dd = (RuntimeDeploymentDesc)deploymentDescs.get(normalized);
        if (dd == null) {
            String path = this.ddPaths.get(normalized);
            if (path != null && path.length() > 0) {
                try {
                    FileInputStream is = new FileInputStream(new File(path));
                    dd = RuntimeDeploymentDesc.createDeploymentDescriptor(normalized, is);
                    deploymentDescs.put(normalized, dd);
                }
                catch (Exception exception) {
                    throw new AnyException();
                }
            } else {
                throw new AnyException();
            }
        }
        return dd;
    }

    private String normalizePropertyFileName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash != -1) {
            name = name.substring(lastSlash + 1);
        }
        if (name.endsWith("-bnd.xml")) {
            name = name.substring(0, name.length() - 8);
        } else if (name.endsWith(".egldd")) {
            name = name.substring(0, name.length() - 6);
        }
        return name.toLowerCase();
    }

    public void setDefaultDD(String dd) {
        this.defaultDD = dd;
    }

    public List<String[]> parseDDArgument(String ddFiles, boolean added) {
        StringTokenizer tok = new StringTokenizer(ddFiles, File.pathSeparator);
        ArrayList<String[]> ddEntries = new ArrayList<String[]>();
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            if (!tok.hasMoreTokens()) continue;
            String path = tok.nextToken();
            try {
                name = URLDecoder.decode(name, "UTF-8");
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            ddEntries.add(new String[]{name, path});
            if (added) {
                this.addDDFile(name, path);
                continue;
            }
            this.removeDDFile(name);
        }
        return ddEntries;
    }

    public void addDDFile(String name, String path) {
        this.ddPaths.put(name, path);
        this.removeFromCache(name);
    }

    public void removeDDFile(String name) {
        this.ddPaths.remove(name);
        this.removeFromCache(name);
    }

    private void removeFromCache(String ddName) {
        if (deploymentDescs.size() > 0) {
            deploymentDescs.remove(ddName);
        }
        if (resources.size() > 0) {
            Iterator it = resources.keySet().iterator();
            while (it.hasNext()) {
                QName q = (QName)it.next();
                if (!ddName.equals(this.normalizePropertyFileName(q.getNamespaceURI()))) continue;
                it.remove();
            }
        }
    }

    private String getConnectionProfileSettings(String profileName) {
        String connectionURL;
        block24: {
            connectionURL = null;
            InputStream is = null;
            try {
                try {
                    HttpURLConnection conn = (HttpURLConnection)new URL(this.ideURL).openConnection();
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Accept-Charset", "UTF-8");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    OutputStream output = null;
                    try {
                        output = conn.getOutputStream();
                        output.write(("connectionProfile=" + profileName).getBytes("UTF-8"));
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (conn.getResponseCode() == 200) {
                        String line;
                        is = conn.getInputStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        StringBuilder buf = new StringBuilder(50);
                        while ((line = br.readLine()) != null) {
                            buf.append(line);
                        }
                        connectionURL = buf.toString();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return connectionURL;
    }
}

