/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services;

import eglx.lang.AnyException;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.edt.javart.util.JavartUtil;

public class ServiceUtilities {
    public static String UTF8 = "UTF-8";

    private ServiceUtilities() {
    }

    public static ServiceInvocationException buildServiceInvocationException(String id, Object[] params, Throwable t, ServiceKind serviceKind) {
        return ServiceUtilities.buildInvocationException(id, params, "", "", "", t, serviceKind);
    }

    public static ServiceInvocationException buildInvocationException(String id, Object[] params, String detail1, String detail2, String detail3, Throwable t, ServiceKind serviceKind) {
        String message = JavartUtil.errorMessage(id, params);
        while (t instanceof InvocationTargetException && ((InvocationTargetException)t).getCause() != null) {
            t = ((InvocationTargetException)t).getCause();
        }
        ServiceInvocationException sie = new ServiceInvocationException();
        if (detail3 == null || detail3.length() == 0) {
            detail3 = ServiceUtilities.getMessage(t);
        }
        sie.setMessage(message == null ? "" : message);
        sie.setMessageID(id == null ? "" : id);
        sie.setDetail1(detail1 == null ? "" : detail1);
        sie.setDetail2(detail2 == null ? "" : detail2);
        sie.setDetail3(detail3 == null ? "" : detail3);
        sie.setSource(serviceKind);
        if (t != null) {
            sie.initCause(t);
        }
        return sie;
    }

    public static String getMessage(Throwable t) {
        while (t instanceof InvocationTargetException && ((InvocationTargetException)t).getCause() != null) {
            t = ((InvocationTargetException)t).getCause();
        }
        if (t instanceof AnyException) {
            return t.getMessage();
        }
        if (t != null && t.getMessage() != null) {
            return String.valueOf(t.getClass().getName()) + ":" + t.getMessage();
        }
        if (t != null && t.toString() != null) {
            return t.toString();
        }
        return "";
    }

    static String convert(Map<?, ?> map) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() != null) {
                buffer.append(entry.getKey().toString());
                buffer.append(':');
            }
            if (entry.getValue() instanceof Map) {
                buffer.append('(');
                buffer.append(ServiceUtilities.convert((Map)entry.getValue()));
                buffer.append(')');
            } else if (entry.getValue() != null) {
                buffer.append(entry.getValue().toString());
            }
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String convert(ServiceKind serviceKind) {
        if (ServiceKind.EGL.equals((Object)serviceKind)) {
            return "EGL";
        }
        if (ServiceKind.NATIVE.equals((Object)serviceKind)) {
            return "NATIVE";
        }
        if (ServiceKind.REST.equals((Object)serviceKind)) {
            return "REST";
        }
        if (ServiceKind.WEB.equals((Object)serviceKind)) {
            return "WEB";
        }
        return "";
    }
}

