/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet;

import eglx.http.HttpUtilities;
import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonUtilities;
import eglx.lang.EDictionary;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.JEERunUnit;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.json.ParseException;
import org.eclipse.edt.javart.resources.StartupInfo;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;

public abstract class Servlet
extends HttpServlet
implements javax.servlet.Servlet {
    private static final long serialVersionUID = 10L;
    private Trace tracer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected Trace tracer() {
        if (this.tracer == null) {
            this.tracer = this.getRunUnit().getTrace();
        }
        return this.tracer;
    }

    protected abstract String servletName();

    protected RunUnit getRunUnit() {
        RunUnit ru = Runtime.getRunUnit();
        if (ru == null) {
            ru = new JEERunUnit(new StartupInfo(this.servletName(), "", null));
            Runtime.setThreadRunUnit(ru);
        }
        return ru;
    }

    protected void trace(String msg) {
        if (this.tracer().traceIsOn(1)) {
            this.tracer().put(msg);
        }
    }

    protected void doPost(HttpServletRequest httpServletReq, HttpServletResponse httpServletRes) throws ServletException, IOException {
        this.doHttp(httpServletReq, httpServletRes);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doHttp(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doHttp(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doHttp(req, resp);
    }

    private void doHttp(HttpServletRequest httpServletReq, HttpServletResponse httpServletRes) {
        this.getRunUnit();
        HttpSession session = httpServletReq.getSession();
        if (this.tracer().traceIsOn(1)) {
            this.trace("HttpServletRequest.getContextPath():" + httpServletReq.getContextPath());
            this.trace("HttpServletRequest.getPathInfo():" + httpServletReq.getPathInfo());
        }
        String url = null;
        ServiceKind serviceKind = null;
        Request request = null;
        Response response = null;
        try {
            if (this.tracer().traceIsOn(1)) {
                this.trace(String.valueOf(this.servletName()) + " sessionId:" + (session == null ? "null" : session.getId()));
            }
            if ((request = ServletUtilities.createNewRequest(httpServletReq)) != null) {
                url = request.uri;
                if (this.tracer().traceIsOn(1)) {
                    this.tracer().put("REQUEST:");
                    this.tracer().put("    URL:" + url != null ? url : "null");
                    this.tracer().put("    content:" + request.body != null ? request.body : "null");
                    this.tracer().put("    httpMethod:" + (Object)((Object)request.method) != null ? HttpUtilities.httpMethodToString(request.method) : "null");
                }
                response = this.processRequest(url, request, httpServletReq);
            }
        }
        catch (Throwable t) {
            response = this.buildResponse(this.getRunUnit(), httpServletReq.getRequestURL().toString(), t, request != null && request.body != null ? request.body : "", serviceKind);
        }
        String content = response.body;
        this.log(content, response);
        this.write(httpServletRes, content, response.headers, response.status);
    }

    protected abstract Response processRequest(String var1, Request var2, HttpServletRequest var3) throws Exception;

    private Response buildResponse(RunUnit runUnit, String url, Throwable t, String requestContent, ServiceKind serviceKind) {
        Response outerResponse = new Response();
        ServiceInvocationException jrte = t instanceof ParseException ? ServiceUtilities.buildServiceInvocationException("EGL0027E", new String[]{requestContent}, t, serviceKind) : (t instanceof IOException ? ServiceUtilities.buildServiceInvocationException("EGL0022E", new String[]{url}, t, serviceKind) : ServiceUtilities.buildServiceInvocationException("EGL0028E", new Object[0], t, serviceKind));
        Response innerResponse = new Response();
        innerResponse.body = JsonUtilities.createJsonAnyException(jrte);
        innerResponse.status = 500;
        innerResponse.statusMessage = "FAILED";
        ServletUtilities.setBody(outerResponse, innerResponse);
        outerResponse.status = 200;
        outerResponse.statusMessage = "OK";
        return outerResponse;
    }

    private void log(String content, Response response) {
    }

    private void write(HttpServletResponse httpServletRes, String content, EDictionary headers, int status) {
        block10: {
            try {
                boolean addContentType = true;
                if (headers != null) {
                    for (Map.Entry entry : headers.entrySet()) {
                        Object entryValue = entry.getValue();
                        if (entryValue instanceof AnyBoxedObject) {
                            entryValue = ((AnyBoxedObject)entryValue).ezeUnbox();
                        }
                        if (((String)entry.getKey()).equalsIgnoreCase("Content-Type")) {
                            addContentType = false;
                        }
                        if (entryValue == null) continue;
                        httpServletRes.setHeader((String)entry.getKey(), entryValue.toString());
                    }
                }
                if (addContentType) {
                    httpServletRes.setContentType(HttpUtilities.getContentType("text"));
                }
                if (status == 200) {
                    PrintWriter pw = httpServletRes.getWriter();
                    pw.write(content);
                    pw.flush();
                    httpServletRes.setStatus(status);
                    httpServletRes.flushBuffer();
                    break block10;
                }
                try {
                    httpServletRes.setHeader(JsonUtilities.JSON_RPC_ERROR_NAME_VALUE, URLEncoder.encode(content, ServiceUtilities.UTF8));
                }
                catch (Exception exception) {}
                httpServletRes.sendError(status);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }
}

