/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class RuiBrowserHttpRequest {
    private String URL;
    private Map<String, String> headers;
    private Map<String, String> arguments;
    private String method;
    private String content;
    private Map<String, String> contentArguments;
    public static String CONTENT_LENGTH_ID = "Content-Length";
    public static String JSON_RPC_GET_METHOD_ID = "GET";
    public static final int MAX_NUMBER_CHARS = Integer.MAX_VALUE;

    private RuiBrowserHttpRequest() {
    }

    public static RuiBrowserHttpRequest createNewRequest(HttpServletRequest httpServletReq) throws IOException {
        RuiBrowserHttpRequest newRequest = new RuiBrowserHttpRequest();
        newRequest.method = httpServletReq.getMethod();
        newRequest.URL = httpServletReq.getRequestURI();
        newRequest.headers = RuiBrowserHttpRequest.processHeaders(httpServletReq);
        if (JSON_RPC_GET_METHOD_ID.equalsIgnoreCase(newRequest.method)) {
            newRequest.arguments = httpServletReq.getParameterMap();
        }
        BufferedReader reader = httpServletReq.getReader();
        newRequest.content = RuiBrowserHttpRequest.processContent(httpServletReq.getContentLength(), reader);
        return newRequest;
    }

    public static RuiBrowserHttpRequest createNewRequest(Socket client) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream(), "utf-8"));
        String request = reader.readLine();
        if (request != null) {
            RuiBrowserHttpRequest newRequest = new RuiBrowserHttpRequest();
            newRequest.method = request.substring(0, request.indexOf(32)).trim();
            request = request.substring(request.indexOf(32));
            request = request.substring(0, request.lastIndexOf(32));
            newRequest.URL = RuiBrowserHttpRequest.processRequestURL(request);
            newRequest.arguments = RuiBrowserHttpRequest.processArgs(request);
            newRequest.headers = RuiBrowserHttpRequest.processHeaders(reader);
            newRequest.content = RuiBrowserHttpRequest.processContent(RuiBrowserHttpRequest.getContentLength(newRequest), reader);
            return newRequest;
        }
        return null;
    }

    private static int getContentLength(RuiBrowserHttpRequest request) {
        String lengthString = request.headers.get(CONTENT_LENGTH_ID);
        if (lengthString == null || lengthString.length() == 0) {
            for (String key : request.headers.keySet()) {
                if (!CONTENT_LENGTH_ID.equalsIgnoreCase(key)) continue;
                lengthString = request.headers.get(key);
                break;
            }
        }
        int contentLength = -1;
        if (lengthString != null) {
            try {
                contentLength = Integer.parseInt(lengthString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return contentLength;
    }

    private static Map<String, String> processContentArgs(String request) {
        return RuiBrowserHttpRequest.processArgs("?" + request);
    }

    public Map<String, String> getContentArguments() {
        if (this.contentArguments == null) {
            this.contentArguments = RuiBrowserHttpRequest.processContentArgs(this.content);
        }
        return this.contentArguments;
    }

    public String getURL() {
        return this.URL;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContent() {
        return this.content;
    }

    private static String processContent(int contentLength, BufferedReader reader) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        if (contentLength > 0) {
            int i = 0;
            while (i < contentLength) {
                char nRead = (char)reader.read();
                contentBuffer.append(nRead);
                String str = Character.toString(nRead);
                byte[] bytes = str.getBytes("utf-8");
                i += bytes.length;
            }
        }
        return contentBuffer.toString();
    }

    public static Map<String, String> processHeaders(HttpServletRequest httpServletReq) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration headerEnum = httpServletReq.getHeaderNames();
        while (headerEnum.hasMoreElements()) {
            String headername = (String)headerEnum.nextElement();
            result.put(headername, httpServletReq.getHeader(headername));
        }
        return result;
    }

    private static Map<String, String> processHeaders(BufferedReader reader) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String header = reader.readLine();
        while (header != null && header.length() > 0) {
            String label = header.substring(0, header.indexOf(58));
            String value = header.substring(header.indexOf(58) + 2);
            result.put(label, value);
            header = reader.readLine();
        }
        return result;
    }

    private static String processRequestURL(String request) {
        int questionMarkIndex = request.indexOf(63);
        if (questionMarkIndex != -1) {
            return request.substring(0, questionMarkIndex);
        }
        return request;
    }

    private static Map<String, String> processArgs(String request) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        int questionMarkIndex = request.indexOf(63);
        if (questionMarkIndex != -1) {
            request = request.substring(questionMarkIndex + 1);
            StringTokenizer arg = new StringTokenizer(request, "&");
            while (arg.hasMoreTokens()) {
                try {
                    String nextToken = arg.nextToken();
                    String key = nextToken.substring(0, nextToken.indexOf("="));
                    String value = URLDecoder.decode(nextToken.substring(nextToken.indexOf("=") + 1), "UTF-8");
                    arguments.put(key, value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return arguments;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("METHOD: " + this.method + "\n");
        result.append("URL: " + this.URL + "\n");
        result.append("Arguments: \n");
        for (String argument : this.arguments.keySet()) {
            result.append("\t" + argument + " = " + this.arguments.get(argument) + "\n");
        }
        result.append("Headers: \n");
        for (String header : this.headers.keySet()) {
            result.append("\t" + header + " = " + this.headers.get(header) + "\n");
        }
        return result.toString();
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void setURL(String url) {
        this.URL = url;
    }
}

