/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.ChineseCalendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.HebrewCalendar;
import com.ibm.icu.util.IslamicCalendar;
import com.ibm.icu.util.JapaneseCalendar;
import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.edt.javart.util.JavartChineseDateFormat;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.javart.util.JavartSimpleDateFormat;

public class DateTimeUtil {
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final int SECONDS_PER_DAY = 86400;
    private static final Calendar baseCalendar = Calendar.getInstance();
    private static final int GREGORIAN = 0;
    private static final int BUDDHIST = 1;
    private static final int CHINESE = 2;
    private static final int HEBREW = 3;
    private static final int ISLAMIC = 4;
    private static final int JAPANESE = 5;
    private static JavartDateFormat[] DATE_FORMATTERS;
    private static Locale[] DATE_FORMATTER_LOCALES;
    public static final byte[] LOCK;

    static {
        baseCalendar.clear();
        baseCalendar.setLenient(false);
        DATE_FORMATTERS = new JavartDateFormat[6];
        DATE_FORMATTER_LOCALES = new Locale[6];
        LOCK = new byte[0];
    }

    public static Calendar getNewCalendar() {
        Calendar cal = (Calendar)baseCalendar.clone();
        cal.setTimeInMillis(System.currentTimeMillis());
        return cal;
    }

    public static Calendar getNewCalendar(Date date) {
        Calendar cal = DateTimeUtil.getNewCalendar();
        cal.setTime(date);
        return cal;
    }

    public static Calendar getNewCalendar(java.sql.Date date) {
        Calendar cal = DateTimeUtil.getNewCalendar();
        cal.setTime(date);
        return cal;
    }

    public static Calendar getNewCalendar(Time time) {
        Calendar cal = DateTimeUtil.getNewCalendar();
        cal.setTime(time);
        return cal;
    }

    public static Calendar getNewCalendar(Timestamp time) {
        Calendar cal = DateTimeUtil.getNewCalendar();
        cal.setTime(time);
        return cal;
    }

    public static Calendar getBaseCalendar() {
        return (Calendar)baseCalendar.clone();
    }

    public static JavartDateFormat getDateFormat(String pattern) {
        int type = 0;
        boolean calendarSpecified = false;
        if (pattern.length() > 1) {
            switch (pattern.charAt(0)) {
                case 'B': {
                    if (pattern.charAt(1) != 'u') break;
                    type = 1;
                    calendarSpecified = true;
                    break;
                }
                case 'C': {
                    if (pattern.charAt(1) != 'h') break;
                    type = 2;
                    calendarSpecified = true;
                    break;
                }
                case 'G': {
                    if (pattern.charAt(1) != 'r') break;
                    calendarSpecified = true;
                    break;
                }
                case 'H': {
                    if (pattern.charAt(1) != 'e') break;
                    type = 3;
                    calendarSpecified = true;
                    break;
                }
                case 'I': {
                    if (pattern.charAt(1) != 's') break;
                    type = 4;
                    calendarSpecified = true;
                    break;
                }
                case 'J': {
                    if (pattern.charAt(1) != 'a') break;
                    type = 5;
                    calendarSpecified = true;
                }
            }
        }
        if (calendarSpecified) {
            pattern = pattern.substring(2);
        }
        JavartDateFormat formatter = DATE_FORMATTERS[type];
        Locale locale = Locale.getDefault();
        if (formatter == null || !locale.equals(DATE_FORMATTER_LOCALES[type])) {
            com.ibm.icu.util.Calendar cal = null;
            switch (type) {
                case 0: {
                    cal = new GregorianCalendar(locale){

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, ULocale locale) {
                            DateFormatSymbols symbols = new DateFormatSymbols((com.ibm.icu.util.Calendar)this, locale);
                            return new JavartSimpleDateFormat(pattern, symbols, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, ULocale locale) {
                            return this.handleGetDateFormat(pattern, null, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, Locale locale) {
                            return this.handleGetDateFormat(pattern, override, ULocale.forLocale(locale));
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, Locale locale) {
                            return this.handleGetDateFormat(pattern, null, ULocale.forLocale(locale));
                        }
                    };
                    break;
                }
                case 1: {
                    cal = new BuddhistCalendar(locale){

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, ULocale locale) {
                            DateFormatSymbols symbols = new DateFormatSymbols((com.ibm.icu.util.Calendar)this, locale);
                            return new JavartSimpleDateFormat(pattern, symbols, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, ULocale locale) {
                            return this.handleGetDateFormat(pattern, null, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, Locale locale) {
                            return this.handleGetDateFormat(pattern, override, ULocale.forLocale(locale));
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, Locale locale) {
                            return this.handleGetDateFormat(pattern, null, ULocale.forLocale(locale));
                        }
                    };
                    break;
                }
                case 2: {
                    cal = new ChineseCalendar(){

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, ULocale locale) {
                            return new JavartChineseDateFormat(pattern, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, ULocale locale) {
                            return this.handleGetDateFormat(pattern, null, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, Locale locale) {
                            return this.handleGetDateFormat(pattern, override, ULocale.forLocale(locale));
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, Locale locale) {
                            return this.handleGetDateFormat(pattern, null, ULocale.forLocale(locale));
                        }
                    };
                    break;
                }
                case 3: {
                    cal = new HebrewCalendar(locale){

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, ULocale locale) {
                            DateFormatSymbols symbols = new DateFormatSymbols((com.ibm.icu.util.Calendar)this, locale);
                            return new JavartSimpleDateFormat(pattern, symbols, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, ULocale locale) {
                            return this.handleGetDateFormat(pattern, null, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, Locale locale) {
                            return this.handleGetDateFormat(pattern, override, ULocale.forLocale(locale));
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, Locale locale) {
                            return this.handleGetDateFormat(pattern, null, ULocale.forLocale(locale));
                        }
                    };
                    break;
                }
                case 4: {
                    cal = new IslamicCalendar(locale){

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, ULocale locale) {
                            DateFormatSymbols symbols = new DateFormatSymbols((com.ibm.icu.util.Calendar)this, locale);
                            return new JavartSimpleDateFormat(pattern, symbols, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, ULocale locale) {
                            return this.handleGetDateFormat(pattern, null, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, Locale locale) {
                            return this.handleGetDateFormat(pattern, override, ULocale.forLocale(locale));
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, Locale locale) {
                            return this.handleGetDateFormat(pattern, null, ULocale.forLocale(locale));
                        }
                    };
                    break;
                }
                case 5: {
                    cal = new JapaneseCalendar(locale){

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, ULocale locale) {
                            DateFormatSymbols symbols = new DateFormatSymbols((com.ibm.icu.util.Calendar)this, locale);
                            return new JavartSimpleDateFormat(pattern, symbols, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, ULocale locale) {
                            return this.handleGetDateFormat(pattern, null, locale);
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, String override, Locale locale) {
                            return this.handleGetDateFormat(pattern, override, ULocale.forLocale(locale));
                        }

                        @Override
                        protected DateFormat handleGetDateFormat(String pattern, Locale locale) {
                            return this.handleGetDateFormat(pattern, null, ULocale.forLocale(locale));
                        }
                    };
                }
            }
            formatter = (JavartDateFormat)((Object)cal.getDateTimeFormat(2, 2, ULocale.forLocale(locale)));
            formatter.setLenient(false);
            DateTimeUtil.DATE_FORMATTERS[type] = formatter;
            DateTimeUtil.DATE_FORMATTER_LOCALES[type] = locale;
        }
        formatter.applyPattern(pattern);
        return formatter;
    }
}

