/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import java.math.BigDecimal;
import org.eclipse.edt.javart.resources.LocalizedText;

public class NumberFormatter {
    public static String fmtNum(BigDecimal value, String fmtstring, LocalizedText locText) {
        if (fmtstring == null || fmtstring.trim().length() == 0) {
            return "";
        }
        return NumberFormatter.fmtNum(value.toPlainString(), value.signum(), fmtstring, locText);
    }

    private static String fmtNum(String valueString, int signum, String fmtstring, LocalizedText locText) {
        if (valueString.charAt(0) == '-') {
            valueString = valueString.substring(1);
        }
        if (valueString.charAt(0) == '0') {
            valueString = valueString.substring(1);
        }
        int FMTSIZE = 80;
        if (valueString.length() > FMTSIZE) {
            FMTSIZE = valueString.length();
            int decpos = fmtstring.indexOf(46);
            int stlen = fmtstring.length();
            int ndecchars = stlen - decpos;
            FMTSIZE += ndecchars;
        }
        int AREASIZE = FMTSIZE + 2;
        char[] formatter = new char[AREASIZE];
        fmtstring.getChars(0, Math.min(FMTSIZE, fmtstring.length()), formatter, 1);
        char[] p_frmt = formatter;
        int p_frmtIndex = 1;
        int firstDecCharLocation = -1;
        while (p_frmt[p_frmtIndex] != '\u0000') {
            if (p_frmt[p_frmtIndex] == '.') {
                firstDecCharLocation = ++p_frmtIndex;
                break;
            }
            ++p_frmtIndex;
        }
        int deccnt = 0;
        while (p_frmt[p_frmtIndex] != '\u0000') {
            switch (p_frmt[p_frmtIndex]) {
                case '#': 
                case '$': 
                case '&': 
                case '(': 
                case '*': 
                case '+': 
                case '-': 
                case '<': {
                    ++deccnt;
                }
            }
            ++p_frmtIndex;
        }
        char[] dgtstr = new char[AREASIZE];
        int decpt_pos = NumberFormatter.deccvt(valueString, signum, deccnt, dgtstr);
        CCharArray eedecpoint = new CCharArray(AREASIZE);
        eedecpoint.ccharArrayIndex = 1 + decpt_pos;
        int i = 0;
        while (dgtstr[i] != '\u0000') {
            eedecpoint.ccharArray[i + 1] = dgtstr[i];
            ++i;
        }
        CBoolean useMonetary = new CBoolean(false);
        int rightmost = NumberFormatter.fmtanalysis(formatter, useMonetary);
        CBoolean leaderprinted = new CBoolean(true);
        CBoolean trailerprinted = new CBoolean(true);
        CBoolean parprinted = new CBoolean(true);
        CBoolean minprinted = new CBoolean(true);
        CBoolean plusprinted = new CBoolean(true);
        CInteger sym_index = new CInteger(0);
        char[] signa = new char[8];
        NumberFormatter.chksigns(formatter, sym_index, parprinted, minprinted, leaderprinted, trailerprinted, plusprinted, signa);
        CCharArray p_source = new CCharArray();
        p_frmtIndex = NumberFormatter.align(firstDecCharLocation - 1, p_source, eedecpoint, p_frmt, p_frmtIndex, rightmost);
        char[] prstack = new char[AREASIZE];
        char lastchar = '\u0000';
        CInteger stack_index = new CInteger(0);
        char currentChar = p_frmt[p_frmtIndex];
        boolean isNegative = signum == -1;
        while (currentChar != '\u0000') {
            if (currentChar == ',' && p_source.ccharArray[p_source.ccharArrayIndex] == '\u0000') {
                p_frmt[p_frmtIndex] = lastchar;
                currentChar = lastchar;
            }
            switch (currentChar) {
                case ',': {
                    prstack[stack_index.value++] = locText.getSeparatorSymbol();
                    break;
                }
                case '.': {
                    char decimalSeparator = useMonetary.value ? locText.getMonetaryDecimalSeparator() : locText.getDecimalSymbol();
                    prstack[stack_index.value++] = decimalSeparator;
                    break;
                }
                case '<': {
                    NumberFormatter.leadingLT(p_source, prstack, stack_index);
                    break;
                }
                case '*': {
                    NumberFormatter.leadingNotLT(p_source, prstack, stack_index, '*');
                    break;
                }
                case '&': {
                    NumberFormatter.leadingNotLT(p_source, prstack, stack_index, '0');
                    break;
                }
                case '#': {
                    NumberFormatter.leadingNotLT(p_source, prstack, stack_index, ' ');
                    break;
                }
                case '-': {
                    NumberFormatter.prsigns(minprinted.value, p_source, prstack, sym_index, stack_index, signa, minprinted, plusprinted, parprinted, leaderprinted, trailerprinted, isNegative, locText);
                    break;
                }
                case '+': {
                    NumberFormatter.prsigns(plusprinted.value, p_source, prstack, sym_index, stack_index, signa, minprinted, plusprinted, parprinted, leaderprinted, trailerprinted, isNegative, locText);
                    break;
                }
                case '(': {
                    NumberFormatter.prsigns(parprinted.value, p_source, prstack, sym_index, stack_index, signa, minprinted, plusprinted, parprinted, leaderprinted, trailerprinted, isNegative, locText);
                    break;
                }
                case '$': {
                    NumberFormatter.prsigns(leaderprinted.value, p_source, prstack, sym_index, stack_index, signa, minprinted, plusprinted, parprinted, leaderprinted, trailerprinted, isNegative, locText);
                    break;
                }
                case '@': {
                    NumberFormatter.prsigns(trailerprinted.value, p_source, prstack, sym_index, stack_index, signa, minprinted, plusprinted, parprinted, leaderprinted, trailerprinted, isNegative, locText);
                    break;
                }
                case ')': {
                    prstack[stack_index.value++] = isNegative ? 41 : 32;
                    break;
                }
                default: {
                    prstack[stack_index.value++] = currentChar;
                }
            }
            lastchar = currentChar;
            currentChar = p_frmt[--p_frmtIndex];
        }
        char[] result = new char[AREASIZE];
        int len = NumberFormatter.rpfs(result, prstack, stack_index.value - 1, trailerprinted, leaderprinted, minprinted, plusprinted, parprinted, p_source);
        return new String(result, 0, len);
    }

    private static int deccvt(String number, int signum, int ndigit, char[] decstr) {
        CharSequence seq;
        int decpt = 0;
        int index = number.indexOf(46);
        if (index == -1) {
            StringBuilder buf = new StringBuilder(number.length() + 1 + ndigit);
            buf.append(number);
            buf.append('.');
            while (ndigit >= 50) {
                buf.append("00000000000000000000000000000000000000000000000000");
                ndigit -= 50;
            }
            if (ndigit > 0) {
                buf.append("00000000000000000000000000000000000000000000000000".substring(0, ndigit));
            }
            seq = buf;
        } else if (ndigit == 0) {
            seq = number.substring(0, index);
        } else {
            int decDigitsInNumber = number.length() - index - 1;
            if (decDigitsInNumber == ndigit) {
                seq = number;
            } else if (decDigitsInNumber < ndigit) {
                int zerosNeeded = ndigit - decDigitsInNumber;
                StringBuilder buf = new StringBuilder(number.length() + zerosNeeded);
                buf.append(number);
                while (zerosNeeded >= 50) {
                    buf.append("00000000000000000000000000000000000000000000000000");
                    zerosNeeded -= 50;
                }
                if (zerosNeeded > 0) {
                    buf.append("00000000000000000000000000000000000000000000000000".substring(0, zerosNeeded));
                }
                seq = buf;
            } else {
                seq = number.substring(0, number.length() - (decDigitsInNumber - ndigit));
            }
        }
        if (signum != 0) {
            int length;
            decpt = length = seq.length();
            int j = 0;
            int i = 0;
            while (i < length) {
                char c = seq.charAt(i);
                if (c == '.') {
                    decpt = i;
                } else {
                    decstr[j++] = c;
                }
                ++i;
            }
        }
        return decpt;
    }

    private static int fmtanalysis(char[] formatter, CBoolean useMonetary) {
        int i = 1;
        while (true) {
            switch (formatter[i]) {
                case '\u0000': {
                    return i;
                }
                case '$': 
                case '@': {
                    useMonetary.value = true;
                }
            }
            ++i;
        }
    }

    private static void chksigns(char[] formatter, CInteger sym_index, CBoolean parprinted, CBoolean minprinted, CBoolean leaderprinted, CBoolean trailerprinted, CBoolean plusprinted, char[] signa) {
        char c = formatter[1];
        int i = 2;
        while (c != '\u0000') {
            switch (c) {
                case '(': {
                    NumberFormatter.ldsigna('(', sym_index, signa);
                    parprinted.value = false;
                    break;
                }
                case '-': {
                    NumberFormatter.ldsigna('-', sym_index, signa);
                    minprinted.value = false;
                    break;
                }
                case '$': {
                    NumberFormatter.ldsigna('$', sym_index, signa);
                    leaderprinted.value = false;
                    break;
                }
                case '@': {
                    NumberFormatter.ldsigna('@', sym_index, signa);
                    trailerprinted.value = false;
                    break;
                }
                case '+': {
                    NumberFormatter.ldsigna('+', sym_index, signa);
                    plusprinted.value = false;
                }
            }
            c = formatter[i];
            ++i;
        }
    }

    private static int align(int decpoint_location, CCharArray p_source, CCharArray eedecpoint, char[] p_frmt, int p_frmtIndex, int rightmost) {
        if (decpoint_location >= 0) {
            p_source.ccharArray = eedecpoint.ccharArray;
            p_source.ccharArrayIndex = eedecpoint.ccharArrayIndex;
            p_frmtIndex = decpoint_location + 1;
            while (p_frmt[p_frmtIndex] != '\u0000') {
                if (p_source.ccharArray[p_source.ccharArrayIndex] == '\u0000') {
                    p_source.ccharArray[p_source.ccharArrayIndex] = 48;
                }
                switch (p_frmt[p_frmtIndex]) {
                    case '#': 
                    case '$': 
                    case '&': 
                    case '(': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '<': {
                        ++p_source.ccharArrayIndex;
                    }
                }
                ++p_frmtIndex;
            }
        } else {
            p_frmtIndex = rightmost;
            p_source.ccharArray = eedecpoint.ccharArray;
            p_source.ccharArrayIndex = eedecpoint.ccharArrayIndex;
        }
        --p_source.ccharArrayIndex;
        return p_frmtIndex - 1;
    }

    private static void leadingNotLT(CCharArray p_source, char[] prstack, CInteger stack_index, char fchar) {
        prstack[stack_index.value++] = p_source.ccharArray[p_source.ccharArrayIndex] == '\u0000' ? fchar : p_source.ccharArray[p_source.ccharArrayIndex--];
    }

    private static void leadingLT(CCharArray p_source, char[] prstack, CInteger stack_index) {
        if (p_source.ccharArray[p_source.ccharArrayIndex] != '\u0000') {
            prstack[stack_index.value++] = p_source.ccharArray[p_source.ccharArrayIndex--];
        }
    }

    private static void prsigns(boolean printed, CCharArray p_source, char[] prstack, CInteger sym_index, CInteger stack_index, char[] signa, CBoolean minprinted, CBoolean plusprinted, CBoolean parprinted, CBoolean leaderprinted, CBoolean trailerprinted, boolean isNegative, LocalizedText locText) {
        if (p_source.ccharArray[p_source.ccharArrayIndex] == '\u0000') {
            if (!printed) {
                --sym_index.value;
                switch (signa[sym_index.value]) {
                    case '-': {
                        NumberFormatter.prsi(prstack, stack_index, minprinted, '-', ' ', isNegative, ' ', locText);
                        break;
                    }
                    case '+': {
                        NumberFormatter.prsi(prstack, stack_index, plusprinted, '-', '+', isNegative, ' ', locText);
                        break;
                    }
                    case '(': {
                        NumberFormatter.prsi(prstack, stack_index, parprinted, '(', ' ', isNegative, ' ', locText);
                        break;
                    }
                    case '$': {
                        NumberFormatter.prsi(prstack, stack_index, leaderprinted, '$', '$', isNegative, ' ', locText);
                        break;
                    }
                    case '@': {
                        NumberFormatter.prsi(prstack, stack_index, trailerprinted, '@', '@', isNegative, ' ', locText);
                    }
                }
            } else {
                prstack[stack_index.value++] = 32;
            }
        } else if (!printed) {
            if (signa[sym_index.value - 1] == '@') {
                --sym_index.value;
                NumberFormatter.prsi(prstack, stack_index, trailerprinted, '@', '@', isNegative, ' ', locText);
            } else {
                prstack[stack_index.value++] = p_source.ccharArray[p_source.ccharArrayIndex--];
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int rpfs(char[] cp, char[] prstack, int prIndex, CBoolean trailerprinted, CBoolean leaderprinted, CBoolean minprinted, CBoolean plusprinted, CBoolean parprinted, CCharArray p_source) {
        block3: {
            cpIndex = 0;
            if (!trailerprinted.value || !leaderprinted.value || !minprinted.value || !plusprinted.value || !parprinted.value || p_source.ccharArray[p_source.ccharArrayIndex] != '\u0000') ** GOTO lbl13
            while (prIndex >= 0) {
                if (prstack[prIndex] == '\u0000') {
                    return cpIndex;
                }
                cp[cpIndex] = prstack[prIndex];
                ++cpIndex;
                --prIndex;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                cp[cpIndex++] = 42;
                --prIndex;
lbl13:
                // 2 sources

                ** while (prIndex >= 0)
            }
        }
        return cpIndex;
    }

    /*
     * Unable to fully structure code
     */
    private static void prsi(char[] prstack, CInteger stack_index, CBoolean printed, char neg, char pos, boolean isNegative, char fillchar, LocalizedText locText) {
        block13: {
            block9: {
                block12: {
                    block10: {
                        block11: {
                            if (printed.value) break block9;
                            if (neg != '$') break block10;
                            currencySymbol = locText.getCurrencySymbol();
                            len = currencySymbol.length();
                            if (len != 1) break block11;
                            prstack[stack_index.value++] = currencySymbol.charAt(0);
                            break block12;
                        }
                        if (len != 0) ** GOTO lbl13
                        prstack[stack_index.value++] = 32;
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            prstack[stack_index.value++] = currencySymbol.charAt(--len);
lbl13:
                            // 2 sources

                            ** while (len > 0)
                        }
lbl14:
                        // 1 sources

                        break block12;
                    }
                    if (neg == '@') {
                        currencySymbol = locText.getCurrencySymbol();
                        len = currencySymbol.length();
                        if (len == 1) {
                            NumberFormatter.pl(prstack, stack_index, currencySymbol.charAt(0));
                        } else if (len == 0) {
                            NumberFormatter.pl(prstack, stack_index, ' ');
                        } else {
                            i = 0;
                            while (i < len) {
                                NumberFormatter.pl(prstack, stack_index, currencySymbol.charAt(i));
                                ++i;
                            }
                        }
                    } else {
                        prstack[stack_index.value++] = isNegative != false ? neg : pos;
                    }
                }
                printed.value = true;
                break block13;
            }
            if (fillchar != '<') {
                prstack[stack_index.value++] = fillchar;
            }
        }
    }

    private static void pl(char[] prstack, CInteger stack_index, char c) {
        int index = stack_index.value;
        while (index > 0) {
            prstack[index--] = prstack[index];
        }
        prstack[index] = c;
        ++stack_index.value;
    }

    private static void ldsigna(char c, CInteger sym_index, char[] signa) {
        if (sym_index.value == 0 || c != signa[sym_index.value - 1]) {
            signa[sym_index.value++] = c;
        }
    }

    static class CBoolean {
        boolean value;

        public CBoolean(boolean value) {
            this.value = value;
        }
    }

    static class CCharArray {
        char[] ccharArray;
        int ccharArrayIndex;

        public CCharArray() {
        }

        public CCharArray(int ccharArraySize) {
            this.ccharArray = new char[ccharArraySize];
            this.ccharArrayIndex = 0;
        }
    }

    static class CInteger {
        int value;

        public CInteger(int value) {
            this.value = value;
        }
    }
}

