/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.TypeCastException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class EDate
extends AnyBoxedObject<Calendar> {
    private static final long serialVersionUID = 10L;

    public EDate() {
        this(DateTimeUtil.getNewCalendar());
    }

    public EDate(Calendar value) {
        super(value);
    }

    public static EDate ezeBox(Calendar value) {
        Calendar clone = null;
        if (value != null) {
            clone = ETimestamp.ezeClone(value, 0, 6);
        }
        return new EDate(clone);
    }

    public static Object ezeCast(Object value, Object[] constraints) throws AnyException {
        Object[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return EDate.ezeCast(value, args);
    }

    public static Calendar ezeCast(Object value) throws AnyException {
        return (Calendar)EAny.ezeCast(value, "asDate", EDate.class, null, null);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof EDate || value instanceof Calendar && !((Calendar)value).isSet(10) && !((Calendar)value).isSet(12) && !((Calendar)value).isSet(13) && !((Calendar)value).isSet(14);
    }

    public String toString() {
        return EString.asString((Calendar)this.object);
    }

    public static Calendar defaultValue() {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        int year = cal.get(1);
        int month = cal.get(2);
        int date = cal.get(5);
        cal.clear();
        cal.set(year, month, date);
        return cal;
    }

    public static Calendar asDate(EString date) throws TypeCastException {
        return EDate.asDate((String)date.ezeUnbox());
    }

    public static Calendar asDate(String date) throws TypeCastException {
        int years;
        int days;
        int months;
        block13: {
            if (date == null) {
                return null;
            }
            int length = date.length();
            if (length < 5 || length > 10) {
                TypeCastException tcx = new TypeCastException();
                tcx.actualTypeName = "string";
                tcx.castToName = "date";
                throw tcx.fillInMessage("EGL0007E", date, tcx.actualTypeName, tcx.castToName);
            }
            months = -1;
            days = -1;
            years = -1;
            char ch = date.charAt(0);
            if (ch >= '0' && ch <= '9') {
                int i;
                months = ch - 48;
                ch = date.charAt(1);
                if (ch < '0' || ch > '9') {
                    i = 2;
                } else {
                    months = months * 10 + ch - 48;
                    i = 3;
                }
                ch = date.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    days = ch - 48;
                    if ((ch = date.charAt(++i)) < '0' || ch > '9') {
                        ++i;
                    } else {
                        days = days * 10 + ch - 48;
                        i += 2;
                    }
                    ch = date.charAt(i);
                    if (ch >= '0' && ch <= '9') {
                        years = ch - 48;
                        ++i;
                        int digits = 0;
                        while (i < length && digits < 5) {
                            ch = date.charAt(i);
                            if (ch >= '0' && ch <= '9') {
                                years = years * 10 + ch - 48;
                                ++digits;
                                ++i;
                                continue;
                            }
                            break block13;
                        }
                        if (i < length) {
                            years = -1;
                        }
                    }
                }
            }
        }
        if (months == -1 || days == -1 || years == -1) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "date";
            throw tcx.fillInMessage("EGL0007E", date, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.clear();
        cal.set(1, years);
        cal.set(2, months - 1);
        cal.set(5, days);
        return cal;
    }

    public static Calendar asDate(EDate date) throws AnyException {
        if (date == null) {
            return null;
        }
        return EDate.asDate((Calendar)date.ezeUnbox());
    }

    public static Calendar asDate(ETimestamp date) throws AnyException {
        if (date == null) {
            return null;
        }
        return EDate.asDate((Calendar)date.ezeUnbox());
    }

    public static Calendar asDate(GregorianCalendar date) throws AnyException {
        if (date == null) {
            return null;
        }
        return EDate.asDate((Calendar)date);
    }

    public static Calendar asDate(Calendar date) throws AnyException {
        if (date == null) {
            return null;
        }
        return ETimestamp.convert(EString.asString(date), 0, 2);
    }

    public static int compareTo(Calendar op1, Calendar op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Calendar op1, Calendar op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(Calendar op1, Calendar op2) {
        if (op1 == null && op2 == null) {
            return false;
        }
        if (op1 == null || op2 == null) {
            return true;
        }
        return !op1.equals(op2);
    }

    public static int daysDifferent(Calendar aDate, Calendar bDate) throws AnyException {
        return (int)((aDate.getTimeInMillis() - bDate.getTimeInMillis()) / 86400000L);
    }

    public static Calendar addDays(Calendar aDate, int amount) throws AnyException {
        Calendar newDate = ETimestamp.ezeClone(aDate, 0, 6);
        newDate.setLenient(true);
        newDate.add(5, amount);
        newDate.setLenient(false);
        return newDate;
    }

    public static Calendar extend(Calendar aDate, String timeSpanPattern) throws AnyException {
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timeSpanPattern);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return (Calendar)new ETimestamp(ETimestamp.ezeClone(aDate, startCode, endCode), startCode, endCode).ezeUnbox();
    }
}

