/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.NumericOverflowException;
import eglx.lang.TypeCastException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.EString;

public class ESmallint
extends AnyBoxedObject<Short>
implements ENumber {
    private static final long serialVersionUID = 10L;
    private static final int precision = 4;

    private ESmallint(Short value) {
        super(value);
    }

    public static ESmallint ezeBox(Short value) {
        return new ESmallint(value);
    }

    public static Short ezeCast(Object value) throws AnyException {
        return (Short)EAny.ezeCast(value, "asSmallint", ESmallint.class, null, null);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof ESmallint || value instanceof Short;
    }

    public String toString() {
        return EString.asString((Short)this.object, new Integer[0]);
    }

    public static Short asSmallint(Short value) {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static Short asSmallint(ESmallint value) {
        if (value == null) {
            return null;
        }
        return (Short)value.ezeUnbox();
    }

    public static Short asSmallint(Integer value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value.intValue()).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Integer.valueOf(value).shortValue();
        }
        return result;
    }

    public static Short asSmallint(EInt value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(((Integer)value.ezeUnbox()).intValue()).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Integer.valueOf((Integer)value.ezeUnbox()).shortValue();
        }
        return result;
    }

    public static Short asSmallint(Long value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Long.valueOf(value).shortValue();
        }
        return result;
    }

    public static Short asSmallint(EBigint value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf((Long)value.ezeUnbox()).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Long.valueOf((Long)value.ezeUnbox()).shortValue();
        }
        return result;
    }

    public static Short asSmallint(Float value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value.floatValue()).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Float.valueOf(value.floatValue()).shortValue();
        }
        return result;
    }

    public static Short asSmallint(ESmallfloat value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(((Float)value.ezeUnbox()).floatValue()).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Float.valueOf(((Float)value.ezeUnbox()).floatValue()).shortValue();
        }
        return result;
    }

    public static Short asSmallint(Double value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Double.valueOf(value).shortValue();
        }
        return result;
    }

    public static Short asSmallint(EFloat value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf((Double)value.ezeUnbox()).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Double.valueOf((Double)value.ezeUnbox()).shortValue();
        }
        return result;
    }

    public static Short asSmallint(BigDecimal value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = value.shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = value.shortValue();
        }
        return result;
    }

    public static Short asSmallint(EDecimal value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = ((BigDecimal)value.ezeUnbox()).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = ((BigDecimal)value.ezeUnbox()).shortValue();
        }
        return result;
    }

    public static Short asSmallint(BigInteger value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = new BigDecimal(value).shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = value.shortValue();
        }
        return result;
    }

    public static Short asSmallint(Number value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = value.shortValue();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = value.shortValue();
        }
        return result;
    }

    public static Short asSmallint(ENumber value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        short result = 0;
        if (throwOverflowExceptions) {
            try {
                result = ((Number)value.ezeUnbox()).shortValue();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = ((Number)value.ezeUnbox()).shortValue();
        }
        return result;
    }

    public static Short asSmallint(String value) throws AnyException {
        if (value == null) {
            return null;
        }
        try {
            String input = value.charAt(0) == '+' ? value.substring(1) : value;
            return Short.valueOf(input);
        }
        catch (Exception exception) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "smallint";
            throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
        }
    }

    public static Short asSmallint(EString value) throws AnyException {
        if (value == null) {
            return null;
        }
        return ESmallint.asSmallint((String)value.ezeUnbox());
    }

    public static ESmallint asNumber(Short value) throws AnyException {
        if (value == null) {
            return null;
        }
        return ESmallint.ezeBox(value);
    }

    public static ESmallint asNumber(ESmallint value) throws AnyException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static int plus(short op1, short op2) throws AnyException {
        return op1 + op2;
    }

    public static int minus(short op1, short op2) throws AnyException {
        return op1 - op2;
    }

    public static BigDecimal divide(short op1, short op2) throws AnyException {
        return BigDecimal.valueOf(op1).divide(BigDecimal.valueOf(op2), 32, 4);
    }

    public static int multiply(short op1, short op2) throws AnyException {
        return op1 * op2;
    }

    public static int remainder(short op1, short op2) throws AnyException {
        return op1 % op2;
    }

    public static double power(short op1, short op2) throws AnyException {
        return StrictMath.pow(op1, op2);
    }

    public static int compareTo(Short op1, Short op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Short op1, Short op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.compareTo(op2) == 0;
    }

    public static boolean notEquals(Short op1, Short op2) {
        if (op1 == null && op2 == null) {
            return false;
        }
        if (op1 == null || op2 == null) {
            return true;
        }
        return op1.compareTo(op2) != 0;
    }

    public int precision() {
        return 4;
    }
}

