/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.lang.TypeCastException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EString;

public class ETimestamp
extends AnyBoxedObject<Calendar> {
    private static final long serialVersionUID = 10L;
    public static final String DefaultPattern = "yyyyMMddHHmmss";
    public static final String DefaultFormatPattern = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final int YEAR_CODE = 0;
    public static final int MONTH_CODE = 1;
    public static final int DAY_CODE = 2;
    public static final int HOUR_CODE = 3;
    public static final int MINUTE_CODE = 4;
    public static final int SECOND_CODE = 5;
    public static final int FRACTION1_CODE = 6;
    public static final int FRACTION2_CODE = 7;
    public static final int FRACTION3_CODE = 8;
    public static final int FRACTION4_CODE = 9;
    public static final int FRACTION5_CODE = 10;
    public static final int FRACTION6_CODE = 11;
    private int startCode;
    private int endCode;

    public ETimestamp() {
        this(DateTimeUtil.getNewCalendar(), 0, 5);
    }

    public ETimestamp(Calendar value, int startCode, int endCode) {
        super(value);
        this.startCode = startCode;
        this.endCode = endCode;
    }

    public static ETimestamp ezeBox(Calendar value, int startCode, int endCode) {
        Calendar clone = null;
        if (value != null) {
            clone = ETimestamp.ezeClone(value, startCode, endCode);
        }
        return new ETimestamp(clone, startCode, endCode);
    }

    public static ETimestamp ezeBox(Calendar value) {
        return ETimestamp.ezeBox(value, 0, 11);
    }

    public static Object ezeCast(Object value, Object[] constraints) throws AnyException {
        Integer[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return ETimestamp.ezeCast(value, args);
    }

    public static Calendar ezeCast(Object value, Integer ... args) throws AnyException {
        return (Calendar)EAny.ezeCast(value, "asTimestamp", ETimestamp.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... args) {
        boolean isa = value instanceof ETimestamp;
        if (isa) {
            if (args.length == 2) {
                isa = ((ETimestamp)value).startCode == args[0] && ((ETimestamp)value).endCode == args[1];
            }
        } else {
            isa = value instanceof Calendar;
        }
        return isa;
    }

    public String toString() {
        return EString.asString((Calendar)this.object);
    }

    public static Calendar ezeClone(Calendar original, int startCode, int endCode) {
        if (original == null) {
            return null;
        }
        boolean yearSet = original.isSet(1);
        boolean monthSet = original.isSet(2);
        boolean dateSet = original.isSet(5);
        boolean hourSet = original.isSet(11);
        boolean minuteSet = original.isSet(12);
        boolean secondSet = original.isSet(13);
        boolean milliSet = original.isSet(14);
        int yearValue = original.get(1);
        int monthValue = original.get(2);
        int dateValue = original.get(5);
        int hourValue = original.get(11);
        int minuteValue = original.get(12);
        int secondValue = original.get(13);
        int milliValue = original.get(14);
        Calendar cloned = ETimestamp.defaultValue();
        cloned.clear();
        if (startCode <= 0 && endCode >= 0 && yearSet) {
            cloned.set(1, yearValue);
        }
        if (startCode <= 1 && endCode >= 1 && monthSet) {
            cloned.set(2, monthValue);
        }
        if (startCode <= 2 && endCode >= 2 && dateSet) {
            cloned.set(5, dateValue);
        }
        if (startCode <= 3 && endCode >= 3 && hourSet) {
            cloned.set(11, hourValue);
        }
        if (startCode <= 4 && endCode >= 4 && minuteSet) {
            cloned.set(12, minuteValue);
        }
        if (startCode <= 5 && endCode >= 5 && secondSet) {
            cloned.set(13, secondValue);
        }
        if (startCode <= 6 && endCode >= 6 && milliSet) {
            cloned.set(14, milliValue);
        }
        cloned.getTimeInMillis();
        original.clear();
        if (yearSet) {
            original.set(1, yearValue);
        }
        if (monthSet) {
            original.set(2, monthValue);
        }
        if (dateSet) {
            original.set(5, dateValue);
        }
        if (hourSet) {
            original.set(11, hourValue);
        }
        if (minuteSet) {
            original.set(12, minuteValue);
        }
        if (secondSet) {
            original.set(13, secondValue);
        }
        if (milliSet) {
            original.set(14, milliValue);
        }
        original.getTimeInMillis();
        return cloned;
    }

    public static Calendar asTimestamp(EDate timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox());
    }

    public static Calendar asTimestamp(ETimestamp timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox());
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp);
    }

    public static Calendar asTimestamp(Calendar timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp(timestamp, DefaultPattern);
    }

    public static Calendar asTimestamp(EDate timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), timespanMask);
    }

    public static Calendar asTimestamp(ETimestamp timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), timespanMask);
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp, timespanMask);
    }

    public static Calendar asTimestamp(Calendar timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        if (timespanMask == null || timespanMask.length() == 0) {
            timespanMask = DefaultPattern;
        }
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timespanMask);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(timestamp, startCode, endCode);
    }

    public static Calendar asTimestamp(EString timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((String)timestamp.ezeUnbox(), args);
    }

    public static Calendar asTimestamp(String timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        if (args != null && args.length == 2) {
            return ETimestamp.convert(timestamp, args[0], args[1]);
        }
        return ETimestamp.asTimestamp(timestamp, DefaultPattern);
    }

    public static Calendar asTimestamp(EString timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((String)timestamp.ezeUnbox(), timespanMask);
    }

    public static Calendar asTimestamp(String timestamp, String timespanMask) throws AnyException {
        if (timestamp == null || timespanMask == null) {
            return null;
        }
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timespanMask);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.convert(timestamp, startCode, endCode);
    }

    public static Calendar asTimestamp(EDate timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), args);
    }

    public static Calendar asTimestamp(ETimestamp timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), args);
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp, args);
    }

    public static Calendar asTimestamp(Calendar date, Integer ... args) {
        if (date == null) {
            return null;
        }
        if (args == null) {
            return ETimestamp.asTimestamp(date, 0, 5);
        }
        return ETimestamp.asTimestamp(date, (int)args[0], (int)args[1]);
    }

    public static Calendar asTimestamp(EDate timestamp, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), startCode, endCode);
    }

    public static Calendar asTimestamp(ETimestamp timestamp, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), startCode, endCode);
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp, startCode, endCode);
    }

    public static Calendar asTimestamp(Calendar original, int startCode, int endCode) {
        if (original == null) {
            return null;
        }
        Calendar date = ETimestamp.ezeClone(original, 0, 6);
        Calendar result = DateTimeUtil.getBaseCalendar();
        Calendar forDefaults = null;
        if (startCode <= 0 && endCode >= 0) {
            if (date.isSet(1)) {
                result.set(1, date.get(1));
            } else {
                if (forDefaults == null) {
                    forDefaults = DateTimeUtil.getNewCalendar();
                }
                result.set(1, forDefaults.get(1));
            }
        }
        if (startCode <= 1 && endCode >= 1) {
            if (date.isSet(2)) {
                result.set(2, date.get(2));
            } else {
                if (forDefaults == null) {
                    forDefaults = DateTimeUtil.getNewCalendar();
                }
                result.set(2, forDefaults.get(2));
            }
        }
        if (startCode <= 2 && endCode >= 2) {
            if (date.isSet(5)) {
                result.set(5, date.get(5));
            } else {
                if (forDefaults == null) {
                    forDefaults = DateTimeUtil.getNewCalendar();
                }
                result.set(5, forDefaults.get(5));
            }
        }
        if (startCode <= 3 && endCode >= 3) {
            if (date.isSet(11)) {
                result.set(11, date.get(11));
            } else {
                if (forDefaults == null) {
                    forDefaults = DateTimeUtil.getNewCalendar();
                }
                result.set(11, forDefaults.get(11));
            }
        }
        if (startCode <= 4 && endCode >= 4) {
            if (date.isSet(12)) {
                result.set(12, date.get(12));
            } else {
                if (forDefaults == null) {
                    forDefaults = DateTimeUtil.getNewCalendar();
                }
                result.set(12, forDefaults.get(12));
            }
        }
        if (startCode <= 5 && endCode >= 5) {
            if (date.isSet(13)) {
                result.set(13, date.get(13));
            } else {
                if (forDefaults == null) {
                    forDefaults = DateTimeUtil.getNewCalendar();
                }
                result.set(13, forDefaults.get(13));
            }
        }
        if (startCode <= 6 && endCode >= 6) {
            if (date.isSet(14)) {
                result.set(14, date.get(14));
            } else {
                if (forDefaults == null) {
                    forDefaults = DateTimeUtil.getNewCalendar();
                }
                result.set(14, forDefaults.get(14));
            }
        }
        return result;
    }

    public static Calendar asTimestamp(EString timestamp, String format, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((String)timestamp.ezeUnbox(), format, startCode, endCode);
    }

    public static Calendar asTimestamp(String timestamp, String format, int startCode, int endCode) throws AnyException {
        Calendar result;
        if (timestamp == null) {
            return null;
        }
        timestamp = timestamp.trim();
        try {
            result = ETimestamp.convert(timestamp, format);
        }
        catch (ParseException parseException) {
            result = ETimestamp.convert(timestamp, startCode, endCode);
        }
        return result;
    }

    public static int compareTo(Calendar op1, Calendar op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Calendar op1, Calendar op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(Calendar op1, Calendar op2) {
        if (op1 == null && op2 == null) {
            return false;
        }
        if (op1 == null || op2 == null) {
            return true;
        }
        return !op1.equals(op2);
    }

    public static Calendar convert(String timestamp, int startCode, int endCode) {
        int microseconds;
        int seconds;
        int minutes;
        int hours;
        int days;
        int months;
        int years;
        block31: {
            char ch;
            int i;
            int length;
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                years = -1;
                                months = -1;
                                days = -1;
                                hours = -1;
                                minutes = -1;
                                seconds = -1;
                                microseconds = -1;
                                length = timestamp.length();
                                if (length <= 0) break block31;
                                i = 0;
                                do {
                                    ch = timestamp.charAt(i);
                                } while (++i < length && ('0' > ch || ch > '9'));
                                if (i <= length && startCode == 0) {
                                    years = 0;
                                    int j = 0;
                                    while ('0' <= ch && ch <= '9' && j < 4) {
                                        years = years * 10 + ch - 48;
                                        if (i < length) {
                                            ch = timestamp.charAt(i);
                                            ++i;
                                            ++j;
                                            continue;
                                        }
                                        break block31;
                                    }
                                }
                                while (i < length && ('0' > ch || ch > '9')) {
                                    ch = timestamp.charAt(i);
                                    ++i;
                                }
                                if (i > length || startCode > 1 || endCode < 1) break block32;
                                months = ch - 48;
                                if (i >= length) break block31;
                                ch = timestamp.charAt(i);
                                ++i;
                                if ('0' > ch || ch > '9') break block32;
                                months = months * 10 + ch - 48;
                                if (i >= length) break block31;
                                ch = timestamp.charAt(i);
                                ++i;
                            }
                            while (i < length && ('0' > ch || ch > '9')) {
                                ch = timestamp.charAt(i);
                                ++i;
                            }
                            if (i > length || startCode > 2 || endCode < 2) break block33;
                            days = ch - 48;
                            if (i >= length) break block31;
                            ch = timestamp.charAt(i);
                            ++i;
                            if ('0' > ch || ch > '9') break block33;
                            days = days * 10 + ch - 48;
                            if (i >= length) break block31;
                            ch = timestamp.charAt(i);
                            ++i;
                        }
                        while (i < length && ('0' > ch || ch > '9')) {
                            ch = timestamp.charAt(i);
                            ++i;
                        }
                        if (i > length || startCode > 3 || endCode < 3) break block34;
                        hours = ch - 48;
                        if (i >= length) break block31;
                        ch = timestamp.charAt(i);
                        ++i;
                        if ('0' > ch || ch > '9') break block34;
                        hours = hours * 10 + ch - 48;
                        if (i >= length) break block31;
                        ch = timestamp.charAt(i);
                        ++i;
                    }
                    while (i < length && ('0' > ch || ch > '9')) {
                        ch = timestamp.charAt(i);
                        ++i;
                    }
                    if (i > length || startCode > 4 || endCode < 4) break block35;
                    minutes = ch - 48;
                    if (i >= length) break block31;
                    ch = timestamp.charAt(i);
                    ++i;
                    if ('0' > ch || ch > '9') break block35;
                    minutes = minutes * 10 + ch - 48;
                    if (i >= length) break block31;
                    ch = timestamp.charAt(i);
                    ++i;
                }
                while (i < length && ('0' > ch || ch > '9')) {
                    ch = timestamp.charAt(i);
                    ++i;
                }
                if (i > length || startCode > 5 || endCode < 5) break block36;
                seconds = ch - 48;
                if (i >= length) break block31;
                ch = timestamp.charAt(i);
                ++i;
                if ('0' > ch || ch > '9') break block36;
                seconds = seconds * 10 + ch - 48;
                if (i >= length) break block31;
                ch = timestamp.charAt(i);
                ++i;
            }
            while (i < length && ('0' > ch || ch > '9')) {
                ch = timestamp.charAt(i);
                ++i;
            }
            if (i <= length && endCode >= 6) {
                microseconds = 0;
                int microsecondsFound = 0;
                int fractionDigits = endCode - 6 + 1;
                while (microsecondsFound < fractionDigits && '0' <= ch && ch <= '9') {
                    microseconds *= 10;
                    microseconds += ch - 48;
                    ++microsecondsFound;
                    if (i >= length) break;
                    ch = timestamp.charAt(i);
                    ++i;
                }
                if (microsecondsFound < 6) {
                    int j = microsecondsFound;
                    while (j < 6) {
                        microseconds *= 10;
                        ++j;
                    }
                }
            }
        }
        if (years == -1 && startCode == 0 || months == -1 && startCode <= 1 && endCode >= 1 || days == -1 && startCode <= 2 && endCode >= 2 || hours == -1 && startCode <= 3 && endCode >= 3 || minutes == -1 && startCode <= 4 && endCode >= 4 || seconds == -1 && startCode <= 5 && endCode >= 5 || microseconds == -1 && endCode >= 6) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "timestamp";
            throw tcx.fillInMessage("EGL0007E", timestamp, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = DateTimeUtil.getBaseCalendar();
        if (years != -1) {
            cal.set(1, years);
        }
        if (months != -1) {
            cal.set(2, months - 1);
        }
        if (days != -1) {
            cal.set(5, days);
        } else if (months != -1) {
            cal.set(5, 1);
        }
        if (hours != -1) {
            cal.set(11, hours);
        }
        if (minutes != -1) {
            cal.set(12, minutes);
        }
        if (seconds != -1) {
            cal.set(13, seconds);
        }
        if (microseconds != -1) {
            cal.set(14, microseconds / 1000);
        }
        try {
            cal.getTimeInMillis();
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "timestamp";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", timestamp, tcx.actualTypeName, tcx.castToName);
        }
        Calendar result = cal;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar convert(String timestamp, String format) throws ParseException {
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
            formatter.setMicrosecond(0);
            Date date = formatter.parse(timestamp);
            Calendar cal = DateTimeUtil.getBaseCalendar();
            cal.setTime(date);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cal;
        }
    }

    public static String createPattern(int startCode, int endCode) {
        if (startCode > endCode) {
            return null;
        }
        String[] code = new String[]{"yyyy", "MM", "dd", "HH", "mm", "ss", "SSSSSS"};
        String[] delimiters = new String[]{"-", "-", " ", ":", ":", "."};
        int sindex = startCode > 6 ? 6 : startCode;
        int eindex = endCode > 6 ? 6 : endCode;
        StringBuilder patternString = new StringBuilder(26);
        int i = sindex;
        int j = 0;
        while (i <= eindex) {
            if (j > 0) {
                patternString.append(delimiters[i - 1]);
            }
            patternString.append(code[i]);
            ++i;
            ++j;
        }
        return patternString.toString();
    }

    public static Calendar defaultValue() {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        int year = cal.get(1);
        int month = cal.get(2);
        int date = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        cal.clear();
        cal.set(year, month, date, hour, minute, second);
        return cal;
    }

    public static Calendar defaultValue(int startCode, int endCode) {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        int year = cal.get(1);
        int month = cal.get(2);
        int date = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int fraction = cal.get(14);
        cal.clear();
        if (startCode <= 0 && endCode >= 0) {
            cal.set(1, year);
        }
        if (startCode <= 1 && endCode >= 1) {
            cal.set(2, month);
        }
        if (startCode <= 2 && endCode >= 2) {
            cal.set(5, date);
        }
        if (startCode <= 3 && endCode >= 3) {
            cal.set(11, hour);
        }
        if (startCode <= 4 && endCode >= 4) {
            cal.set(12, minute);
        }
        if (startCode <= 5 && endCode >= 5) {
            cal.set(13, second);
        }
        if (startCode <= 6 && endCode >= 6) {
            cal.set(14, fraction);
        }
        return ETimestamp.asTimestamp(cal, startCode, endCode);
    }

    public static int dayOf(Calendar original) throws AnyException {
        Calendar aTimestamp = ETimestamp.ezeClone(original, 0, 6);
        if (!aTimestamp.isSet(5)) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "dayOf", "dd");
        }
        return aTimestamp.get(5);
    }

    public static int monthOf(Calendar original) throws AnyException {
        Calendar aTimestamp = ETimestamp.ezeClone(original, 0, 6);
        if (!aTimestamp.isSet(2)) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "monthOf", "MM");
        }
        return aTimestamp.get(2) + 1;
    }

    public static int yearOf(Calendar original) throws AnyException {
        Calendar aTimestamp = ETimestamp.ezeClone(original, 0, 6);
        if (!aTimestamp.isSet(1)) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "yearOf", "yyyy");
        }
        return aTimestamp.get(1);
    }

    public static int weekdayOf(Calendar original) throws AnyException {
        Calendar aTimestamp = ETimestamp.ezeClone(original, 0, 6);
        if (!aTimestamp.isSet(2)) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "weekdayOf", "dd");
        }
        return aTimestamp.get(7) - 1;
    }

    public static Calendar dateOf(Calendar original) throws AnyException {
        Calendar aTimestamp = ETimestamp.ezeClone(original, 0, 6);
        if (!(aTimestamp.isSet(1) && aTimestamp.isSet(2) && aTimestamp.isSet(5))) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "dateOf", "yyyyMMdd");
        }
        return (Calendar)new ETimestamp(ETimestamp.ezeClone(aTimestamp, 0, 2), 0, 2).ezeUnbox();
    }

    public static Calendar timeOf(Calendar original) throws AnyException {
        Calendar aTimestamp = ETimestamp.ezeClone(original, 0, 6);
        if (!(aTimestamp.isSet(11) && aTimestamp.isSet(12) && aTimestamp.isSet(13))) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "timeOf", "HHmmss");
        }
        return (Calendar)new ETimestamp(ETimestamp.ezeClone(aTimestamp, 3, 5), 3, 5).ezeUnbox();
    }

    public static Calendar extend(Calendar aTimestamp, String timeSpanPattern) throws AnyException {
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timeSpanPattern);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return (Calendar)new ETimestamp(ETimestamp.ezeClone(aTimestamp, startCode, endCode), startCode, endCode).ezeUnbox();
    }
}

