/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.edt.compiler.internal.util.Encoder;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.Parameter;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;

public class ConvertWorkspaceResourceOperation
extends AbstractDeploymentOperation {
    public static final String SEPERATOR = ";";
    private String targetProjectName;
    private DeploymentDesc ddModel;
    private DeploymentContext context;

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        this.context = context;
        this.ddModel = context.getDeploymentDesc();
        ProfileManager.getInstance().getProfiles();
        for (Binding binding : this.ddModel.getBindings()) {
            IConnectionProfile profile;
            SQLDatabaseBinding sqlBinding;
            if (!(binding instanceof SQLDatabaseBinding) || !(sqlBinding = (SQLDatabaseBinding)binding).isUseURI() && sqlBinding.getUri() == null || (profile = ProfileManager.getInstance().getProfileByName(sqlBinding.getUri().substring(12))) == null) continue;
            sqlBinding.addParameter(new Parameter("dbms", String.valueOf(EGLSQLUtility.getSQLVendorProperty((IConnectionProfile)profile)) + " " + EGLSQLUtility.getSQLProductVersion((IConnectionProfile)profile)));
            sqlBinding.addParameter(new Parameter("sqlJDBCDriverClass", EGLSQLUtility.getSQLJDBCDriverClassPreference((IConnectionProfile)profile)));
            sqlBinding.addParameter(new Parameter("jarList", EGLSQLUtility.getLoadingPath((IConnectionProfile)profile)));
            sqlBinding.addParameter(new Parameter("sqlID", EGLSQLUtility.getSQLUserId((IConnectionProfile)profile)));
            sqlBinding.addParameter(new Parameter("sqlPassword", Encoder.encode((String)EGLSQLUtility.getSQLPassword((IConnectionProfile)profile))));
            sqlBinding.addParameter(new Parameter("sqlDB", EGLSQLUtility.getSQLConnectionURLPreference((IConnectionProfile)profile)));
            sqlBinding.addParameter(new Parameter("sqlSchema", EGLSQLUtility.getDefaultSchema((IConnectionProfile)profile)));
            sqlBinding.setUseURI(false);
        }
    }
}

