/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.deployment.util;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class PartReferenceCache {
    private Map<String, Set<Part>> cache;
    private IEnvironment sysIREnv = null;

    public PartReferenceCache(IEnvironment env) {
        this.sysIREnv = env;
        this.cache = new HashMap<String, Set<Part>>();
    }

    public Set<Part> getReferencedPartsFor(Part part) {
        Set<Part> parts = this.cache.get(part.getFullyQualifiedName());
        if (parts == null) {
            parts = new LinkedHashSet<Part>();
            this.getReferencedParts(part, parts);
            parts.remove(part);
            this.cache.put(part.getFullyQualifiedName(), parts);
        }
        return parts;
    }

    private void getReferencedParts(Part part, Set<Part> allParts) {
        if (allParts.contains(part)) {
            if (part instanceof ExternalType) {
                allParts.remove(part);
            } else {
                return;
            }
        }
        allParts.add(part);
        for (Part refPart : IRUtils.getReferencedPartsFor((Part)part)) {
            if (IRUtils.isSystemPart((String)refPart.getFullyQualifiedName(), (IEnvironment)this.sysIREnv)) continue;
            this.getReferencedParts(refPart, allParts);
        }
    }
}

