/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.deployment.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;

public class WorkingCopyGenerationResult
implements IProblemRequestor,
ISyntaxErrorRequestor,
IGenerationMessageRequestor {
    private boolean hasError = false;
    private boolean sendMessagesToGenerationResultsServer;
    private List genMessages = Collections.EMPTY_LIST;
    private int numGenErrors;
    private int numGenWarnings;
    private static final Set EGLMESSAGESTOIGNORE = new HashSet<String>(Arrays.asList("9994"));

    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
        if (severity == 2) {
            this.hasError = true;
        }
    }

    public void acceptProblem(Node astNode, int problemKind) {
        this.hasError = true;
    }

    public void acceptProblem(Node astNode, int problemKind, int severity) {
        if (severity == 2) {
            this.hasError = true;
        }
    }

    public void acceptProblem(Node astNode, int problemKind, String[] inserts) {
        this.hasError = true;
    }

    public void acceptProblem(Node astNode, int problemKind, int severity, String[] inserts) {
        if (severity == 2) {
            this.hasError = true;
        }
    }

    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind) {
        if (severity == 2) {
            this.hasError = true;
        }
    }

    public void acceptProblem(int startOffset, int endOffset, int problemKind, String[] inserts) {
        this.hasError = true;
    }

    public void acceptProblem(int startOffset, int endOffset, int problemKind, boolean isError, String[] inserts) {
        if (isError) {
            this.hasError = true;
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean shouldReportProblem(int problemKind) {
        return false;
    }

    public void incorrectNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void incorrectPhrase(int nonTerminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void incorrectPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void incorrectPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void incorrectTerminal(int terminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void invalidCharacterInHexLiteral(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void invalidEscapeSequence(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void keywordAsName(int terminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void missingEndForPart(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void missingNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void missingPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void missingPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void missingScopeCloser(int terminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void missingTerminal(int terminalType, int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void panicPhrase(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void tooManyErrors() {
        this.hasError = true;
    }

    public void unclosedBlockComment(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void unclosedDLI(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void unclosedSQL(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void unclosedSQLCondition(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void unclosedString(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void unexpectedPhrase(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void unexpectedPreviousTerminal(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void unexpectedTerminal(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void whitespaceInDLI(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void whitespaceInSQL(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void whitespaceInSQLCondition(int startOffset, int endOffset) {
        this.hasError = true;
    }

    public void addMessage(IGenerationResultsMessage message) {
        if (!EGLMESSAGESTOIGNORE.contains(message.getId())) {
            if (message.isError()) {
                this.hasError = true;
            }
            if (this.genMessages == Collections.EMPTY_LIST) {
                this.genMessages = new ArrayList();
            }
            this.genMessages.add(message);
            if (message.isError() && !"9997".equals(message.getId())) {
                ++this.numGenErrors;
            } else if (message.isWarning()) {
                ++this.numGenWarnings;
            }
        }
    }

    public void addMessages(List<IGenerationResultsMessage> newmsgs) {
        for (EGLMessage eGLMessage : newmsgs) {
            this.addMessage((IGenerationResultsMessage)eGLMessage);
        }
    }

    public List getMessages() {
        return this.genMessages;
    }

    public int getNumGenErrors() {
        return this.numGenErrors;
    }

    public int getNumGenWarnings() {
        return this.numGenWarnings;
    }

    public boolean isError() {
        return this.hasError;
    }

    public void clear() {
        this.hasError = false;
        this.genMessages = Collections.EMPTY_LIST;
        this.numGenWarnings = 0;
        this.numGenErrors = 0;
    }

    public boolean hasGenerationError() {
        return this.genMessages.size() > 0;
    }

    public void setHasError(boolean error) {
        this.hasError = error;
    }

    public void sendMessagesToGenerationResultsServer(boolean bool) {
        this.sendMessagesToGenerationResultsServer = bool;
    }
}

