/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.api;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;

public class TabbedReportWriter
extends TabbedWriter {
    public TabbedWriter rpt = new TabbedWriter(new StringWriter());
    private String qualifier = null;

    public TabbedReportWriter(String templateQualifier, Writer writer) {
        super(writer);
        this.qualifier = templateQualifier;
        this.rpt.println("<html><head><style>a.info{    position:relative; /*this is the key*/    z-index:24; /* background-color:#ccc; */    color:#111;    text-decoration:none}a.info:hover{z-index:25; background-color:#ff0}a.info > span{display: none}a.info:hover > span{ /*the span will display just on :hover state*/    display:block;    position:absolute;    top:2em; left:2em; /* width:15em; */    margin:0px;    padding:3px;    border:1px solid rgb(119,119,0);    border-radius: 10px;  -moz-border-radius: 10px;    -moz-box-shadow: 10px 10px 5px rgba(50,50,75,0.8);    -webkit-box-shadow: 10px 10px 5px rgba(50,50,75,0.8);    box-shadow: 10px 10px 5px rgba(50,50,75,0.8);    background-color:rgb(255,255,185);    color:#000;    color:#333;    text-align: left}a > span > span:first-child{font-weight:bold;}a > span > span:nth-child(n+2){padding-left:2em;}</style><title>Gen Report</title></head><body style=\"background-color:#ddd;\"><pre>");
    }

    public String[] getStack() {
        String[] result = new String[2];
        try {
            StringBuffer templateStack = new StringBuffer();
            StackTraceElement[] stackTrace = new Throwable().fillInStackTrace().getStackTrace();
            if (stackTrace.length > 0) {
                templateStack.append("<span>");
            }
            boolean first = true;
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (stackTraceElement.getClassName().startsWith(this.qualifier)) {
                    StackTraceElement element = stackTraceElement;
                    String cname = element.getClassName();
                    if (first) {
                        result[0] = String.valueOf(cname.substring(cname.lastIndexOf(46) + 1)) + "." + element.getMethodName() + ":" + element.getLineNumber();
                        first = false;
                    }
                    templateStack.append("<span>" + cname.substring(cname.lastIndexOf(46) + 1) + "." + element.getMethodName() + ":" + element.getLineNumber() + "</span><br>");
                }
                ++n2;
            }
            if (stackTrace.length > 0) {
                templateStack.append("</span>");
            }
            result[1] = templateStack.length() == 0 ? null : templateStack.toString();
        }
        catch (Exception exception) {
            result = new String[2];
        }
        return result;
    }

    @Override
    public void print(char c) {
        super.print(c);
        String[] stack = this.getStack();
        String stackLoc = stack[0];
        if (stackLoc != null) {
            this.rpt.print("<a  class=info href=\"" + stackLoc + "\">");
        }
        this.rpt.print(TabbedReportWriter.escHTML(new char[]{c}));
        if (stackLoc != null) {
            this.rpt.print(stack[1]);
        }
    }

    @Override
    public void print(char[] chars) {
        super.print(chars);
        String[] stack = this.getStack();
        String stackLoc = stack[0];
        if (stackLoc != null) {
            this.rpt.print("<a  class=info href=\"" + stackLoc + "\">");
        }
        this.rpt.print(TabbedReportWriter.escHTML(chars));
        if (stackLoc != null) {
            this.rpt.print(stack[1]);
        }
    }

    private static String escHTML(char[] chars) {
        StringBuilder b = new StringBuilder();
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++n2;
        }
        return b.toString();
    }

    @Override
    public void close() {
        super.close();
        this.rpt.close();
    }

    @Override
    public void flush() {
        super.flush();
        this.rpt.flush();
    }
}

