/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization.xml;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EMemberContainer;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.impl.DynamicEClass;
import org.eclipse.edt.mof.serialization.SerializationException;
import org.eclipse.edt.mof.serialization.Serializer;
import org.eclipse.edt.mof.utils.TabbedWriter;

public class XMLSerializer
implements Serializer {
    private static final String XMLHeader = "<?xml version=\"1.1\" encoding=\"iso-8859-1\"?>";
    MofFactory mof = MofFactory.INSTANCE;
    Map<EObject, Integer> written = new HashMap<EObject, Integer>();
    TabbedWriter writer = new TabbedWriter(new StringWriter());
    String tabs = "";
    int currentId = 1;

    @Override
    public void serialize(EObject object) throws SerializationException {
        this.writer.println(XMLHeader);
        this.writeObject(object);
    }

    @Override
    public String getContents() {
        this.writer.flush();
        return this.writer.getWriter().toString();
    }

    private boolean isAttributeField(EField field, Object value) {
        return !(value instanceof EObject) && !(value instanceof List) || value instanceof EEnumLiteral || this.isTypeReferenceField(field);
    }

    private boolean isList(EField field) {
        return field.getEType().getEClassifier() == MofFactory.INSTANCE.getEListEDataType();
    }

    private boolean isTypeReferenceField(EField field) {
        MofFactory mof;
        EType type = field.getEType();
        return type == (mof = MofFactory.INSTANCE).getMofReferenceTypeClass() || type instanceof EClass && ((EClass)type).isSubClassOf(mof.getMofReferenceTypeClass());
    }

    private String xmlEncode(String in) {
        StringBuffer buffer = new StringBuffer();
        char[] cArray = in.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            switch (c.charValue()) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case ',': {
                    buffer.append("&#44;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '\b': {
                    buffer.append("&#08;");
                    break;
                }
                case '\t': {
                    buffer.append("&#09;");
                    break;
                }
                case '\n': {
                    buffer.append("&#10;");
                    break;
                }
                case '\f': {
                    buffer.append("&#12;");
                    break;
                }
                case '\r': {
                    buffer.append("&#13;");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++n2;
        }
        return buffer.toString();
    }

    private void writeObject(Object object) {
        if (object instanceof EEnumLiteral) {
            this.writer.print(((EEnumLiteral)object).getName());
            return;
        }
        if (object instanceof EObject) {
            if (this.written.containsKey(object)) {
                this.writeObjectReference(null, (EObject)object);
            } else {
                this.writeEObjectValue(null, (EObject)object);
            }
            return;
        }
        if (object instanceof String || object instanceof Integer || object instanceof Boolean || object instanceof Float || object instanceof BigDecimal) {
            this.writer.print(this.xmlEncode(object.toString()));
            return;
        }
        if (object instanceof Object[]) {
            this.writeObjectArray((Object[])object);
            return;
        }
        if (object instanceof Enum) {
            this.writer.print(((Enum)object).name());
            return;
        }
    }

    void writeEObjectValue(EField target, EObject object) {
        Object value;
        if (target != null && target.isTransient()) {
            return;
        }
        if (target != null && !target.getContainment()) {
            this.writeObjectReference(target, object);
            return;
        }
        String elementName = target == null ? object.getEClass().getName() : target.getName();
        this.writeElementStart(elementName, object);
        List<EField> fields = object.getEClass().getAllEFields();
        for (EField field : fields) {
            Object value2 = object.eGet(field);
            if (value2 == null || !this.isAttributeField(field, value2) || field.isTransient()) continue;
            if (this.isTypeReferenceField(field)) {
                value2 = ((MofSerializable)value2).getMofSerializationKey();
            }
            this.writeAttributeValue(field, value2);
        }
        ArrayList<EField> elements = new ArrayList<EField>();
        for (EField f : fields) {
            value = object.eGet(f);
            if (f.isTransient() || this.isAttributeField(f, value) || value instanceof List && ((List)value).isEmpty()) continue;
            elements.add(f);
        }
        if (elements.isEmpty()) {
            this.writer.println("/>");
        } else {
            this.writer.println('>');
            this.writer.pushIndent();
            for (EField field : elements) {
                value = object.eGet(field);
                if (value == null) continue;
                if (this.isList(field)) {
                    this.writeListValue(field, (List)value);
                    continue;
                }
                if (value instanceof EObject) {
                    if (field.getContainment()) {
                        this.writeEObjectValue(field, (EObject)value);
                        continue;
                    }
                    this.writeObjectReference(field, (EObject)value);
                    continue;
                }
                this.writeObject(value);
            }
            this.writer.popIndent();
            this.writeElementEnd(elementName);
        }
    }

    void writeObjectValue(EField target, Object object) {
        if (!target.isTransient()) {
            String elementName = target.getName();
            this.writer.print('<');
            this.writer.print(elementName);
            this.writer.print('>');
            if (object instanceof List) {
                this.writer.println();
                this.writeList((List)object);
            } else {
                EMemberContainer eClass = target.getDeclarer();
                if (eClass instanceof DynamicEClass) {
                    object = ((DynamicEClass)eClass).xmlEncodeValue(object);
                }
                this.writeObject(object);
            }
            this.writer.print("</");
            this.writer.print(elementName);
            this.writer.println('>');
        }
    }

    void writeAttributeValue(EField field, Object value) {
        if (value == null || "".equals(value) || field.isTransient()) {
            return;
        }
        this.writer.print(field.getName());
        this.writer.print('=');
        this.writer.print('\"');
        EMemberContainer eClass = field.getDeclarer();
        if (eClass instanceof DynamicEClass) {
            value = ((DynamicEClass)eClass).xmlEncodeValue(value);
        }
        this.writeObject(value);
        this.writer.print("\" ");
    }

    void writeListValue(EField field, List list) {
        for (Object o : list) {
            if (o instanceof MofSerializable && !field.getContainment()) {
                this.writeTypeReference(field, (MofSerializable)o);
                continue;
            }
            if (o instanceof EObject) {
                this.writeEObjectValue(field, (EObject)o);
                continue;
            }
            this.writeObjectValue(field, o);
        }
    }

    void writeElementStart(String name, EObject obj) {
        this.writer.print('<');
        this.writer.print(name);
        this.writer.print(" ID=\"");
        Integer id = this.written.get(obj);
        if (id == null) {
            this.writer.print(this.currentId);
            this.written.put(obj, this.currentId);
            ++this.currentId;
        } else {
            this.writer.print(id);
        }
        this.writer.print("\" ");
    }

    void writeElementEnd(String name) {
        this.writer.print("</");
        this.writer.print(name);
        this.writer.println('>');
    }

    void writeObjectReference(EField target, EObject obj) {
        int id;
        String elementName = target == null ? obj.getEClass().getName() : target.getName();
        this.writer.print('<');
        this.writer.print(elementName);
        this.writer.print(" IDREF=\"");
        if (this.written.containsKey(obj)) {
            id = this.written.get(obj);
        } else {
            this.written.put(obj, this.currentId);
            id = this.currentId++;
        }
        this.writer.print(id);
        this.writer.println("\"/>");
    }

    void writeTypeReference(EField target, MofSerializable obj) {
        this.writer.print('<');
        this.writer.print(target.getName());
        this.writer.print(" href=\"");
        this.writer.print(this.xmlEncode(obj.getMofSerializationKey()));
        this.writer.println("\"/>");
    }

    void writeObjectArray(Object[] arr) {
        this.writer.pushIndent();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.writer.print("<entry>");
            this.writeObject(obj);
            this.writer.println("</entry>");
            ++n2;
        }
        this.writer.popIndent();
    }

    void writeList(List arr) {
        this.writer.pushIndent();
        for (Object obj : arr) {
            this.writer.print("<entry>");
            this.writeObject(obj);
            this.writer.println("</entry>");
        }
        this.writer.popIndent();
    }
}

