/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.gen.generator.egl.Java2EGL;
import org.eclipse.edt.ide.core.EDTCorePreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * Subclass of the base Java generator command to do certain things in the Eclipse way.
 */
public class EclipseJava2EGL extends Java2EGL {

	private ClassLoader classLoader;
	
	public EclipseJava2EGL(ClassLoader classLoader) {
		super();
		this.classLoader = classLoader;
	}

	@Override
	protected ClassLoader getClassLoader() {
		return classLoader;
	}
	
	public static String[] buildArgs(IProject project, String className) throws Exception {
		String[] args = new String[6];
		
		// Output directory (e.g. JavaSource folder). This is a property on the project, and it might be a directory in some other folder.
		args[0] = "-o"; //$NON-NLS-1$
		IPreferenceStore store = EDTCorePreferenceConstants.getPreferenceStore();
		String eglSourceFolder = store.getString(EDTCorePreferenceConstants.EGL_SOURCE_FOLDER); 

		args[1] = project.getFolder(eglSourceFolder).getProjectRelativePath().toOSString();
		
		// this isn't used but it's a required parameter.
		args[2] = "-p"; //$NON-NLS-1$
		args[3] = className;
		
		// this isn't used but it's a required parameter.
		args[4] = "-r"; //$NON-NLS-1$
		args[5] = args[1];
		
		return args;
	}
}
