/*******************************************************************************
 * Copyright (c) 2005, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.edt.ide.ui.internal.actions;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class ClassFiles {
//	private String loc;

	public static List<String> getClassList(String projectClassLocation, String startingFolder){
		List<String> classes = new ArrayList<String>();
		addClasses(startingFolder, projectClassLocation, classes);
		return classes;
	}

	private static void addClasses(final String folder, final String root, final List<String> classes){
		FileFilter fileFilter = new FileFilter(){
			public boolean accept( File file ){
				return !file.isDirectory() && 
							file.exists() &&
							file.getName().endsWith(".class");
			}
		};

		File[] files = new File( root + File.separatorChar + folder ).listFiles( fileFilter );
		if(files != null){
			for(File file : files){
				try{
					String qualifiedName = folder + (folder.length() > 0 ? File.separatorChar : "");
					qualifiedName += file.getName().replace(".class", "");
					classes.add(qualifiedName);
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		FileFilter directoryFilter = new FileFilter(){
			public boolean accept( File file ){
				return file.isDirectory();
			}
		};
		File[] directories = new File( root + File.separatorChar + folder ).listFiles( directoryFilter );
		if(directories != null){
			for(File directory : directories){
				String qualifiedName = folder + (folder.length() > 0 ? File.separatorChar : "");
				qualifiedName += directory.getName();
				addClasses(qualifiedName, root, classes);
			}
		}
	}
	
}
