/*
 * Licensed Materials - Property of IBM
 *
 * Copyright IBM Corporation 2008, 2010. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA DP Schedule Contract with IBM Corp.
 */
package org.eclipse.edt.ide.ui.internal.actions;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.ui.internal.wsdl.WsImport;
import org.eclipse.jface.action.IAction;


public class Wsdl2EglAction extends Java2EglAction {

	public void run(IAction action) {
		try{
			IResource resource;
			for (Iterator<IResource> iter = fSelection.iterator(); iter.hasNext();) {
				resource = iter.next();
				if (resource != null) {	
					if(resource instanceof IAdaptable){
						IAdaptable adaptable = (IAdaptable)resource;
						IFile file = (IFile)adaptable.getAdapter(IFile.class);
						if(file != null){
							WsImport.wsimport(file);
							IPath root = file.getProject().getLocation().append(".wsImportBin"); 
							IPath relativePath =  new Path("");
							createEglIR(root, file.getProject(), relativePath);
						}
					}
				}
			}	
		}
		catch( Exception e ) {
			e.printStackTrace();
		}
	}
}
