/*******************************************************************************
 * Copyright (c) 2005, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.edt.ide.ui.internal.wsdl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.widgets.Display;

public class WsImport {

	public static void wsimport(IFile file){
		try{
			ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
			ILaunchConfiguration[] configs = manager.getLaunchConfigurations();
			ILaunchConfiguration launch = null;
			for(ILaunchConfiguration l : configs){
				if("wsimport".equalsIgnoreCase(l.getName())){
					launch = l;
					break;
				}
			}
			
			if(launch != null){
				final ILaunchConfigurationWorkingCopy workingCopy = launch.getWorkingCopy();
				workingCopy.setAttribute( IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, file.getProject().getName() );
				workingCopy.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, false);
				workingCopy.setAttribute(IDebugUIConstants.ATTR_CONSOLE_PROCESS, "ws__import");
				workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-keep");
				workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-verbose");
				workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-d " + file.getProject().getLocation().toOSString() + "/.wsImportBin");
				workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-s " + file.getProject().getLocation().toOSString() + "/.wsImportSrc");
				workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, file.getLocation().toOSString());
				Display.getDefault().syncExec(
						new Runnable()
						{
							public void run()
							{
								DebugUITools.launch(workingCopy, ILaunchManager.RUN_MODE);
							}
						}
				);
			}
		} catch (CoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
