/*******************************************************************************
 * Copyright © 2000, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.core.internal.model.index.impl;

import java.io.File;
import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

/**
 * An <code>JarFileDocument</code> represents an jar file.
 */

public class JarFileDocument extends PropertyDocument {
	protected IFile file;
	/**
	 * JarFileDocument constructor comment.
	 */
	public JarFileDocument(IFile file) {
		this.file = file;
	}
	/**
	 * This API always return null for a JarFileDocument
	 * @see org.eclipse.edt.ide.core.internal.model.index.jdt.internal.core.index.IDocument#getByteContent()
	 */
	public byte[] getByteContent() throws IOException {
		return null;
	}
	/**
	 * This API always return null for a JarFileDocument
	 * @see org.eclipse.edt.ide.core.internal.model.index.jdt.internal.core.index.IDocument#getCharContent()
	 */
	public char[] getCharContent() throws IOException {
		return null;
	}
	/**
	 * @see org.eclipse.edt.ide.core.internal.model.index.jdt.internal.core.index.IDocument#getEncoding()
	 */
	public String getEncoding() {
		return null;
	}

	public File getFile() {
		IPath location = file.getLocation();
		if (location == null) {
			return null;
		} else {
			return location.toFile();
		}
	}
	/**
	 * @see org.eclipse.edt.ide.core.internal.model.index.jdt.internal.core.index.IDocument#getName()
	 */
	public String getName() {
		return file.getFullPath().toString();
	}
	/**
	 * This API always return null for a JarFileDocument
	 * @see org.eclipse.edt.ide.core.internal.model.index.jdt.internal.core.index.IDocument#getByteContent()
	 */
	public String getStringContent() throws java.io.IOException {
		return null;
	}
	/**
	 * @see org.eclipse.edt.ide.core.internal.model.index.jdt.internal.core.index.IDocument#getType()
	 */
	public String getType() {
		String extension= file.getFileExtension();
		if (extension == null)
			return ""; //$NON-NLS-1$
		return extension;
	}
}
