/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;

public class ProjectInfoManager {
    private static ProjectInfoManager INSTANCE = new ProjectInfoManager();
    private HashMap projectInfoMap = new HashMap(5);

    public static ProjectInfoManager getInstance() {
        return INSTANCE;
    }

    private ProjectInfoManager() {
    }

    public ProjectInfo getProjectInfo(IProject project) {
        ProjectInfo prjInfo = (ProjectInfo)this.projectInfoMap.get(project);
        if (prjInfo == null) {
            prjInfo = new ProjectInfo(project);
            this.projectInfoMap.put(project, prjInfo);
        }
        return prjInfo;
    }

    public ProjectInfo getProjectInfo(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return this.getProjectInfo(project);
    }

    public void clear(IProject project) {
        ProjectInfo prjInfo = (ProjectInfo)this.projectInfoMap.get(project);
        if (prjInfo != null) {
            prjInfo.clear();
        }
    }

    public void remove(IProject project) {
        this.projectInfoMap.remove(project);
    }

    public void clearAll() {
        this.projectInfoMap.clear();
    }

    public int getCount() {
        return this.projectInfoMap.size();
    }
}

