/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.lookup.AbstractFileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;

public class WorkingCopyFileInfoManager
extends AbstractFileInfoManager {
    protected static final IPath STATE_FILE = EDTCoreIDEPlugin.getPlugin().getStateLocation().append(".wcfileinfo");
    protected static final String SAVED_FILE_INFO_FOLDER = "wcfileinfo";
    protected static final String SAVED_FILE_INFO_FILE_EXTENSION = "fi";
    private static WorkingCopyFileInfoManager INSTANCE = new WorkingCopyFileInfoManager();
    private HashMap wcFileInfoCache = new HashMap();

    private WorkingCopyFileInfoManager() {
        super(SAVED_FILE_INFO_FOLDER, SAVED_FILE_INFO_FILE_EXTENSION);
    }

    public static WorkingCopyFileInfoManager getInstance() {
        return INSTANCE;
    }

    public boolean hasValidState() {
        File file = STATE_FILE.toFile();
        if (file.exists()) {
            try {
                DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                int state = -1;
                try {
                    state = inputStream.readInt();
                }
                finally {
                    inputStream.close();
                }
                return state == 2;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public void setState(boolean validState) {
        File file = STATE_FILE.toFile();
        if (validState) {
            try {
                DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                try {
                    outputStream.writeInt(2);
                }
                finally {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    @Override
    public IFileInfo getFileInfo(IProject project, IPath projectRelativeFilePath) {
        Map cacheEntry = (Map)this.wcFileInfoCache.get(project);
        if (cacheEntry != null) {
            IFileInfo result = (IFileInfo)cacheEntry.get(projectRelativeFilePath);
            if (result != null) {
                return result;
            }
            return super.getFileInfo(project, projectRelativeFilePath);
        }
        return super.getFileInfo(project, projectRelativeFilePath);
    }

    public void addFileInfo(IProject project, IPath projectRelativeFilePath, IFileInfo fileInfo) {
        HashMap<IPath, IFileInfo> cacheEntry = (HashMap<IPath, IFileInfo>)this.wcFileInfoCache.get(project);
        if (cacheEntry == null) {
            cacheEntry = new HashMap<IPath, IFileInfo>();
            this.wcFileInfoCache.put(project, cacheEntry);
        }
        cacheEntry.put(projectRelativeFilePath, fileInfo);
    }

    public void resetWorkingCopies() {
        this.wcFileInfoCache = new HashMap();
    }

    public boolean hasIndexedProject(IProject project) {
        return this.getSavedFileInfoFolder(project).toFile().exists();
    }
}

