/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.BufferManager;
import org.eclipse.edt.ide.core.internal.model.CreateWorkingCopyOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLFileStructureRequestor;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.ImportContainer;
import org.eclipse.edt.ide.core.internal.model.ImportDeclaration;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageDeclaration;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.SourceElementParser;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IImportContainer;
import org.eclipse.edt.ide.core.model.IImportDeclaration;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IProblemRequestor;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.ISourceReference;
import org.eclipse.edt.ide.core.model.Signature;

public class EGLFile
extends Openable
implements IEGLFile,
IDocument {
    public static boolean SHARED_WC_VERBOSE = false;

    protected EGLFile(IPackageFragment parent, String name) {
        super(6, parent, name);
        if (!Util.isEGLFileName(name)) {
            throw new IllegalArgumentException(EGLModelResources.conventionUnitNotEGLName);
        }
    }

    @Override
    protected void buildStructure(OpenableElementInfo info, IProgressMonitor monitor) throws EGLModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        EGLModelManager.getEGLModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        for (IEGLElement key : newElements.keySet()) {
            Object value = newElements.get(key);
            EGLModelManager.getEGLModelManager().putInfo(key, value);
        }
        EGLModelManager.getEGLModelManager().putInfo(this, info);
    }

    @Override
    public void commit(boolean force, IProgressMonitor monitor) throws EGLModelException {
        throw new EGLModelException(new EGLModelStatus(967, this));
    }

    @Override
    public void copy(IEGLElement container, IEGLElement sibling, String rename, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (container == null) {
            throw new IllegalArgumentException(EGLModelResources.operationNullContainer);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] containers = new IEGLElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getEGLModel().copy(elements, containers, null, renamings, force, monitor);
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new EGLFileElementInfo();
    }

    @Override
    public IImportDeclaration createImport(String name, IEGLElement sibling, IProgressMonitor monitor) throws EGLModelException {
        return null;
    }

    @Override
    public IPackageDeclaration createPackageDeclaration(String name, IProgressMonitor monitor) throws EGLModelException {
        return null;
    }

    @Override
    public IPart createPart(String content, IEGLElement sibling, boolean force, IProgressMonitor monitor) throws EGLModelException {
        return null;
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws EGLModelException {
        IEGLElement[] elements = new IEGLElement[]{this};
        this.getEGLModel().delete(elements, force, monitor);
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && !((IEGLFile)o).isWorkingCopy();
    }

    @Override
    public IEGLElement[] findElements(IEGLElement element) {
        ArrayList<IEGLElement> children = new ArrayList<IEGLElement>();
        while (element != null && element.getElementType() != 6) {
            children.add(element);
            element = element.getParent();
        }
        if (element == null) {
            return null;
        }
        ISourceReference currentElement = this;
        int i = children.size() - 1;
        while (i >= 0) {
            IEGLElement child = (IEGLElement)children.get(i);
            switch (child.getElementType()) {
                case 12: {
                    currentElement = ((IEGLFile)currentElement).getPackageDeclaration(child.getElementName());
                    break;
                }
                case 13: {
                    currentElement = ((IEGLFile)currentElement).getImportContainer();
                    break;
                }
                case 14: {
                    currentElement = ((IImportContainer)currentElement).getImport(child.getElementName());
                    break;
                }
                case 8: {
                    if (currentElement.getElementType() == 6) {
                        currentElement = ((IEGLFile)currentElement).getPart(child.getElementName());
                        break;
                    }
                    currentElement = ((IPart)currentElement).getPart(child.getElementName());
                    break;
                }
                case 9: {
                    currentElement = ((IPart)currentElement).getField(child.getElementName());
                    break;
                }
                case 10: {
                    return ((IPart)currentElement).findFunctions((IFunction)child);
                }
            }
            --i;
        }
        if (currentElement != null && currentElement.exists()) {
            return new IEGLElement[]{currentElement};
        }
        return null;
    }

    @Override
    public IPart findPrimaryPart() {
        String typeName = Signature.getQualifier(this.getElementName());
        IPart primaryPart = this.getPart(typeName);
        if (primaryPart.exists()) {
            return primaryPart;
        }
        return null;
    }

    @Override
    public IEGLElement findSharedWorkingCopy(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = this.getBufferManager().getDefaultBufferFactory();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = EGLModelManager.getEGLModelManager().sharedWorkingCopies).get(factory)) == null) {
            return null;
        }
        return (WorkingCopy)perFactoryWorkingCopies.get(this);
    }

    @Override
    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws EGLModelException {
        EGLModelManager.getEGLModelManager().putInfo(this, info);
        EGLFileElementInfo unitInfo = (EGLFileElementInfo)info;
        EGLFileStructureRequestor requestor = new EGLFileStructureRequestor(this, unitInfo, newElements);
        SourceElementParser parser = new SourceElementParser(requestor);
        parser.parseEGLFile(this);
        if (this.isWorkingCopy()) {
            EGLFile original = (EGLFile)this.getOriginalElement();
            unitInfo.fTimestamp = ((IFile)original.getResource()).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    @Override
    public IPart[] getAllParts() throws EGLModelException {
        return this.getParts();
    }

    @Override
    public IEGLFile getEGLFile() {
        return this;
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (EGLModelException eGLModelException) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public IResource getCorrespondingResource() throws EGLModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    @Override
    public IEGLElement getElementAt(int position) throws EGLModelException {
        IEGLElement e = this.getSourceElementAt(position);
        if (e == this) {
            return null;
        }
        return e;
    }

    public char[] getFileName() {
        return this.getElementName().toCharArray();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '{';
    }

    @Override
    public IImportDeclaration getImport(String name) {
        return new ImportDeclaration(this.getImportContainer(), name);
    }

    @Override
    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    @Override
    public IImportDeclaration[] getImports() throws EGLModelException {
        IImportContainer container = this.getImportContainer();
        if (container.exists()) {
            IEGLElement[] elements = container.getChildren();
            IImportDeclaration[] imprts = new IImportDeclaration[elements.length];
            System.arraycopy(elements, 0, imprts, 0, elements.length);
            return imprts;
        }
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return new IImportDeclaration[0];
    }

    public char[] getMainPartName() {
        String name = this.getElementName();
        name = name.substring(0, name.length() - 5);
        return name.toCharArray();
    }

    @Override
    public IEGLElement getOriginal(IEGLElement workingCopyElement) {
        return null;
    }

    @Override
    public IEGLElement getOriginalElement() {
        return null;
    }

    @Override
    public IPackageDeclaration getPackageDeclaration(String name) {
        return new PackageDeclaration(this, name);
    }

    @Override
    public IPackageDeclaration[] getPackageDeclarations() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(12);
        IPackageDeclaration[] array = new IPackageDeclaration[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getPackageName() {
        IPackageFragment packageFragment = (IPackageFragment)this.getAncestor(4);
        String[] packageName = packageFragment.isDefaultPackage() ? new String[]{} : packageFragment.getElementName().split("\\.");
        return packageName;
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    @Override
    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    @Override
    public String getSource() throws EGLModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    @Override
    public ISourceRange getSourceRange() throws EGLModelException {
        return ((EGLFileElementInfo)this.getElementInfo()).getSourceRange();
    }

    @Override
    public IPart getPart(String name) {
        return new SourcePart(this, name);
    }

    @Override
    public IPart[] getParts() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(8);
        IPart[] array = new IPart[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IEGLElement getSharedWorkingCopy(IProgressMonitor pm, IBufferFactory factory, IProblemRequestor problemRequestor) throws EGLModelException {
        WorkingCopy workingCopy;
        if (factory == null) {
            factory = this.getBufferManager().getDefaultBufferFactory();
        }
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        HashMap perFactoryWorkingCopies = (HashMap)sharedWorkingCopies.get(factory);
        if (perFactoryWorkingCopies == null) {
            perFactoryWorkingCopies = new HashMap();
            sharedWorkingCopies.put(factory, perFactoryWorkingCopies);
        }
        if ((workingCopy = (WorkingCopy)perFactoryWorkingCopies.get(this)) != null) {
            ++workingCopy.useCount;
            if (SHARED_WC_VERBOSE) {
                System.out.println("Incrementing use count of shared working copy " + workingCopy.toStringWithAncestors());
            }
            return workingCopy;
        }
        CreateWorkingCopyOperation op = new CreateWorkingCopyOperation(this, perFactoryWorkingCopies, factory, problemRequestor);
        op.runOperation(pm);
        return op.getResultElements()[0];
    }

    @Override
    public IEGLElement getWorkingCopy() throws EGLModelException {
        return this.getWorkingCopy(null, null, null);
    }

    @Override
    public IEGLElement getWorkingCopy(IProgressMonitor pm, IBufferFactory factory, IProblemRequestor problemRequestor) throws EGLModelException {
        CreateWorkingCopyOperation op = new CreateWorkingCopyOperation(this, null, factory, problemRequestor);
        op.runOperation(pm);
        return op.getResultElements()[0];
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    public boolean hasChildren() throws EGLModelException {
        if (this.isOpen()) {
            return this.getChildren().length > 0;
        }
        return true;
    }

    @Override
    public boolean isBasedOn(IResource resource) {
        return false;
    }

    @Override
    public boolean isConsistent() throws EGLModelException {
        return EGLModelManager.getEGLModelManager().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    @Override
    protected boolean isSourceElement() {
        return true;
    }

    @Override
    public boolean isWorkingCopy() {
        return false;
    }

    @Override
    public void makeConsistent(IProgressMonitor monitor) throws EGLModelException {
        if (!this.isConsistent()) {
            OpenableElementInfo info = this.createElementInfo();
            this.buildStructure(info, monitor);
        }
    }

    @Override
    public void move(IEGLElement container, IEGLElement sibling, String rename, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (container == null) {
            throw new IllegalArgumentException(EGLModelResources.operationNullContainer);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] containers = new IEGLElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getEGLModel().move(elements, containers, null, renamings, force, monitor);
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws EGLModelException {
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IFile file = (IFile)this.getResource();
            if (file == null || !file.exists()) {
                throw this.newNotPresentException();
            }
            buffer.setContents(Util.getResourceContentsAsCharArray(file));
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    protected void openParent(IProgressMonitor pm) throws EGLModelException {
        block2: {
            try {
                super.openParent(pm);
            }
            catch (EGLModelException e) {
                if (e.isDoesNotExist()) break block2;
                throw e;
            }
        }
    }

    @Override
    protected boolean parentExists() {
        return true;
    }

    @Override
    public IMarker[] reconcile() throws EGLModelException {
        return null;
    }

    @Override
    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws EGLModelException {
    }

    @Override
    public void rename(String name, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (name == null) {
            throw new IllegalArgumentException(EGLModelResources.operationNullName);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] dests = new IEGLElement[]{this.getParent()};
        String[] renamings = new String[]{name};
        this.getEGLModel().rename(elements, dests, renamings, force, monitor);
    }

    @Override
    public void restore() throws EGLModelException {
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return new EGLFile((IPackageFragment)((EGLElement)this.fParent).rootedAt(project), this.fName);
    }

    public String sourceLocator() {
        return this.getResource().getProjectRelativePath().toString();
    }

    @Override
    public byte[] getByteContent() throws IOException {
        return null;
    }

    @Override
    public char[] getCharContent() throws IOException {
        return this.getContents();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getName() {
        return this.getFileName().toString();
    }

    @Override
    public String getStringContent() throws IOException {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getContents();
        }
        catch (EGLModelException eGLModelException) {
            return "";
        }
    }

    @Override
    public String getType() {
        return "egl";
    }
}

