/*
 * Decompiled with CFR 0.152.
 */
package eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.InvocationException;
import eglx.lang.NullValueException;
import eglx.persistence.sql.SQLDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.resources.Platform;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;

public class SysLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;
    protected static Map<String, RuntimeDeploymentDesc> deploymentDescs = new HashMap<String, RuntimeDeploymentDesc>();
    protected static Map<QName, Binding> resources = new HashMap<QName, Binding>();
    private static ResourceLocator resourceLocator;

    public static String getProperty(String propertyName) {
        String value = org.eclipse.edt.javart.Runtime.getRunUnit().getProperties().get(propertyName.trim());
        if (value == null) {
            value = System.getProperty(propertyName.trim());
        }
        return value;
    }

    public static void wait(BigDecimal time) {
        time = time.movePointRight(2);
        time = new BigDecimal(BigInteger.valueOf(time.longValue()));
        try {
            Thread.sleep(time.longValue() * 10L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public static int callCmd(String commandString) throws AnyException {
        return SysLib.runCommand(commandString, true, true);
    }

    public static void startCmd(String commandString) throws AnyException {
        SysLib.runCommand(commandString, true, false);
    }

    private static int runCommand(String commandString, boolean lineMode, boolean wait) throws AnyException {
        Process proc;
        try {
            String[] stringArray;
            Runtime runtime = Runtime.getRuntime();
            if (Platform.SYSTEM_TYPE == "WIN     ") {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "cmd";
                stringArray2[1] = "/c";
                stringArray = stringArray2;
                stringArray2[2] = commandString;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "/bin/sh";
                stringArray3[1] = "-c";
                stringArray = stringArray3;
                stringArray3[2] = commandString;
            }
            proc = runtime.exec(stringArray);
        }
        catch (IOException ex) {
            InvocationException ix = new InvocationException();
            ix.name = commandString;
            ix.initCause(ex);
            throw ix.fillInMessage("EGL0015E", commandString, ex);
        }
        if (wait) {
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getErrorStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getInputStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            try {
                return proc.waitFor();
            }
            catch (InterruptedException ex) {
                InvocationException ix = new InvocationException();
                ix.name = commandString;
                ix.initCause(ex);
                throw ix.fillInMessage("EGL0015E", commandString, ex);
            }
        }
        return 0;
    }

    public static String getMessage(String key) {
        return SysLib.getMessage(key, null);
    }

    public static String getMessage(String key, List<String> inserts) {
        Object[] insertStrings = null;
        if (inserts != null) {
            insertStrings = new String[inserts.size()];
            int i = 0;
            while (i < insertStrings.length) {
                insertStrings[i] = inserts.get(i);
                ++i;
            }
        }
        key = key.trim();
        String message = org.eclipse.edt.javart.Runtime.getRunUnit().getLocalizedText().getMessage(key, insertStrings);
        return message;
    }

    public static void commit() throws AnyException {
        org.eclipse.edt.javart.Runtime.getRunUnit().commit();
    }

    public static void rollback() throws AnyException {
        org.eclipse.edt.javart.Runtime.getRunUnit().rollback();
    }

    public static void setLocale(String languageCode) {
        Locale locale = new Locale(languageCode);
        org.eclipse.edt.javart.Runtime.getRunUnit().switchLocale(locale);
    }

    public static void setLocale(String languageCode, String countryCode) {
        Locale locale = new Locale(languageCode, countryCode);
        org.eclipse.edt.javart.Runtime.getRunUnit().switchLocale(locale);
    }

    public static void setLocale(String languageCode, String countryCode, String variant) {
        Locale locale = new Locale(languageCode, countryCode, variant);
        org.eclipse.edt.javart.Runtime.getRunUnit().switchLocale(locale);
    }

    public static void writeStdout(String output) {
        if (output == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        System.out.println(output);
    }

    public static void writeStderr(String output) {
        if (output == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        System.err.println(output);
    }

    public static Object getResource(String bindKey) throws AnyException {
        if (resourceLocator != null) {
            return resourceLocator.locateResource(bindKey);
        }
        String defaultDD = null;
        Executable app = org.eclipse.edt.javart.Runtime.getRunUnit().getActiveExecutable();
        if (app != null) {
            defaultDD = SysLib.getProperty("egl.application.property.file." + app.getClass().getCanonicalName());
        }
        if (defaultDD == null) {
            defaultDD = SysLib.getProperty("egl.application.property.file");
        }
        return SysLib.getResource(bindKey, defaultDD);
    }

    public static Object getResource(String bindingKey, String propertyFileName) throws AnyException {
        propertyFileName = propertyFileName.toLowerCase();
        if (resourceLocator != null) {
            return resourceLocator.locateResource(bindingKey, propertyFileName);
        }
        return SysLib.doGetResource(bindingKey, propertyFileName);
    }

    protected static Object doGetResource(String bindingKey, String propertyFileName) throws AnyException {
        QName resourceId = new QName(propertyFileName, bindingKey);
        Binding binding = resources.get(resourceId);
        if (binding == null) {
            RuntimeDeploymentDesc dd = SysLib.getDeploymentDesc(propertyFileName);
            binding = SysLib.getBinding(bindingKey, dd);
            if (binding == null) {
                binding = SysLib.getBinding(bindingKey, dd.getIncludedDescs());
            }
            if (binding != null) {
                resources.put(resourceId, binding);
            }
        }
        Object resource = null;
        if (resourceLocator != null) {
            resource = resourceLocator.convertToResource(binding);
        }
        if (resource == null && binding instanceof SQLDatabaseBinding) {
            SQLDatabaseBinding sqlBinding = (SQLDatabaseBinding)binding;
            if (sqlBinding.isUseURI()) {
                String uri = sqlBinding.getUri();
                if (uri != null && uri.startsWith("jndi://")) {
                    resource = new SQLDataSource(uri.substring(7));
                }
            } else {
                EDictionary props = new EDictionary();
                String user = sqlBinding.getSqlID();
                String password = sqlBinding.getSqlPassword();
                String schema = sqlBinding.getSqlSchema();
                if (user != null) {
                    props.put("user", user);
                }
                if (password != null) {
                    props.put("password", password);
                }
                resource = new SQLDataSource(sqlBinding.getSqlDB(), props);
                String className = sqlBinding.getSqlJDBCDriverClass();
                if (className != null && className.length() > 0) {
                    try {
                        Class.forName(className);
                    }
                    catch (Throwable throwable) {}
                }
                if (schema != null && (schema = schema.trim()).length() > 0) {
                    ((SQLDataSource)resource).setCurrentSchema(schema);
                }
            }
        }
        return resource;
    }

    private static RuntimeDeploymentDesc getDeploymentDesc(String propertyFileName) {
        if (propertyFileName == null || propertyFileName.length() == 0) {
            AnyException ex = new AnyException();
            throw ex.fillInMessage("EGL0040E", new Object[0]);
        }
        if (resourceLocator != null) {
            return resourceLocator.getDeploymentDesc(propertyFileName);
        }
        RuntimeDeploymentDesc dd = deploymentDescs.get(propertyFileName);
        if (dd == null) {
            InputStream is;
            if (propertyFileName.charAt(0) != '.' && propertyFileName.charAt(0) != '/') {
                propertyFileName = String.valueOf('/') + propertyFileName;
            }
            if (!propertyFileName.endsWith("-bnd.xml")) {
                propertyFileName = String.valueOf(propertyFileName) + "-bnd.xml";
            }
            if ((is = org.eclipse.edt.javart.Runtime.getRunUnit().getClass().getResourceAsStream(propertyFileName)) == null) {
                AnyException ex = new AnyException();
                throw ex.fillInMessage("EGL0041E", propertyFileName);
            }
            try {
                dd = RuntimeDeploymentDesc.createDeploymentDescriptor(propertyFileName, is);
            }
            catch (Exception e) {
                AnyException ex = new AnyException();
                throw ex.fillInMessage("EGL0042E", propertyFileName, e);
            }
            deploymentDescs.put(propertyFileName, dd);
        }
        return dd;
    }

    private static Binding getBinding(String name, List<String> includes) {
        ArrayList<RuntimeDeploymentDesc> includedDDs = new ArrayList<RuntimeDeploymentDesc>();
        Binding binding = null;
        for (String ddName : includes) {
            RuntimeDeploymentDesc includedDD = SysLib.getDeploymentDesc(ddName);
            binding = SysLib.getBinding(name, includedDD);
            if (binding != null) break;
            includedDDs.add(includedDD);
        }
        for (RuntimeDeploymentDesc includedDD : includedDDs) {
            binding = SysLib.getBinding(name, includedDD.getIncludedDescs());
            if (binding != null) break;
        }
        return binding;
    }

    private static Binding getBinding(String name, RuntimeDeploymentDesc dd) {
        for (Binding binding : dd.getBindings()) {
            if (!name.equalsIgnoreCase(binding.getName())) continue;
            return binding;
        }
        return null;
    }

    public static void setResourceLocator(ResourceLocator locator) {
        resourceLocator = locator;
    }

    public static interface ResourceLocator {
        public Object locateResource(String var1);

        public Object locateResource(String var1, String var2);

        public RuntimeDeploymentDesc getDeploymentDesc(String var1);

        public Object convertToResource(Binding var1);
    }
}

