/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.java.JavaObjectException;
import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.lang.InvalidIndexException;
import eglx.lang.TypeCastException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Delegate;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class EList<E>
extends AnyBoxedObject<List<E>> {
    private static final long serialVersionUID = 10L;
    private String signature;
    public static final ListElementFactory<Integer> IntFactory = new ListElementFactory<Integer>(){

        @Override
        public Integer newElement() {
            return 0;
        }
    };
    public static final ListElementFactory<Long> BigintFactory = new ListElementFactory<Long>(){

        @Override
        public Long newElement() {
            return 0L;
        }
    };
    public static final ListElementFactory<Short> SmallintFactory = new ListElementFactory<Short>(){

        @Override
        public Short newElement() {
            return (short)0;
        }
    };
    public static final ListElementFactory<Boolean> BooleanFactory = new ListElementFactory<Boolean>(){

        @Override
        public Boolean newElement() {
            return Boolean.FALSE;
        }
    };
    public static final ListElementFactory<String> StringFactory = new ListElementFactory<String>(){

        @Override
        public String newElement() {
            return "";
        }
    };
    public static final ListElementFactory<Double> FloatFactory = new ListElementFactory<Double>(){

        @Override
        public Double newElement() {
            return 0.0;
        }
    };
    public static final ListElementFactory<Float> SmallfloatFactory = new ListElementFactory<Float>(){

        @Override
        public Float newElement() {
            return Float.valueOf(0.0f);
        }
    };
    public static final ListElementFactory<BigDecimal> DecimalFactory = new ListElementFactory<BigDecimal>(){

        @Override
        public BigDecimal newElement() {
            return BigDecimal.ZERO;
        }
    };
    public static final ListElementFactory<Calendar> DateFactory = new ListElementFactory<Calendar>(){

        @Override
        public Calendar newElement() {
            return EDate.defaultValue();
        }
    };

    private EList(List<E> list, String signature) {
        super(list);
        this.signature = signature;
    }

    public static <T> List<T> ezeNew(Class<? extends T> clazz) {
        return new ArrayList();
    }

    public static <T> List<T> ezeNew(int size, ListElementFactory<? extends T> factory) {
        ArrayList<T> list = new ArrayList<T>(size);
        if (factory != null) {
            int i = 0;
            while (i < size) {
                list.add(factory.newElement());
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                list.add(null);
                ++i;
            }
        }
        return list;
    }

    public static <T> List<T> ezeNew(T ... elements) {
        int size = elements == null ? 0 : elements.length;
        ArrayList<T> list = new ArrayList<T>(size);
        int i = 0;
        while (i < size) {
            list.add(elements[i]);
            ++i;
        }
        return list;
    }

    public static <T> EList<T> ezeBox(List<T> object, String signature) {
        return new EList<T>(object, signature);
    }

    public static boolean ezeIsa(Object object, String signature) {
        return object instanceof EList && ((EList)object).signature.equals(signature);
    }

    public static <T> List<T> ezeCast(Object value, String signature) throws TypeCastException {
        if (EList.ezeIsa(value, signature)) {
            return (List)((EList)value).ezeUnbox();
        }
        TypeCastException tcx = new TypeCastException();
        tcx.castToName = signature;
        Object unboxed = value instanceof eglx.lang.EAny ? ((eglx.lang.EAny)value).ezeUnbox() : value;
        tcx.actualTypeName = unboxed.getClass().getName();
        throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
    }

    @Override
    public eglx.lang.EAny ezeGet(int index) throws AnyException {
        return EAny.asAny(((List)this.ezeUnbox()).get(index));
    }

    public static <T> List<T> appendElement(List<T> list, T element) {
        list.add(element);
        return list;
    }

    public static <T> List<T> appendAll(List<T> list, List<? extends T> other) {
        list.addAll(other);
        return list;
    }

    public static <T> void insertElement(List<T> list, T element, int index) {
        if (index == 0) {
            index = 1;
        }
        if (index < 1 || index - 1 > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        list.add(index - 1, element);
    }

    public static void removeElement(List list, int index) {
        if (index < 1 || index > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        list.remove(index - 1);
    }

    public static void removeAll(List list) {
        list.clear();
    }

    public static <T> void setElement(List<T> list, T value, int index) {
        if (index < 1 || index > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        list.set(index - 1, value);
    }

    public static int getSize(List list) {
        return list.size();
    }

    public static <T> void sort(List<T> list, final Delegate sortFunction) {
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T obj1, T obj2) {
                AnyBoxedObject arg2;
                AnyBoxedObject arg1 = obj1 instanceof eglx.lang.EAny ? (AnyBoxedObject)obj1 : EAny.ezeBox(obj1);
                Object result = sortFunction.invoke(arg1, arg2 = obj2 instanceof eglx.lang.EAny ? (AnyBoxedObject)obj2 : EAny.ezeBox(obj2));
                if (result instanceof Integer) {
                    return (Integer)result;
                }
                if (result instanceof EInt) {
                    return (Integer)((EInt)result).ezeUnbox();
                }
                return 0;
            }
        });
    }

    public static <T> int indexOfElement(List<T> list, T value) {
        return list.indexOf(value) + 1;
    }

    public static <T> int indexOfElement(List<T> list, T value, int index) {
        if (index < 1 || index - 1 > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        return list.subList(index - 1, list.size()).indexOf(value) + index;
    }

    public static <T> List<T> resize(List<T> list, int size, ListElementFactory<? extends T> factory) {
        if (size == 0) {
            list.clear();
        } else if (size > list.size()) {
            if (factory == null) {
                int needed = size - list.size();
                while (needed > 0) {
                    list.add(null);
                    --needed;
                }
            } else {
                int needed = size - list.size();
                while (needed > 0) {
                    list.add(factory.newElement());
                    --needed;
                }
            }
        } else if (size > 0) {
            int index = list.size() - 1;
            while (index >= size) {
                list.remove(index);
                --index;
            }
        } else {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0019E", size);
        }
        return list;
    }

    public static class ElementFactory<EltT>
    implements ListElementFactory<EltT> {
        Class<? extends EltT> elementClass;

        public ElementFactory(Class<? extends EltT> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public EltT newElement() {
            try {
                return this.elementClass.newInstance();
            }
            catch (Exception ex) {
                JavaObjectException jox = new JavaObjectException();
                jox.exceptionType = ex.getClass().getName();
                jox.initCause(ex);
                throw jox.fillInMessage("EGL0008E", ex);
            }
        }
    }

    public static interface ListElementFactory<EltT> {
        public EltT newElement();
    }

    public static class ListFactory<EltT>
    implements ListElementFactory<List<EltT>> {
        int size;
        ListElementFactory<EltT> subFactory;

        public ListFactory(int size, ListElementFactory<EltT> subFactory) {
            this.size = size;
            this.subFactory = subFactory;
        }

        @Override
        public List<EltT> newElement() {
            ArrayList<EltT> element = new ArrayList<EltT>(this.size + 10);
            if (this.subFactory != null) {
                int i = 0;
                while (i < this.size) {
                    element.add(this.subFactory.newElement());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.size) {
                    element.add(null);
                    ++i;
                }
            }
            return element;
        }
    }

    public static class TimestampFactory
    implements ListElementFactory<Calendar> {
        int startCode;
        int endCode;

        public TimestampFactory(int startCode, int endCode) {
            this.startCode = startCode;
            this.endCode = endCode;
        }

        @Override
        public Calendar newElement() {
            return ETimestamp.defaultValue(this.startCode, this.endCode);
        }
    }
}

