/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.BitSet;
import org.eclipse.edt.ide.core.internal.errors.ErrorGrammar;

public class EGLContextBoundaryUtility {
    private static final EGLContextBoundaryUtility INSTANCE = new EGLContextBoundaryUtility();
    private ErrorGrammar grammar = ErrorGrammar.getInstance();
    private BitSet boundaryStatesSet;

    public static EGLContextBoundaryUtility getInstance() {
        return INSTANCE;
    }

    public boolean isBoundaryState(int state) {
        short[] nonterminalCandidates = this.grammar.getNonTerminalCandidates(state);
        int i = 0;
        while (i < nonterminalCandidates.length) {
            if (this.getBoundarySet().get(nonterminalCandidates[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private BitSet getBoundarySet() {
        if (this.boundaryStatesSet == null) {
            this.initBoundaryStatesSet();
        }
        return this.boundaryStatesSet;
    }

    private void initBoundaryStatesSet() {
        this.boundaryStatesSet = new BitSet(500);
        this.boundaryStatesSet.set(29);
        this.boundaryStatesSet.set(64);
        this.boundaryStatesSet.set(43);
        this.boundaryStatesSet.set(65);
        this.boundaryStatesSet.set(88);
        this.boundaryStatesSet.set(87);
        this.boundaryStatesSet.set(51);
        this.boundaryStatesSet.set(60);
        this.boundaryStatesSet.set(32);
        this.boundaryStatesSet.set(31);
        this.boundaryStatesSet.set(73);
        this.boundaryStatesSet.set(72);
        this.boundaryStatesSet.set(37);
        this.boundaryStatesSet.set(8);
        this.boundaryStatesSet.set(76);
        this.boundaryStatesSet.set(14);
        this.boundaryStatesSet.set(86);
        this.boundaryStatesSet.set(82);
        this.boundaryStatesSet.set(74);
        this.boundaryStatesSet.set(38);
        this.boundaryStatesSet.set(19);
        this.boundaryStatesSet.set(40);
        this.boundaryStatesSet.set(50);
        this.boundaryStatesSet.set(5);
        this.boundaryStatesSet.set(94);
        this.boundaryStatesSet.set(17);
        this.boundaryStatesSet.set(24);
        this.boundaryStatesSet.set(18);
        this.boundaryStatesSet.set(36);
        this.boundaryStatesSet.set(90);
        this.boundaryStatesSet.set(67);
        this.boundaryStatesSet.set(34);
        this.boundaryStatesSet.set(23);
        this.boundaryStatesSet.set(45);
        this.boundaryStatesSet.set(20);
        this.boundaryStatesSet.set(63);
        this.boundaryStatesSet.set(61);
        this.boundaryStatesSet.set(25);
        this.boundaryStatesSet.set(71);
        this.boundaryStatesSet.set(81);
        this.boundaryStatesSet.set(80);
        this.boundaryStatesSet.set(52);
        this.boundaryStatesSet.set(91);
    }
}

